/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.io.unserialize.DefaultUnserializer;
import hprose.io.unserialize.Reader;
import hprose.io.unserialize.StringUnserializer;
import hprose.io.unserialize.Unserializer;
import hprose.io.unserialize.ValueReader;
import hprose.util.DateTime;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class HproseDateTimeUnserializer
implements Unserializer {
    public static final HproseDateTimeUnserializer instance = new HproseDateTimeUnserializer();

    HproseDateTimeUnserializer() {
    }

    private static DateTime toDate(Object obj) {
        if (obj instanceof DateTime) {
            return (DateTime)obj;
        }
        if (obj instanceof char[]) {
            return new DateTime(new Date(new String((char[])obj)));
        }
        return new DateTime(new Date(obj.toString()));
    }

    static final DateTime read(Reader reader, ByteBuffer buffer) throws IOException {
        byte tag = buffer.get();
        switch (tag) {
            case 68: {
                return DefaultUnserializer.readDateTime(reader, buffer);
            }
            case 84: {
                return DefaultUnserializer.readTime(reader, buffer);
            }
            case 101: 
            case 110: {
                return null;
            }
            case 115: {
                return new DateTime(new Date(StringUnserializer.readString(reader, buffer)));
            }
            case 114: {
                return HproseDateTimeUnserializer.toDate(reader.readRef(buffer));
            }
        }
        if (tag >= 48 && tag <= 57) {
            return new DateTime(new Date(tag - 48));
        }
        switch (tag) {
            case 105: 
            case 108: {
                return new DateTime(new Date(ValueReader.readLong(buffer)));
            }
            case 100: {
                return new DateTime(new Date(Double.valueOf(ValueReader.readDouble(buffer)).longValue()));
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), DateTime.class);
    }

    static final DateTime read(Reader reader, InputStream stream) throws IOException {
        int tag = stream.read();
        switch (tag) {
            case 68: {
                return DefaultUnserializer.readDateTime(reader, stream);
            }
            case 84: {
                return DefaultUnserializer.readTime(reader, stream);
            }
            case 101: 
            case 110: {
                return null;
            }
            case 115: {
                return new DateTime(new Date(StringUnserializer.readString(reader, stream)));
            }
            case 114: {
                return HproseDateTimeUnserializer.toDate(reader.readRef(stream));
            }
        }
        if (tag >= 48 && tag <= 57) {
            return new DateTime(new Date(tag - 48));
        }
        switch (tag) {
            case 105: 
            case 108: {
                return new DateTime(new Date(ValueReader.readLong(stream)));
            }
            case 100: {
                return new DateTime(new Date(Double.valueOf(ValueReader.readDouble(stream)).longValue()));
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), DateTime.class);
    }

    @Override
    public final Object read(Reader reader, ByteBuffer buffer, Class<?> cls, Type type) throws IOException {
        return HproseDateTimeUnserializer.read(reader, buffer);
    }

    @Override
    public final Object read(Reader reader, InputStream stream, Class<?> cls, Type type) throws IOException {
        return HproseDateTimeUnserializer.read(reader, stream);
    }
}

