/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.io.unserialize.DefaultUnserializer;
import hprose.io.unserialize.Reader;
import hprose.io.unserialize.StringUnserializer;
import hprose.io.unserialize.Unserializer;
import hprose.io.unserialize.ValueReader;
import hprose.util.DateTime;
import hprose.util.TimeZoneUtil;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class InstantUnserializer
implements Unserializer {
    public static final InstantUnserializer instance = new InstantUnserializer();

    InstantUnserializer() {
    }

    private static Instant toInstant(DateTime dt) {
        return OffsetDateTime.of(dt.year, dt.month, dt.day, dt.hour, dt.minute, dt.second, dt.nanosecond, dt.utc ? ZoneOffset.UTC : ZoneOffset.of(TimeZoneUtil.DefaultTZ.getID())).toInstant();
    }

    private static Instant toInstant(Object obj) {
        if (obj instanceof DateTime) {
            return InstantUnserializer.toInstant((DateTime)obj);
        }
        if (obj instanceof char[]) {
            return Instant.parse(new String((char[])obj));
        }
        return Instant.parse(obj.toString());
    }

    static final Instant read(Reader reader, ByteBuffer buffer) throws IOException {
        byte tag = buffer.get();
        switch (tag) {
            case 68: {
                return InstantUnserializer.toInstant(DefaultUnserializer.readDateTime(reader, buffer));
            }
            case 84: {
                return InstantUnserializer.toInstant(DefaultUnserializer.readTime(reader, buffer));
            }
            case 101: 
            case 110: {
                return null;
            }
            case 115: {
                return Instant.parse(StringUnserializer.readString(reader, buffer));
            }
            case 114: {
                return InstantUnserializer.toInstant(reader.readRef(buffer));
            }
        }
        if (tag >= 48 && tag <= 57) {
            return Instant.ofEpochMilli(tag - 48);
        }
        switch (tag) {
            case 105: 
            case 108: {
                return Instant.ofEpochMilli(ValueReader.readLong(buffer));
            }
            case 100: {
                return Instant.ofEpochMilli(Double.valueOf(ValueReader.readDouble(buffer)).longValue());
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), Instant.class);
    }

    static final Instant read(Reader reader, InputStream stream) throws IOException {
        int tag = stream.read();
        switch (tag) {
            case 68: {
                return InstantUnserializer.toInstant(DefaultUnserializer.readDateTime(reader, stream));
            }
            case 84: {
                return InstantUnserializer.toInstant(DefaultUnserializer.readTime(reader, stream));
            }
            case 101: 
            case 110: {
                return null;
            }
            case 115: {
                return Instant.parse(StringUnserializer.readString(reader, stream));
            }
            case 114: {
                return InstantUnserializer.toInstant(reader.readRef(stream));
            }
        }
        if (tag >= 48 && tag <= 57) {
            return Instant.ofEpochMilli(tag - 48);
        }
        switch (tag) {
            case 105: 
            case 108: {
                return Instant.ofEpochMilli(ValueReader.readLong(stream));
            }
            case 100: {
                return Instant.ofEpochMilli(Double.valueOf(ValueReader.readDouble(stream)).longValue());
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), Instant.class);
    }

    @Override
    public final Object read(Reader reader, ByteBuffer buffer, Class<?> cls, Type type) throws IOException {
        return InstantUnserializer.read(reader, buffer);
    }

    @Override
    public final Object read(Reader reader, InputStream stream, Class<?> cls, Type type) throws IOException {
        return InstantUnserializer.read(reader, stream);
    }
}

