/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.io.unserialize.Reader;
import hprose.io.unserialize.StringUnserializer;
import hprose.io.unserialize.Unserializer;
import hprose.io.unserialize.ValueReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IntUnserializer
implements Unserializer {
    public static final IntUnserializer instance = new IntUnserializer();

    static final int read(Reader reader, ByteBuffer buffer, int tag) throws IOException {
        switch (tag) {
            case 108: {
                return ValueReader.readInt(buffer, 59);
            }
            case 100: {
                return Double.valueOf(ValueReader.readDouble(buffer)).intValue();
            }
            case 101: {
                return 0;
            }
            case 116: {
                return 1;
            }
            case 102: {
                return 0;
            }
            case 117: {
                return Integer.parseInt(ValueReader.readUTF8Char(buffer));
            }
            case 115: {
                return Integer.parseInt(StringUnserializer.readString(reader, buffer));
            }
            case 114: {
                return Integer.parseInt(reader.readRef(buffer, String.class));
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), Integer.TYPE);
    }

    static final int read(Reader reader, InputStream stream, int tag) throws IOException {
        switch (tag) {
            case 108: {
                return ValueReader.readInt(stream, 59);
            }
            case 100: {
                return Double.valueOf(ValueReader.readDouble(stream)).intValue();
            }
            case 101: {
                return 0;
            }
            case 116: {
                return 1;
            }
            case 102: {
                return 0;
            }
            case 117: {
                return Integer.parseInt(ValueReader.readUTF8Char(stream));
            }
            case 115: {
                return Integer.parseInt(StringUnserializer.readString(reader, stream));
            }
            case 114: {
                return Integer.parseInt(reader.readRef(stream, String.class));
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), Integer.TYPE);
    }

    public static final int read(Reader reader, ByteBuffer buffer) throws IOException {
        byte tag = buffer.get();
        if (tag >= 48 && tag <= 57) {
            return tag - 48;
        }
        if (tag == 105) {
            return ValueReader.readInt(buffer, 59);
        }
        if (tag == 110) {
            return 0;
        }
        return IntUnserializer.read(reader, buffer, (int)tag);
    }

    public static final int read(Reader reader, InputStream stream) throws IOException {
        int tag = stream.read();
        if (tag >= 48 && tag <= 57) {
            return tag - 48;
        }
        if (tag == 105) {
            return ValueReader.readInt(stream, 59);
        }
        if (tag == 110) {
            return 0;
        }
        return IntUnserializer.read(reader, stream, tag);
    }

    @Override
    public final Object read(Reader reader, ByteBuffer buffer, Class<?> cls, Type type) throws IOException {
        return IntUnserializer.read(reader, buffer);
    }

    @Override
    public final Object read(Reader reader, InputStream stream, Class<?> cls, Type type) throws IOException {
        return IntUnserializer.read(reader, stream);
    }
}

