/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.io.unserialize.DefaultUnserializer;
import hprose.io.unserialize.Reader;
import hprose.io.unserialize.StringUnserializer;
import hprose.io.unserialize.Unserializer;
import hprose.io.unserialize.ValueReader;
import hprose.util.DateTime;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.time.LocalDateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LocalDateTimeUnserializer
implements Unserializer {
    public static final LocalDateTimeUnserializer instance = new LocalDateTimeUnserializer();

    LocalDateTimeUnserializer() {
    }

    private static LocalDateTime toLocalDateTime(DateTime dt) {
        return LocalDateTime.of(dt.year, dt.month, dt.day, dt.hour, dt.minute, dt.second, dt.nanosecond);
    }

    private static LocalDateTime toLocalDateTime(Object obj) {
        if (obj instanceof DateTime) {
            return LocalDateTimeUnserializer.toLocalDateTime((DateTime)obj);
        }
        if (obj instanceof char[]) {
            return LocalDateTime.parse(new String((char[])obj));
        }
        return LocalDateTime.parse(obj.toString());
    }

    static final LocalDateTime read(Reader reader, ByteBuffer buffer) throws IOException {
        byte tag = buffer.get();
        switch (tag) {
            case 68: {
                return LocalDateTimeUnserializer.toLocalDateTime(DefaultUnserializer.readDateTime(reader, buffer));
            }
            case 84: {
                return LocalDateTimeUnserializer.toLocalDateTime(DefaultUnserializer.readTime(reader, buffer));
            }
            case 101: 
            case 110: {
                return null;
            }
            case 115: {
                return LocalDateTime.parse(StringUnserializer.readString(reader, buffer));
            }
            case 114: {
                return LocalDateTimeUnserializer.toLocalDateTime(reader.readRef(buffer));
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), LocalDateTime.class);
    }

    static final LocalDateTime read(Reader reader, InputStream stream) throws IOException {
        int tag = stream.read();
        switch (tag) {
            case 68: {
                return LocalDateTimeUnserializer.toLocalDateTime(DefaultUnserializer.readDateTime(reader, stream));
            }
            case 84: {
                return LocalDateTimeUnserializer.toLocalDateTime(DefaultUnserializer.readTime(reader, stream));
            }
            case 101: 
            case 110: {
                return null;
            }
            case 115: {
                return LocalDateTime.parse(StringUnserializer.readString(reader, stream));
            }
            case 114: {
                return LocalDateTimeUnserializer.toLocalDateTime(reader.readRef(stream));
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), LocalDateTime.class);
    }

    @Override
    public final Object read(Reader reader, ByteBuffer buffer, Class<?> cls, Type type) throws IOException {
        return LocalDateTimeUnserializer.read(reader, buffer);
    }

    @Override
    public final Object read(Reader reader, InputStream stream, Class<?> cls, Type type) throws IOException {
        return LocalDateTimeUnserializer.read(reader, stream);
    }
}

