/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.io.unserialize.DefaultUnserializer;
import hprose.io.unserialize.Reader;
import hprose.io.unserialize.StringUnserializer;
import hprose.io.unserialize.Unserializer;
import hprose.io.unserialize.ValueReader;
import hprose.util.DateTime;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.time.LocalDate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LocalDateUnserializer
implements Unserializer {
    public static final LocalDateUnserializer instance = new LocalDateUnserializer();

    LocalDateUnserializer() {
    }

    private static LocalDate toLocalDate(DateTime dt) {
        return LocalDate.of(dt.year, dt.month, dt.day);
    }

    private static LocalDate toLocalDate(Object obj) {
        if (obj instanceof DateTime) {
            return LocalDateUnserializer.toLocalDate((DateTime)obj);
        }
        if (obj instanceof char[]) {
            return LocalDate.parse(new String((char[])obj));
        }
        return LocalDate.parse(obj.toString());
    }

    static final LocalDate read(Reader reader, ByteBuffer buffer) throws IOException {
        byte tag = buffer.get();
        switch (tag) {
            case 68: {
                return LocalDateUnserializer.toLocalDate(DefaultUnserializer.readDateTime(reader, buffer));
            }
            case 84: {
                return LocalDateUnserializer.toLocalDate(DefaultUnserializer.readTime(reader, buffer));
            }
            case 101: 
            case 110: {
                return null;
            }
            case 115: {
                return LocalDate.parse(StringUnserializer.readString(reader, buffer));
            }
            case 114: {
                return LocalDateUnserializer.toLocalDate(reader.readRef(buffer));
            }
        }
        if (tag >= 48 && tag <= 57) {
            return LocalDate.ofEpochDay(tag - 48);
        }
        switch (tag) {
            case 105: 
            case 108: {
                return LocalDate.ofEpochDay(ValueReader.readLong(buffer));
            }
            case 100: {
                return LocalDate.ofEpochDay(Double.valueOf(ValueReader.readDouble(buffer)).longValue());
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), LocalDate.class);
    }

    static final LocalDate read(Reader reader, InputStream stream) throws IOException {
        int tag = stream.read();
        switch (tag) {
            case 68: {
                return LocalDateUnserializer.toLocalDate(DefaultUnserializer.readDateTime(reader, stream));
            }
            case 84: {
                return LocalDateUnserializer.toLocalDate(DefaultUnserializer.readTime(reader, stream));
            }
            case 101: 
            case 110: {
                return null;
            }
            case 115: {
                return LocalDate.parse(StringUnserializer.readString(reader, stream));
            }
            case 114: {
                return LocalDateUnserializer.toLocalDate(reader.readRef(stream));
            }
        }
        if (tag >= 48 && tag <= 57) {
            return LocalDate.ofEpochDay(tag - 48);
        }
        switch (tag) {
            case 105: 
            case 108: {
                return LocalDate.ofEpochDay(ValueReader.readLong(stream));
            }
            case 100: {
                return LocalDate.ofEpochDay(Double.valueOf(ValueReader.readDouble(stream)).longValue());
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), LocalDate.class);
    }

    @Override
    public final Object read(Reader reader, ByteBuffer buffer, Class<?> cls, Type type) throws IOException {
        return LocalDateUnserializer.read(reader, buffer);
    }

    @Override
    public final Object read(Reader reader, InputStream stream, Class<?> cls, Type type) throws IOException {
        return LocalDateUnserializer.read(reader, stream);
    }
}

