/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.io.unserialize.DefaultUnserializer;
import hprose.io.unserialize.Reader;
import hprose.io.unserialize.StringUnserializer;
import hprose.io.unserialize.Unserializer;
import hprose.io.unserialize.ValueReader;
import hprose.util.DateTime;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.time.LocalTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LocalTimeUnserializer
implements Unserializer {
    public static final LocalTimeUnserializer instance = new LocalTimeUnserializer();

    LocalTimeUnserializer() {
    }

    private static LocalTime toLocalTime(DateTime dt) {
        return LocalTime.of(dt.hour, dt.minute, dt.second, dt.nanosecond);
    }

    private static LocalTime toLocalTime(Object obj) {
        if (obj instanceof DateTime) {
            return LocalTimeUnserializer.toLocalTime((DateTime)obj);
        }
        if (obj instanceof char[]) {
            return LocalTime.parse(new String((char[])obj));
        }
        return LocalTime.parse(obj.toString());
    }

    static final LocalTime read(Reader reader, ByteBuffer buffer) throws IOException {
        byte tag = buffer.get();
        switch (tag) {
            case 68: {
                return LocalTimeUnserializer.toLocalTime(DefaultUnserializer.readDateTime(reader, buffer));
            }
            case 84: {
                return LocalTimeUnserializer.toLocalTime(DefaultUnserializer.readTime(reader, buffer));
            }
            case 101: 
            case 110: {
                return null;
            }
            case 115: {
                return LocalTime.parse(StringUnserializer.readString(reader, buffer));
            }
            case 114: {
                return LocalTimeUnserializer.toLocalTime(reader.readRef(buffer));
            }
        }
        if (tag >= 48 && tag <= 57) {
            return LocalTime.ofNanoOfDay(tag - 48);
        }
        switch (tag) {
            case 105: 
            case 108: {
                return LocalTime.ofNanoOfDay(ValueReader.readLong(buffer));
            }
            case 100: {
                return LocalTime.ofNanoOfDay(Double.valueOf(ValueReader.readDouble(buffer)).longValue());
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), LocalTime.class);
    }

    static final LocalTime read(Reader reader, InputStream stream) throws IOException {
        int tag = stream.read();
        switch (tag) {
            case 68: {
                return LocalTimeUnserializer.toLocalTime(DefaultUnserializer.readDateTime(reader, stream));
            }
            case 84: {
                return LocalTimeUnserializer.toLocalTime(DefaultUnserializer.readTime(reader, stream));
            }
            case 101: 
            case 110: {
                return null;
            }
            case 115: {
                return LocalTime.parse(StringUnserializer.readString(reader, stream));
            }
            case 114: {
                return LocalTimeUnserializer.toLocalTime(reader.readRef(stream));
            }
        }
        if (tag >= 48 && tag <= 57) {
            return LocalTime.ofNanoOfDay(tag - 48);
        }
        switch (tag) {
            case 105: 
            case 108: {
                return LocalTime.ofNanoOfDay(ValueReader.readLong(stream));
            }
            case 100: {
                return LocalTime.ofNanoOfDay(Double.valueOf(ValueReader.readDouble(stream)).longValue());
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), LocalTime.class);
    }

    @Override
    public final Object read(Reader reader, ByteBuffer buffer, Class<?> cls, Type type) throws IOException {
        return LocalTimeUnserializer.read(reader, buffer);
    }

    @Override
    public final Object read(Reader reader, InputStream stream, Class<?> cls, Type type) throws IOException {
        return LocalTimeUnserializer.read(reader, stream);
    }
}

