/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.io.unserialize.Reader;
import hprose.io.unserialize.Unserializer;
import hprose.io.unserialize.ValueReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LocaleUnserializer
implements Unserializer {
    public static final LocaleUnserializer instance = new LocaleUnserializer();

    LocaleUnserializer() {
    }

    private static Locale toLocale(String s) {
        String[] items = s.split("_");
        if (items.length == 1) {
            return new Locale(items[0]);
        }
        if (items.length == 2) {
            return new Locale(items[0], items[1]);
        }
        return new Locale(items[0], items[1], items[2]);
    }

    static final Locale readLocale(Reader reader, ByteBuffer buffer) throws IOException {
        Locale locale = LocaleUnserializer.toLocale(ValueReader.readString(buffer));
        reader.refer.set(locale);
        return locale;
    }

    static final Locale readLocale(Reader reader, InputStream stream) throws IOException {
        Locale locale = LocaleUnserializer.toLocale(ValueReader.readString(stream));
        reader.refer.set(locale);
        return locale;
    }

    private static Locale toLocale(Object obj) {
        if (obj instanceof Locale) {
            return (Locale)obj;
        }
        if (obj instanceof char[]) {
            return LocaleUnserializer.toLocale(new String((char[])obj));
        }
        return LocaleUnserializer.toLocale(obj.toString());
    }

    static final Locale read(Reader reader, ByteBuffer buffer) throws IOException {
        byte tag = buffer.get();
        switch (tag) {
            case 101: 
            case 110: {
                return null;
            }
            case 115: {
                return LocaleUnserializer.readLocale(reader, buffer);
            }
            case 114: {
                return LocaleUnserializer.toLocale(reader.readRef(buffer));
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), Locale.class);
    }

    static final Locale read(Reader reader, InputStream stream) throws IOException {
        int tag = stream.read();
        switch (tag) {
            case 101: 
            case 110: {
                return null;
            }
            case 115: {
                return LocaleUnserializer.readLocale(reader, stream);
            }
            case 114: {
                return LocaleUnserializer.toLocale(reader.readRef(stream));
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), Locale.class);
    }

    @Override
    public final Object read(Reader reader, ByteBuffer buffer, Class<?> cls, Type type) throws IOException {
        return LocaleUnserializer.read(reader, buffer);
    }

    @Override
    public final Object read(Reader reader, InputStream stream, Class<?> cls, Type type) throws IOException {
        return LocaleUnserializer.read(reader, stream);
    }
}

