/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.io.unserialize.DefaultUnserializer;
import hprose.io.unserialize.Reader;
import hprose.io.unserialize.StringUnserializer;
import hprose.io.unserialize.Unserializer;
import hprose.io.unserialize.ValueReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LongUnserializer
implements Unserializer {
    public static final LongUnserializer instance = new LongUnserializer();

    static final long read(Reader reader, ByteBuffer buffer, int tag) throws IOException {
        switch (tag) {
            case 100: {
                return Double.valueOf(ValueReader.readDouble(buffer)).longValue();
            }
            case 101: {
                return 0L;
            }
            case 116: {
                return 1L;
            }
            case 102: {
                return 0L;
            }
            case 68: {
                return DefaultUnserializer.readDateTime(reader, buffer).toLong();
            }
            case 84: {
                return DefaultUnserializer.readTime(reader, buffer).toLong();
            }
            case 117: {
                return Long.parseLong(ValueReader.readUTF8Char(buffer));
            }
            case 115: {
                return Long.parseLong(StringUnserializer.readString(reader, buffer));
            }
            case 114: {
                return Long.parseLong(reader.readRef(buffer, String.class));
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), Long.TYPE);
    }

    static final long read(Reader reader, InputStream stream, int tag) throws IOException {
        switch (tag) {
            case 100: {
                return Double.valueOf(ValueReader.readDouble(stream)).longValue();
            }
            case 101: {
                return 0L;
            }
            case 116: {
                return 1L;
            }
            case 102: {
                return 0L;
            }
            case 68: {
                return DefaultUnserializer.readDateTime(reader, stream).toLong();
            }
            case 84: {
                return DefaultUnserializer.readTime(reader, stream).toLong();
            }
            case 117: {
                return Long.parseLong(ValueReader.readUTF8Char(stream));
            }
            case 115: {
                return Long.parseLong(StringUnserializer.readString(reader, stream));
            }
            case 114: {
                return Long.parseLong(reader.readRef(stream, String.class));
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), Long.TYPE);
    }

    public static final long read(Reader reader, ByteBuffer buffer) throws IOException {
        byte tag = buffer.get();
        if (tag >= 48 && tag <= 57) {
            return tag - 48;
        }
        if (tag == 105 || tag == 108) {
            return ValueReader.readLong(buffer, 59);
        }
        if (tag == 110) {
            return 0L;
        }
        return LongUnserializer.read(reader, buffer, (int)tag);
    }

    public static final long read(Reader reader, InputStream stream) throws IOException {
        int tag = stream.read();
        if (tag >= 48 && tag <= 57) {
            return tag - 48;
        }
        if (tag == 105 || tag == 108) {
            return ValueReader.readLong(stream, 59);
        }
        if (tag == 110) {
            return 0L;
        }
        return LongUnserializer.read(reader, stream, tag);
    }

    @Override
    public final Object read(Reader reader, ByteBuffer buffer, Class<?> cls, Type type) throws IOException {
        return LongUnserializer.read(reader, buffer);
    }

    @Override
    public final Object read(Reader reader, InputStream stream, Class<?> cls, Type type) throws IOException {
        return LongUnserializer.read(reader, stream);
    }
}

