/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.common.HproseException;
import hprose.io.accessor.ConstructorAccessor;
import hprose.io.unserialize.DefaultUnserializer;
import hprose.io.unserialize.ObjectUnserializer;
import hprose.io.unserialize.Reader;
import hprose.io.unserialize.Unserializer;
import hprose.io.unserialize.UnserializerFactory;
import hprose.io.unserialize.ValueReader;
import hprose.util.ClassUtil;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MapUnserializer
implements Unserializer {
    public static final MapUnserializer instance = new MapUnserializer();

    MapUnserializer() {
    }

    private static <K, V> Map<K, V> readListAsMap(Reader reader, ByteBuffer buffer, Class<?> cls, Class<K> keyClass, Class<V> valueClass, Type valueType) throws IOException {
        int count = ValueReader.readInt(buffer, 123);
        Map m = (Map)ConstructorAccessor.newInstance(cls);
        reader.refer.set(m);
        if (count > 0) {
            if (!(keyClass.equals(Integer.TYPE) || keyClass.equals(Integer.class) || keyClass.equals(String.class) || keyClass.equals(Object.class))) {
                throw ValueReader.castError(reader.tagToString(97), cls);
            }
            Unserializer valueUnserializer = UnserializerFactory.get(valueClass);
            for (int i = 0; i < count; ++i) {
                Object key = keyClass.equals(String.class) ? String.valueOf(i) : Integer.valueOf(i);
                Object value = valueUnserializer.read(reader, buffer, valueClass, valueType);
                m.put(key, value);
            }
        }
        buffer.get();
        return m;
    }

    private static <K, V> Map<K, V> readListAsMap(Reader reader, InputStream stream, Class<?> cls, Class<K> keyClass, Class<V> valueClass, Type valueType) throws IOException {
        int count = ValueReader.readInt(stream, 123);
        Map m = (Map)ConstructorAccessor.newInstance(cls);
        reader.refer.set(m);
        if (count > 0) {
            if (!(keyClass.equals(Integer.TYPE) || keyClass.equals(Integer.class) || keyClass.equals(String.class) || keyClass.equals(Object.class))) {
                throw ValueReader.castError(reader.tagToString(97), cls);
            }
            Unserializer valueUnserializer = UnserializerFactory.get(valueClass);
            for (int i = 0; i < count; ++i) {
                Object key = keyClass.equals(String.class) ? String.valueOf(i) : Integer.valueOf(i);
                Object value = valueUnserializer.read(reader, stream, valueClass, valueType);
                m.put(key, value);
            }
        }
        stream.read();
        return m;
    }

    private static Map readObjectAsMap(Reader reader, ByteBuffer buffer, Map map) throws IOException {
        Object c = reader.classref.get(ValueReader.readInt(buffer, 123));
        String[] memberNames = reader.membersref.get(c);
        reader.refer.set(map);
        int count = memberNames.length;
        for (int i = 0; i < count; ++i) {
            map.put(memberNames[i], DefaultUnserializer.read(reader, buffer));
        }
        buffer.get();
        return map;
    }

    private static Map readObjectAsMap(Reader reader, InputStream stream, Map map) throws IOException {
        Object c = reader.classref.get(ValueReader.readInt(stream, 123));
        String[] memberNames = reader.membersref.get(c);
        reader.refer.set(map);
        int count = memberNames.length;
        for (int i = 0; i < count; ++i) {
            map.put(memberNames[i], DefaultUnserializer.read(reader, stream));
        }
        stream.read();
        return map;
    }

    private static <K, V> Map<K, V> readMap(Reader reader, ByteBuffer buffer, Class<?> cls, Class<K> keyClass, Class<V> valueClass, Type keyType, Type valueType) throws IOException {
        int count = ValueReader.readInt(buffer, 123);
        Map m = (Map)ConstructorAccessor.newInstance(cls);
        reader.refer.set(m);
        Unserializer keyUnserializer = UnserializerFactory.get(keyClass);
        Unserializer valueUnserializer = UnserializerFactory.get(valueClass);
        for (int i = 0; i < count; ++i) {
            Object key = keyUnserializer.read(reader, buffer, keyClass, keyType);
            Object value = valueUnserializer.read(reader, buffer, valueClass, valueType);
            m.put(key, value);
        }
        buffer.get();
        return m;
    }

    private static <K, V> Map<K, V> readMap(Reader reader, InputStream stream, Class<?> cls, Class<K> keyClass, Class<V> valueClass, Type keyType, Type valueType) throws IOException {
        int count = ValueReader.readInt(stream, 123);
        Map m = (Map)ConstructorAccessor.newInstance(cls);
        reader.refer.set(m);
        Unserializer keyUnserializer = UnserializerFactory.get(keyClass);
        Unserializer valueUnserializer = UnserializerFactory.get(valueClass);
        for (int i = 0; i < count; ++i) {
            Object key = keyUnserializer.read(reader, stream, keyClass, keyType);
            Object value = valueUnserializer.read(reader, stream, valueClass, valueType);
            m.put(key, value);
        }
        stream.read();
        return m;
    }

    static final <K, V> Map<K, V> read(Reader reader, ByteBuffer buffer, Class<?> cls, Class<K> keyClass, Class<V> valueClass, Type keyType, Type valueType) throws IOException {
        byte tag = buffer.get();
        switch (tag) {
            case 110: {
                return null;
            }
            case 97: {
                return MapUnserializer.readListAsMap(reader, buffer, cls, keyClass, valueClass, valueType);
            }
            case 109: {
                return MapUnserializer.readMap(reader, buffer, cls, keyClass, valueClass, keyType, valueType);
            }
            case 99: {
                ObjectUnserializer.readClass(reader, buffer);
                return MapUnserializer.read(reader, buffer, cls, keyClass, valueClass, keyType, valueType);
            }
            case 111: {
                return MapUnserializer.readObjectAsMap(reader, buffer, (Map)ConstructorAccessor.newInstance(cls));
            }
            case 114: {
                return (Map)reader.readRef(buffer);
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), cls);
    }

    static final <K, V> Map<K, V> read(Reader reader, InputStream stream, Class<?> cls, Class<K> keyClass, Class<V> valueClass, Type keyType, Type valueType) throws IOException {
        int tag = stream.read();
        switch (tag) {
            case 110: {
                return null;
            }
            case 97: {
                return MapUnserializer.readListAsMap(reader, stream, cls, keyClass, valueClass, valueType);
            }
            case 109: {
                return MapUnserializer.readMap(reader, stream, cls, keyClass, valueClass, keyType, valueType);
            }
            case 99: {
                ObjectUnserializer.readClass(reader, stream);
                return MapUnserializer.read(reader, stream, cls, keyClass, valueClass, keyType, valueType);
            }
            case 111: {
                return MapUnserializer.readObjectAsMap(reader, stream, (Map)ConstructorAccessor.newInstance(cls));
            }
            case 114: {
                return (Map)reader.readRef(stream);
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), cls);
    }

    static final Map readMap(Reader reader, ByteBuffer buffer, Class<?> cls, Type type) throws IOException {
        Class valueClass;
        Class keyClass;
        Object valueType;
        Object keyType;
        if (type instanceof ParameterizedType) {
            Type[] argsType = ((ParameterizedType)type).getActualTypeArguments();
            keyType = argsType[0];
            valueType = argsType[1];
            keyClass = ClassUtil.toClass((Type)keyType);
            valueClass = ClassUtil.toClass((Type)valueType);
        } else {
            keyType = Object.class;
            valueType = Object.class;
            keyClass = Object.class;
            valueClass = Object.class;
        }
        return MapUnserializer.read(reader, buffer, cls, keyClass, valueClass, (Type)keyType, (Type)valueType);
    }

    static final Map readMap(Reader reader, InputStream stream, Class<?> cls, Type type) throws IOException {
        Class valueClass;
        Class keyClass;
        Object valueType;
        Object keyType;
        if (type instanceof ParameterizedType) {
            Type[] argsType = ((ParameterizedType)type).getActualTypeArguments();
            keyType = argsType[0];
            valueType = argsType[1];
            keyClass = ClassUtil.toClass((Type)keyType);
            valueClass = ClassUtil.toClass((Type)valueType);
        } else {
            keyType = Object.class;
            valueType = Object.class;
            keyClass = Object.class;
            valueClass = Object.class;
        }
        return MapUnserializer.read(reader, stream, cls, keyClass, valueClass, (Type)keyType, (Type)valueType);
    }

    @Override
    public final Object read(Reader reader, ByteBuffer buffer, Class<?> cls, Type type) throws IOException {
        if (!Modifier.isInterface(cls.getModifiers()) && !Modifier.isAbstract(cls.getModifiers())) {
            return MapUnserializer.readMap(reader, buffer, cls, type);
        }
        throw new HproseException(type.toString() + " is not an instantiable class.");
    }

    @Override
    public final Object read(Reader reader, InputStream stream, Class<?> cls, Type type) throws IOException {
        if (!Modifier.isInterface(cls.getModifiers()) && !Modifier.isAbstract(cls.getModifiers())) {
            return MapUnserializer.readMap(reader, stream, cls, type);
        }
        throw new HproseException(type.toString() + " is not an instantiable class.");
    }
}

