/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.io.unserialize.DefaultUnserializer;
import hprose.io.unserialize.Reader;
import hprose.io.unserialize.StringUnserializer;
import hprose.io.unserialize.Unserializer;
import hprose.io.unserialize.ValueReader;
import hprose.util.DateTime;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.time.MonthDay;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MonthDayUnserializer
implements Unserializer {
    public static final MonthDayUnserializer instance = new MonthDayUnserializer();

    MonthDayUnserializer() {
    }

    private static MonthDay toMonthDay(DateTime dt) {
        return MonthDay.of(dt.month, dt.day);
    }

    private static MonthDay toMonthDay(Object obj) {
        if (obj instanceof DateTime) {
            return MonthDayUnserializer.toMonthDay((DateTime)obj);
        }
        if (obj instanceof char[]) {
            return MonthDay.parse(new String((char[])obj));
        }
        return MonthDay.parse(obj.toString());
    }

    static final MonthDay read(Reader reader, ByteBuffer buffer) throws IOException {
        byte tag = buffer.get();
        switch (tag) {
            case 115: {
                return MonthDay.parse(StringUnserializer.readString(reader, buffer));
            }
            case 68: {
                return MonthDayUnserializer.toMonthDay(DefaultUnserializer.readDateTime(reader, buffer));
            }
            case 84: {
                return MonthDayUnserializer.toMonthDay(DefaultUnserializer.readTime(reader, buffer));
            }
            case 101: 
            case 110: {
                return null;
            }
            case 114: {
                return MonthDayUnserializer.toMonthDay(reader.readRef(buffer));
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), MonthDay.class);
    }

    static final MonthDay read(Reader reader, InputStream stream) throws IOException {
        int tag = stream.read();
        switch (tag) {
            case 115: {
                return MonthDay.parse(StringUnserializer.readString(reader, stream));
            }
            case 68: {
                return MonthDayUnserializer.toMonthDay(DefaultUnserializer.readDateTime(reader, stream));
            }
            case 84: {
                return MonthDayUnserializer.toMonthDay(DefaultUnserializer.readTime(reader, stream));
            }
            case 101: 
            case 110: {
                return null;
            }
            case 114: {
                return MonthDayUnserializer.toMonthDay(reader.readRef(stream));
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), MonthDay.class);
    }

    @Override
    public final Object read(Reader reader, ByteBuffer buffer, Class<?> cls, Type type) throws IOException {
        return MonthDayUnserializer.read(reader, buffer);
    }

    @Override
    public final Object read(Reader reader, InputStream stream, Class<?> cls, Type type) throws IOException {
        return MonthDayUnserializer.read(reader, stream);
    }
}

