/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.io.unserialize.DefaultUnserializer;
import hprose.io.unserialize.Reader;
import hprose.io.unserialize.Unserializer;
import hprose.io.unserialize.ValueReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ObjectArrayUnserializer
implements Unserializer {
    public static final ObjectArrayUnserializer instance = new ObjectArrayUnserializer();

    ObjectArrayUnserializer() {
    }

    static final Object[] readArray(Reader reader, ByteBuffer buffer, int count) throws IOException {
        Object[] a = new Object[count];
        reader.refer.set(a);
        for (int i = 0; i < count; ++i) {
            a[i] = DefaultUnserializer.read(reader, buffer);
        }
        buffer.get();
        return a;
    }

    static final Object[] readArray(Reader reader, InputStream stream, int count) throws IOException {
        Object[] a = new Object[count];
        reader.refer.set(a);
        for (int i = 0; i < count; ++i) {
            a[i] = DefaultUnserializer.read(reader, stream);
        }
        stream.read();
        return a;
    }

    static final Object[] read(Reader reader, ByteBuffer buffer) throws IOException {
        byte tag = buffer.get();
        switch (tag) {
            case 110: {
                return null;
            }
            case 97: {
                return ObjectArrayUnserializer.readArray(reader, buffer, ValueReader.readInt(buffer, 123));
            }
            case 114: {
                return (Object[])reader.readRef(buffer);
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), Array.class);
    }

    static final Object[] read(Reader reader, InputStream stream) throws IOException {
        int tag = stream.read();
        switch (tag) {
            case 110: {
                return null;
            }
            case 97: {
                return ObjectArrayUnserializer.readArray(reader, stream, ValueReader.readInt(stream, 123));
            }
            case 114: {
                return (Object[])reader.readRef(stream);
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), Array.class);
    }

    @Override
    public final Object read(Reader reader, ByteBuffer buffer, Class<?> cls, Type type) throws IOException {
        return ObjectArrayUnserializer.read(reader, buffer);
    }

    @Override
    public final Object read(Reader reader, InputStream stream, Class<?> cls, Type type) throws IOException {
        return ObjectArrayUnserializer.read(reader, stream);
    }
}

