/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.common.HproseException;
import hprose.io.accessor.Accessors;
import hprose.io.accessor.ConstructorAccessor;
import hprose.io.accessor.MemberAccessor;
import hprose.io.unserialize.DefaultUnserializer;
import hprose.io.unserialize.Reader;
import hprose.io.unserialize.StringUnserializer;
import hprose.io.unserialize.Unserializer;
import hprose.io.unserialize.ValueReader;
import hprose.util.ClassUtil;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ObjectUnserializer
implements Unserializer {
    public static final ObjectUnserializer instance = new ObjectUnserializer();

    ObjectUnserializer() {
    }

    private static <T> T readMapAsObject(Reader reader, ByteBuffer buffer, Class<T> type) throws IOException {
        T obj = ConstructorAccessor.newInstance(type);
        if (obj == null) {
            throw new HproseException("Can not make an instance of type: " + type.toString());
        }
        reader.refer.set(obj);
        Map<String, MemberAccessor> members = Accessors.getMembers(type, reader.mode);
        int count = ValueReader.readInt(buffer, 123);
        for (int i = 0; i < count; ++i) {
            MemberAccessor member = members.get(StringUnserializer.read(reader, buffer));
            if (member != null) {
                member.unserialize(reader, buffer, obj);
                continue;
            }
            DefaultUnserializer.read(reader, buffer);
        }
        buffer.get();
        return obj;
    }

    private static <T> T readMapAsObject(Reader reader, InputStream stream, Class<T> type) throws IOException {
        T obj = ConstructorAccessor.newInstance(type);
        if (obj == null) {
            throw new HproseException("Can not make an instance of type: " + type.toString());
        }
        reader.refer.set(obj);
        Map<String, MemberAccessor> members = Accessors.getMembers(type, reader.mode);
        int count = ValueReader.readInt(stream, 123);
        for (int i = 0; i < count; ++i) {
            MemberAccessor member = members.get(StringUnserializer.read(reader, stream));
            if (member != null) {
                member.unserialize(reader, stream, obj);
                continue;
            }
            DefaultUnserializer.read(reader, stream);
        }
        stream.read();
        return obj;
    }

    static final void readClass(Reader reader, ByteBuffer buffer) throws IOException {
        String className = ValueReader.readString(buffer);
        int count = ValueReader.readInt(buffer, 123);
        String[] memberNames = new String[count];
        for (int i = 0; i < count; ++i) {
            memberNames[i] = StringUnserializer.read(reader, buffer);
        }
        buffer.get();
        Class<?> type = ClassUtil.getClass(className);
        Object key = type.equals(Void.TYPE) ? new Object() : type;
        reader.classref.add(key);
        reader.membersref.put(key, memberNames);
    }

    static final void readClass(Reader reader, InputStream stream) throws IOException {
        String className = ValueReader.readString(stream);
        int count = ValueReader.readInt(stream, 123);
        String[] memberNames = new String[count];
        for (int i = 0; i < count; ++i) {
            memberNames[i] = StringUnserializer.read(reader, stream);
        }
        stream.read();
        Class<?> type = ClassUtil.getClass(className);
        Object key = type.equals(Void.TYPE) ? new Object() : type;
        reader.classref.add(key);
        reader.membersref.put(key, memberNames);
    }

    static final Object readObject(Reader reader, ByteBuffer buffer, Class<?> type) throws IOException {
        Object c = reader.classref.get(ValueReader.readInt(buffer, 123));
        String[] memberNames = reader.membersref.get(c);
        int count = memberNames.length;
        if (Class.class.equals(c.getClass())) {
            Class cls = (Class)c;
            if (type == null || type.isAssignableFrom(cls)) {
                type = cls;
            }
        }
        if (type == null) {
            HashMap<String, Object> map = new HashMap<String, Object>(count);
            reader.refer.set(map);
            for (int i = 0; i < count; ++i) {
                map.put(memberNames[i], DefaultUnserializer.read(reader, buffer));
            }
            buffer.get();
            return map;
        }
        Object obj = ConstructorAccessor.newInstance(type);
        reader.refer.set(obj);
        Map<String, MemberAccessor> members = Accessors.getMembers(type, reader.mode);
        for (int i = 0; i < count; ++i) {
            MemberAccessor member = members.get(memberNames[i]);
            if (member != null) {
                member.unserialize(reader, buffer, obj);
                continue;
            }
            DefaultUnserializer.read(reader, buffer);
        }
        buffer.get();
        return obj;
    }

    static final Object readObject(Reader reader, InputStream stream, Class<?> type) throws IOException {
        Object c = reader.classref.get(ValueReader.readInt(stream, 123));
        String[] memberNames = reader.membersref.get(c);
        int count = memberNames.length;
        if (Class.class.equals(c.getClass())) {
            Class cls = (Class)c;
            if (type == null || type.isAssignableFrom(cls)) {
                type = cls;
            }
        }
        if (type == null) {
            HashMap<String, Object> map = new HashMap<String, Object>(count);
            reader.refer.set(map);
            for (int i = 0; i < count; ++i) {
                map.put(memberNames[i], DefaultUnserializer.read(reader, stream));
            }
            stream.read();
            return map;
        }
        Object obj = ConstructorAccessor.newInstance(type);
        reader.refer.set(obj);
        Map<String, MemberAccessor> members = Accessors.getMembers(type, reader.mode);
        for (int i = 0; i < count; ++i) {
            MemberAccessor member = members.get(memberNames[i]);
            if (member != null) {
                member.unserialize(reader, stream, obj);
                continue;
            }
            DefaultUnserializer.read(reader, stream);
        }
        stream.read();
        return obj;
    }

    static final Object read(Reader reader, ByteBuffer buffer, Class<?> type) throws IOException {
        byte tag = buffer.get();
        switch (tag) {
            case 110: {
                return null;
            }
            case 109: {
                return ObjectUnserializer.readMapAsObject(reader, buffer, type);
            }
            case 99: {
                ObjectUnserializer.readClass(reader, buffer);
                return ObjectUnserializer.read(reader, buffer, type);
            }
            case 111: {
                return ObjectUnserializer.readObject(reader, buffer, type);
            }
            case 114: {
                return reader.readRef(buffer, type);
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), type);
    }

    static final Object read(Reader reader, InputStream stream, Class<?> type) throws IOException {
        int tag = stream.read();
        switch (tag) {
            case 110: {
                return null;
            }
            case 109: {
                return ObjectUnserializer.readMapAsObject(reader, stream, type);
            }
            case 99: {
                ObjectUnserializer.readClass(reader, stream);
                return ObjectUnserializer.read(reader, stream, type);
            }
            case 111: {
                return ObjectUnserializer.readObject(reader, stream, type);
            }
            case 114: {
                return reader.readRef(stream, type);
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), type);
    }

    @Override
    public final Object read(Reader reader, ByteBuffer buffer, Class<?> cls, Type type) throws IOException {
        return ObjectUnserializer.read(reader, buffer, cls);
    }

    @Override
    public final Object read(Reader reader, InputStream stream, Class<?> cls, Type type) throws IOException {
        return ObjectUnserializer.read(reader, stream, cls);
    }
}

