/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.io.unserialize.DefaultUnserializer;
import hprose.io.unserialize.Reader;
import hprose.io.unserialize.StringUnserializer;
import hprose.io.unserialize.Unserializer;
import hprose.io.unserialize.ValueReader;
import hprose.util.DateTime;
import hprose.util.TimeZoneUtil;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class OffsetDateTimeUnserializer
implements Unserializer {
    public static final OffsetDateTimeUnserializer instance = new OffsetDateTimeUnserializer();

    OffsetDateTimeUnserializer() {
    }

    private static OffsetDateTime toOffsetDateTime(DateTime dt) {
        return OffsetDateTime.of(dt.year, dt.month, dt.day, dt.hour, dt.minute, dt.second, dt.nanosecond, dt.utc ? ZoneOffset.UTC : ZoneOffset.of(TimeZoneUtil.DefaultTZ.getID()));
    }

    private static OffsetDateTime toOffsetDateTime(Object obj) {
        if (obj instanceof DateTime) {
            return OffsetDateTimeUnserializer.toOffsetDateTime((DateTime)obj);
        }
        if (obj instanceof char[]) {
            return OffsetDateTime.parse(new String((char[])obj));
        }
        return OffsetDateTime.parse(obj.toString());
    }

    static final OffsetDateTime read(Reader reader, ByteBuffer buffer) throws IOException {
        byte tag = buffer.get();
        switch (tag) {
            case 68: {
                return OffsetDateTimeUnserializer.toOffsetDateTime(DefaultUnserializer.readDateTime(reader, buffer));
            }
            case 84: {
                return OffsetDateTimeUnserializer.toOffsetDateTime(DefaultUnserializer.readTime(reader, buffer));
            }
            case 101: 
            case 110: {
                return null;
            }
            case 115: {
                return OffsetDateTime.parse(StringUnserializer.readString(reader, buffer));
            }
            case 114: {
                return OffsetDateTimeUnserializer.toOffsetDateTime(reader.readRef(buffer));
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), OffsetDateTime.class);
    }

    static final OffsetDateTime read(Reader reader, InputStream stream) throws IOException {
        int tag = stream.read();
        switch (tag) {
            case 68: {
                return OffsetDateTimeUnserializer.toOffsetDateTime(DefaultUnserializer.readDateTime(reader, stream));
            }
            case 84: {
                return OffsetDateTimeUnserializer.toOffsetDateTime(DefaultUnserializer.readTime(reader, stream));
            }
            case 101: 
            case 110: {
                return null;
            }
            case 115: {
                return OffsetDateTime.parse(StringUnserializer.readString(reader, stream));
            }
            case 114: {
                return OffsetDateTimeUnserializer.toOffsetDateTime(reader.readRef(stream));
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), OffsetDateTime.class);
    }

    @Override
    public final Object read(Reader reader, ByteBuffer buffer, Class<?> cls, Type type) throws IOException {
        return OffsetDateTimeUnserializer.read(reader, buffer);
    }

    @Override
    public final Object read(Reader reader, InputStream stream, Class<?> cls, Type type) throws IOException {
        return OffsetDateTimeUnserializer.read(reader, stream);
    }
}

