/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.io.unserialize.DefaultUnserializer;
import hprose.io.unserialize.Reader;
import hprose.io.unserialize.StringUnserializer;
import hprose.io.unserialize.Unserializer;
import hprose.io.unserialize.ValueReader;
import hprose.util.DateTime;
import hprose.util.TimeZoneUtil;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.time.OffsetTime;
import java.time.ZoneOffset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class OffsetTimeUnserializer
implements Unserializer {
    public static final OffsetTimeUnserializer instance = new OffsetTimeUnserializer();

    OffsetTimeUnserializer() {
    }

    private static OffsetTime toOffsetTime(DateTime dt) {
        return OffsetTime.of(dt.hour, dt.minute, dt.second, dt.nanosecond, dt.utc ? ZoneOffset.UTC : ZoneOffset.of(TimeZoneUtil.DefaultTZ.getID()));
    }

    private static OffsetTime toOffsetTime(Object obj) {
        if (obj instanceof DateTime) {
            return OffsetTimeUnserializer.toOffsetTime((DateTime)obj);
        }
        if (obj instanceof char[]) {
            return OffsetTime.parse(new String((char[])obj));
        }
        return OffsetTime.parse(obj.toString());
    }

    static final OffsetTime read(Reader reader, ByteBuffer buffer) throws IOException {
        byte tag = buffer.get();
        switch (tag) {
            case 68: {
                return OffsetTimeUnserializer.toOffsetTime(DefaultUnserializer.readDateTime(reader, buffer));
            }
            case 84: {
                return OffsetTimeUnserializer.toOffsetTime(DefaultUnserializer.readTime(reader, buffer));
            }
            case 101: 
            case 110: {
                return null;
            }
            case 115: {
                return OffsetTime.parse(StringUnserializer.readString(reader, buffer));
            }
            case 114: {
                return OffsetTimeUnserializer.toOffsetTime(reader.readRef(buffer));
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), OffsetTime.class);
    }

    static final OffsetTime read(Reader reader, InputStream stream) throws IOException {
        int tag = stream.read();
        switch (tag) {
            case 68: {
                return OffsetTimeUnserializer.toOffsetTime(DefaultUnserializer.readDateTime(reader, stream));
            }
            case 84: {
                return OffsetTimeUnserializer.toOffsetTime(DefaultUnserializer.readTime(reader, stream));
            }
            case 101: 
            case 110: {
                return null;
            }
            case 115: {
                return OffsetTime.parse(StringUnserializer.readString(reader, stream));
            }
            case 114: {
                return OffsetTimeUnserializer.toOffsetTime(reader.readRef(stream));
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), OffsetTime.class);
    }

    @Override
    public final Object read(Reader reader, ByteBuffer buffer, Class<?> cls, Type type) throws IOException {
        return OffsetTimeUnserializer.read(reader, buffer);
    }

    @Override
    public final Object read(Reader reader, InputStream stream, Class<?> cls, Type type) throws IOException {
        return OffsetTimeUnserializer.read(reader, stream);
    }
}

