/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.io.unserialize.Reader;
import hprose.io.unserialize.Unserializer;
import hprose.io.unserialize.ValueReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PatternUnserializer
implements Unserializer {
    public static final PatternUnserializer instance = new PatternUnserializer();

    PatternUnserializer() {
    }

    static final Pattern readPattern(Reader reader, ByteBuffer buffer) throws IOException {
        Pattern pattern = Pattern.compile(ValueReader.readString(buffer));
        reader.refer.set(pattern);
        return pattern;
    }

    static final Pattern readPattern(Reader reader, InputStream stream) throws IOException {
        Pattern pattern = Pattern.compile(ValueReader.readString(stream));
        reader.refer.set(pattern);
        return pattern;
    }

    private static Pattern toPattern(Object obj) {
        if (obj instanceof Pattern) {
            return (Pattern)obj;
        }
        if (obj instanceof char[]) {
            return Pattern.compile(new String((char[])obj));
        }
        return Pattern.compile(obj.toString());
    }

    static final Pattern read(Reader reader, ByteBuffer buffer) throws IOException {
        byte tag = buffer.get();
        switch (tag) {
            case 101: 
            case 110: {
                return null;
            }
            case 115: {
                return PatternUnserializer.readPattern(reader, buffer);
            }
            case 114: {
                return PatternUnserializer.toPattern(reader.readRef(buffer));
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), Pattern.class);
    }

    static final Pattern read(Reader reader, InputStream stream) throws IOException {
        int tag = stream.read();
        switch (tag) {
            case 101: 
            case 110: {
                return null;
            }
            case 115: {
                return PatternUnserializer.readPattern(reader, stream);
            }
            case 114: {
                return PatternUnserializer.toPattern(reader.readRef(stream));
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), Pattern.class);
    }

    @Override
    public final Object read(Reader reader, ByteBuffer buffer, Class<?> cls, Type type) throws IOException {
        return PatternUnserializer.read(reader, buffer);
    }

    @Override
    public final Object read(Reader reader, InputStream stream, Class<?> cls, Type type) throws IOException {
        return PatternUnserializer.read(reader, stream);
    }
}

