/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.io.unserialize.DefaultUnserializer;
import hprose.io.unserialize.Reader;
import hprose.io.unserialize.StringUnserializer;
import hprose.io.unserialize.Unserializer;
import hprose.io.unserialize.ValueReader;
import hprose.util.DateTime;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.time.Period;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PeriodUnserializer
implements Unserializer {
    public static final PeriodUnserializer instance = new PeriodUnserializer();

    PeriodUnserializer() {
    }

    private static Period toPeriod(DateTime dt) {
        return Period.of(dt.year, dt.month, dt.day);
    }

    private static Period toPeriod(Object obj) {
        if (obj instanceof DateTime) {
            return PeriodUnserializer.toPeriod((DateTime)obj);
        }
        if (obj instanceof char[]) {
            return Period.parse(new String((char[])obj));
        }
        return Period.parse(obj.toString());
    }

    static final Period read(Reader reader, ByteBuffer buffer) throws IOException {
        byte tag = buffer.get();
        switch (tag) {
            case 115: {
                return Period.parse(StringUnserializer.readString(reader, buffer));
            }
            case 68: {
                return PeriodUnserializer.toPeriod(DefaultUnserializer.readDateTime(reader, buffer));
            }
            case 84: {
                return PeriodUnserializer.toPeriod(DefaultUnserializer.readTime(reader, buffer));
            }
            case 101: 
            case 110: {
                return null;
            }
            case 114: {
                return PeriodUnserializer.toPeriod(reader.readRef(buffer));
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), Period.class);
    }

    static final Period read(Reader reader, InputStream stream) throws IOException {
        int tag = stream.read();
        switch (tag) {
            case 115: {
                return Period.parse(StringUnserializer.readString(reader, stream));
            }
            case 68: {
                return PeriodUnserializer.toPeriod(DefaultUnserializer.readDateTime(reader, stream));
            }
            case 84: {
                return PeriodUnserializer.toPeriod(DefaultUnserializer.readTime(reader, stream));
            }
            case 101: 
            case 110: {
                return null;
            }
            case 114: {
                return PeriodUnserializer.toPeriod(reader.readRef(stream));
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), Period.class);
    }

    @Override
    public final Object read(Reader reader, ByteBuffer buffer, Class<?> cls, Type type) throws IOException {
        return PeriodUnserializer.read(reader, buffer);
    }

    @Override
    public final Object read(Reader reader, InputStream stream, Class<?> cls, Type type) throws IOException {
        return PeriodUnserializer.read(reader, stream);
    }
}

