/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.common.HproseException;
import hprose.io.unserialize.ValueReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public final class RawReader {
    private static void readBytesRaw(ByteBuffer buffer, OutputStream ostream) throws IOException {
        int len = 0;
        int tag = 48;
        do {
            len = len * 10 + (tag - 48);
            tag = buffer.get();
            ostream.write(tag);
        } while (tag != 34);
        byte[] b = new byte[len];
        buffer.get(b, 0, len);
        ostream.write(b);
        ostream.write(buffer.get());
    }

    private static void readBytesRaw(InputStream stream, OutputStream ostream) throws IOException {
        int len = 0;
        int tag = 48;
        do {
            len = len * 10 + (tag - 48);
            tag = stream.read();
            ostream.write(tag);
        } while (tag != 34);
        byte[] b = new byte[len];
        for (int off = 0; off < len; off += stream.read(b, off, len - off)) {
        }
        ostream.write(b);
        ostream.write(stream.read());
    }

    private static void readGuidRaw(ByteBuffer buffer, OutputStream ostream) throws IOException {
        int len = 38;
        byte[] b = new byte[len];
        buffer.get(b, 0, len);
        ostream.write(b);
    }

    private static void readGuidRaw(InputStream stream, OutputStream ostream) throws IOException {
        int len = 38;
        byte[] b = new byte[len];
        for (int off = 0; off < len; off += stream.read(b, off, len - off)) {
        }
        ostream.write(b);
    }

    private static void readUTF8CharRaw(ByteBuffer buffer, OutputStream ostream) throws IOException {
        byte tag = buffer.get();
        switch ((tag & 0xFF) >>> 4) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                ostream.write(tag);
                break;
            }
            case 12: 
            case 13: {
                ostream.write(tag);
                ostream.write(buffer.get());
                break;
            }
            case 14: {
                ostream.write(tag);
                ostream.write(buffer.get());
                ostream.write(buffer.get());
                break;
            }
            default: {
                throw ValueReader.badEncoding(tag);
            }
        }
    }

    private static void readUTF8CharRaw(InputStream stream, OutputStream ostream) throws IOException {
        int tag = stream.read();
        switch (tag >>> 4) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                ostream.write(tag);
                break;
            }
            case 12: 
            case 13: {
                ostream.write(tag);
                ostream.write(stream.read());
                break;
            }
            case 14: {
                ostream.write(tag);
                ostream.write(stream.read());
                ostream.write(stream.read());
                break;
            }
            default: {
                throw ValueReader.badEncoding(tag);
            }
        }
    }

    private static void readComplexRaw(ByteBuffer buffer, OutputStream ostream) throws IOException {
        byte tag;
        do {
            tag = buffer.get();
            ostream.write(tag);
        } while (tag != 123);
        while ((tag = buffer.get()) != 125) {
            RawReader.readRaw(buffer, ostream, (int)tag);
        }
        ostream.write(tag);
    }

    private static void readComplexRaw(InputStream stream, OutputStream ostream) throws IOException {
        int tag;
        do {
            tag = stream.read();
            ostream.write(tag);
        } while (tag != 123);
        while ((tag = stream.read()) != 125) {
            RawReader.readRaw(stream, ostream, tag);
        }
        ostream.write(tag);
    }

    private static void readNumberRaw(ByteBuffer buffer, OutputStream ostream) throws IOException {
        byte tag;
        do {
            tag = buffer.get();
            ostream.write(tag);
        } while (tag != 59);
    }

    private static void readNumberRaw(InputStream stream, OutputStream ostream) throws IOException {
        int tag;
        do {
            tag = stream.read();
            ostream.write(tag);
        } while (tag != 59);
    }

    private static void readDateTimeRaw(ByteBuffer buffer, OutputStream ostream) throws IOException {
        byte tag;
        do {
            tag = buffer.get();
            ostream.write(tag);
        } while (tag != 59 && tag != 90);
    }

    private static void readDateTimeRaw(InputStream stream, OutputStream ostream) throws IOException {
        int tag;
        do {
            tag = stream.read();
            ostream.write(tag);
        } while (tag != 59 && tag != 90);
    }

    private static void readStringRaw(ByteBuffer buffer, OutputStream ostream) throws IOException {
        int count = 0;
        int tag = 48;
        do {
            count = count * 10 + (tag - 48);
            tag = buffer.get();
            ostream.write(tag);
        } while (tag != 34);
        block7: for (int i = 0; i < count; ++i) {
            tag = buffer.get();
            switch ((tag & 0xFF) >>> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ostream.write(tag);
                    continue block7;
                }
                case 12: 
                case 13: {
                    ostream.write(tag);
                    ostream.write(buffer.get());
                    continue block7;
                }
                case 14: {
                    ostream.write(tag);
                    ostream.write(buffer.get());
                    ostream.write(buffer.get());
                    continue block7;
                }
                case 15: {
                    if ((tag & 0xF) <= 4) {
                        ostream.write(tag);
                        ostream.write(buffer.get());
                        ostream.write(buffer.get());
                        ostream.write(buffer.get());
                        ++i;
                        continue block7;
                    }
                }
                default: {
                    throw ValueReader.badEncoding(tag);
                }
            }
        }
        ostream.write(buffer.get());
    }

    private static void readStringRaw(InputStream stream, OutputStream ostream) throws IOException {
        int count = 0;
        int tag = 48;
        do {
            count = count * 10 + (tag - 48);
            tag = stream.read();
            ostream.write(tag);
        } while (tag != 34);
        block7: for (int i = 0; i < count; ++i) {
            tag = stream.read();
            switch (tag >>> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ostream.write(tag);
                    continue block7;
                }
                case 12: 
                case 13: {
                    ostream.write(tag);
                    ostream.write(stream.read());
                    continue block7;
                }
                case 14: {
                    ostream.write(tag);
                    ostream.write(stream.read());
                    ostream.write(stream.read());
                    continue block7;
                }
                case 15: {
                    if ((tag & 0xF) <= 4) {
                        ostream.write(tag);
                        ostream.write(stream.read());
                        ostream.write(stream.read());
                        ostream.write(stream.read());
                        ++i;
                        continue block7;
                    }
                }
                default: {
                    throw ValueReader.badEncoding(tag);
                }
            }
        }
        ostream.write(stream.read());
    }

    private static void readRaw(ByteBuffer buffer, OutputStream ostream) throws IOException {
        RawReader.readRaw(buffer, ostream, (int)buffer.get());
    }

    private static void readRaw(InputStream stream, OutputStream ostream) throws IOException {
        RawReader.readRaw(stream, ostream, stream.read());
    }

    static final void readRaw(ByteBuffer buffer, OutputStream ostream, int tag) throws IOException {
        ostream.write(tag);
        switch (tag) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 78: 
            case 101: 
            case 102: 
            case 110: 
            case 116: {
                break;
            }
            case 73: {
                ostream.write(buffer.get());
                break;
            }
            case 100: 
            case 105: 
            case 108: 
            case 114: {
                RawReader.readNumberRaw(buffer, ostream);
                break;
            }
            case 68: 
            case 84: {
                RawReader.readDateTimeRaw(buffer, ostream);
                break;
            }
            case 117: {
                RawReader.readUTF8CharRaw(buffer, ostream);
                break;
            }
            case 98: {
                RawReader.readBytesRaw(buffer, ostream);
                break;
            }
            case 115: {
                RawReader.readStringRaw(buffer, ostream);
                break;
            }
            case 103: {
                RawReader.readGuidRaw(buffer, ostream);
                break;
            }
            case 97: 
            case 109: 
            case 111: {
                RawReader.readComplexRaw(buffer, ostream);
                break;
            }
            case 99: {
                RawReader.readComplexRaw(buffer, ostream);
                RawReader.readRaw(buffer, ostream);
                break;
            }
            case 69: {
                RawReader.readRaw(buffer, ostream);
                break;
            }
            case -1: {
                throw new HproseException("No byte found in stream");
            }
            default: {
                throw new HproseException("Unexpected serialize tag '" + (char)tag + "' in stream");
            }
        }
    }

    static final void readRaw(InputStream stream, OutputStream ostream, int tag) throws IOException {
        ostream.write(tag);
        switch (tag) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 78: 
            case 101: 
            case 102: 
            case 110: 
            case 116: {
                break;
            }
            case 73: {
                ostream.write(stream.read());
                break;
            }
            case 100: 
            case 105: 
            case 108: 
            case 114: {
                RawReader.readNumberRaw(stream, ostream);
                break;
            }
            case 68: 
            case 84: {
                RawReader.readDateTimeRaw(stream, ostream);
                break;
            }
            case 117: {
                RawReader.readUTF8CharRaw(stream, ostream);
                break;
            }
            case 98: {
                RawReader.readBytesRaw(stream, ostream);
                break;
            }
            case 115: {
                RawReader.readStringRaw(stream, ostream);
                break;
            }
            case 103: {
                RawReader.readGuidRaw(stream, ostream);
                break;
            }
            case 97: 
            case 109: 
            case 111: {
                RawReader.readComplexRaw(stream, ostream);
                break;
            }
            case 99: {
                RawReader.readComplexRaw(stream, ostream);
                RawReader.readRaw(stream, ostream);
                break;
            }
            case 69: {
                RawReader.readRaw(stream, ostream);
                break;
            }
            case -1: {
                throw new HproseException("No byte found in stream");
            }
            default: {
                throw new HproseException("Unexpected serialize tag '" + (char)tag + "' in stream");
            }
        }
    }
}

