/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.common.HproseException;
import hprose.io.ByteBufferInputStream;
import hprose.io.ByteBufferStream;
import hprose.io.HproseMode;
import hprose.io.unserialize.ArrayUnserializer;
import hprose.io.unserialize.BigDecimalArrayUnserializer;
import hprose.io.unserialize.BigDecimalUnserializer;
import hprose.io.unserialize.BigIntegerArrayUnserializer;
import hprose.io.unserialize.BigIntegerUnserializer;
import hprose.io.unserialize.BooleanArrayUnserializer;
import hprose.io.unserialize.BooleanObjectUnserializer;
import hprose.io.unserialize.BooleanUnserializer;
import hprose.io.unserialize.ByteArrayUnserializer;
import hprose.io.unserialize.ByteObjectUnserializer;
import hprose.io.unserialize.ByteUnserializer;
import hprose.io.unserialize.BytesArrayUnserializer;
import hprose.io.unserialize.CalendarArrayUnserializer;
import hprose.io.unserialize.CalendarUnserializer;
import hprose.io.unserialize.CharArrayUnserializer;
import hprose.io.unserialize.CharObjectUnserializer;
import hprose.io.unserialize.CharUnserializer;
import hprose.io.unserialize.CharsArrayUnserializer;
import hprose.io.unserialize.CollectionUnserializer;
import hprose.io.unserialize.DateArrayUnserializer;
import hprose.io.unserialize.DateTimeArrayUnserializer;
import hprose.io.unserialize.DateTimeUnserializer;
import hprose.io.unserialize.DateUnserializer;
import hprose.io.unserialize.DefaultUnserializer;
import hprose.io.unserialize.DoubleArrayUnserializer;
import hprose.io.unserialize.DoubleObjectUnserializer;
import hprose.io.unserialize.DoubleUnserializer;
import hprose.io.unserialize.EnumUnserializer;
import hprose.io.unserialize.FakeReaderRefer;
import hprose.io.unserialize.FloatArrayUnserializer;
import hprose.io.unserialize.FloatObjectUnserializer;
import hprose.io.unserialize.FloatUnserializer;
import hprose.io.unserialize.IntArrayUnserializer;
import hprose.io.unserialize.IntObjectUnserializer;
import hprose.io.unserialize.IntUnserializer;
import hprose.io.unserialize.LongArrayUnserializer;
import hprose.io.unserialize.LongObjectUnserializer;
import hprose.io.unserialize.LongUnserializer;
import hprose.io.unserialize.MapUnserializer;
import hprose.io.unserialize.ObjectArrayUnserializer;
import hprose.io.unserialize.ObjectUnserializer;
import hprose.io.unserialize.RawReader;
import hprose.io.unserialize.ReaderRefer;
import hprose.io.unserialize.RealReaderRefer;
import hprose.io.unserialize.ShortArrayUnserializer;
import hprose.io.unserialize.ShortObjectUnserializer;
import hprose.io.unserialize.ShortUnserializer;
import hprose.io.unserialize.StringArrayUnserializer;
import hprose.io.unserialize.StringBufferArrayUnserializer;
import hprose.io.unserialize.StringBufferUnserializer;
import hprose.io.unserialize.StringBuilderArrayUnserializer;
import hprose.io.unserialize.StringBuilderUnserializer;
import hprose.io.unserialize.StringUnserializer;
import hprose.io.unserialize.TimeArrayUnserializer;
import hprose.io.unserialize.TimeUnserializer;
import hprose.io.unserialize.TimestampArrayUnserializer;
import hprose.io.unserialize.TimestampUnserializer;
import hprose.io.unserialize.UUIDArrayUnserializer;
import hprose.io.unserialize.UUIDUnserializer;
import hprose.io.unserialize.UnserializerFactory;
import hprose.io.unserialize.ValueReader;
import hprose.util.ClassUtil;
import hprose.util.StrUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reader {
    public final InputStream stream;
    private final ByteBuffer buffer;
    final HproseMode mode;
    final ArrayList<Object> classref = new ArrayList();
    final IdentityHashMap<Object, String[]> membersref = new IdentityHashMap();
    final ReaderRefer refer;

    public Reader(InputStream stream) {
        this(stream, HproseMode.MemberMode, false);
    }

    public Reader(InputStream stream, boolean simple) {
        this(stream, HproseMode.MemberMode, simple);
    }

    public Reader(InputStream stream, HproseMode mode) {
        this(stream, mode, false);
    }

    public Reader(InputStream stream, HproseMode mode, boolean simple) {
        this.stream = stream;
        this.buffer = stream != null && stream instanceof ByteBufferInputStream ? ((ByteBufferInputStream)stream).stream.buffer : null;
        this.mode = mode;
        this.refer = simple ? new FakeReaderRefer() : new RealReaderRefer();
    }

    public Reader(ByteBuffer buffer) {
        this(buffer, HproseMode.MemberMode, false);
    }

    public Reader(ByteBuffer buffer, boolean simple) {
        this(buffer, HproseMode.MemberMode, simple);
    }

    public Reader(ByteBuffer buffer, HproseMode mode) {
        this(buffer, mode, false);
    }

    public Reader(ByteBuffer buffer, HproseMode mode, boolean simple) {
        this.stream = null;
        this.buffer = buffer;
        this.mode = mode;
        this.refer = simple ? new FakeReaderRefer() : new RealReaderRefer();
    }

    public Reader(byte[] bytes) {
        this(bytes, HproseMode.MemberMode, false);
    }

    public Reader(byte[] bytes, boolean simple) {
        this(bytes, HproseMode.MemberMode, simple);
    }

    public Reader(byte[] bytes, HproseMode mode) {
        this(bytes, mode, false);
    }

    public Reader(byte[] bytes, HproseMode mode, boolean simple) {
        this.stream = null;
        this.buffer = ByteBuffer.wrap(bytes);
        this.mode = mode;
        this.refer = simple ? new FakeReaderRefer() : new RealReaderRefer();
    }

    public final HproseException unexpectedTag(int tag) {
        return this.unexpectedTag(tag, null);
    }

    public final HproseException unexpectedTag(int tag, String expectTags) {
        if (tag == -1) {
            return new HproseException("No byte found in stream");
        }
        if (expectTags == null) {
            if (this.buffer != null) {
                String moreinfo = StrUtil.toString(new ByteBufferStream(this.buffer));
                return new HproseException("Unexpected serialize tag '" + (char)tag + "' in stream. \r\n" + "The whole data: " + moreinfo);
            }
            return new HproseException("Unexpected serialize tag '" + (char)tag + "' in stream");
        }
        if (this.buffer != null) {
            String moreinfo = StrUtil.toString(new ByteBufferStream(this.buffer));
            return new HproseException("Tag '" + expectTags + "' expected, but '" + (char)tag + "' found in stream. \r\n" + "The whole data: " + moreinfo);
        }
        return new HproseException("Tag '" + expectTags + "' expected, but '" + (char)tag + "' found in stream");
    }

    public final void checkTag(int tag, int expectTag) throws HproseException {
        if (tag != expectTag) {
            throw this.unexpectedTag(tag, new String(new char[]{(char)expectTag}));
        }
    }

    public final void checkTag(int expectTag) throws IOException {
        if (this.buffer != null) {
            this.checkTag(this.buffer.get(), expectTag);
        } else {
            this.checkTag(this.stream.read(), expectTag);
        }
    }

    public final int checkTags(int tag, String expectTags) throws IOException {
        if (expectTags.indexOf(tag) == -1) {
            throw this.unexpectedTag(tag, expectTags);
        }
        return tag;
    }

    public final int checkTags(String expectTags) throws IOException {
        return this.buffer != null ? this.checkTags(this.buffer.get(), expectTags) : this.checkTags(this.stream.read(), expectTags);
    }

    private StringBuilder readUntil(int tag) throws IOException {
        return this.buffer != null ? ValueReader.readUntil(this.buffer, tag) : ValueReader.readUntil(this.stream, tag);
    }

    public final byte readByte(int tag) throws IOException {
        return (byte)(this.buffer != null ? ValueReader.readInt(this.buffer, tag) : ValueReader.readInt(this.stream, tag));
    }

    public final short readShort(int tag) throws IOException {
        return (short)(this.buffer != null ? ValueReader.readInt(this.buffer, tag) : ValueReader.readInt(this.stream, tag));
    }

    public final int readInt(int tag) throws IOException {
        return this.buffer != null ? ValueReader.readInt(this.buffer, tag) : ValueReader.readInt(this.stream, tag);
    }

    public final long readLong(int tag) throws IOException {
        return this.buffer != null ? ValueReader.readLong(this.buffer, tag) : ValueReader.readLong(this.stream, tag);
    }

    public final int readIntWithoutTag() throws IOException {
        return this.readInt(59);
    }

    public final BigInteger readBigIntegerWithoutTag() throws IOException {
        return new BigInteger(this.readUntil(59).toString(), 10);
    }

    public final long readLongWithoutTag() throws IOException {
        return this.readLong(59);
    }

    public final double readDoubleWithoutTag() throws IOException {
        return ValueReader.parseDouble(this.readUntil(59));
    }

    public final double readInfinityWithoutTag() throws IOException {
        return this.buffer != null ? ValueReader.readInfinity(this.buffer) : ValueReader.readInfinity(this.stream);
    }

    public final Calendar readDateWithoutTag() throws IOException {
        return this.buffer != null ? DefaultUnserializer.readDateTime(this, this.buffer).toCalendar() : DefaultUnserializer.readDateTime(this, this.stream).toCalendar();
    }

    public final Calendar readTimeWithoutTag() throws IOException {
        return this.buffer != null ? DefaultUnserializer.readTime(this, this.buffer).toCalendar() : DefaultUnserializer.readTime(this, this.stream).toCalendar();
    }

    public final byte[] readBytesWithoutTag() throws IOException {
        return this.buffer != null ? ByteArrayUnserializer.readBytes(this, this.buffer) : ByteArrayUnserializer.readBytes(this, this.stream);
    }

    public final String readUTF8CharWithoutTag() throws IOException {
        return this.buffer != null ? ValueReader.readUTF8Char(this.buffer) : ValueReader.readUTF8Char(this.stream);
    }

    public final String readStringWithoutTag() throws IOException {
        return this.buffer != null ? StringUnserializer.readString(this, this.buffer) : StringUnserializer.readString(this, this.stream);
    }

    public final char[] readCharsWithoutTag() throws IOException {
        return this.buffer != null ? CharArrayUnserializer.readChars(this, this.buffer) : CharArrayUnserializer.readChars(this, this.stream);
    }

    public final UUID readUUIDWithoutTag() throws IOException {
        return this.buffer != null ? UUIDUnserializer.readUUID(this, this.buffer) : UUIDUnserializer.readUUID(this, this.stream);
    }

    public final ArrayList readListWithoutTag() throws IOException {
        return this.buffer != null ? DefaultUnserializer.readList(this, this.buffer) : DefaultUnserializer.readList(this, this.stream);
    }

    public final HashMap readMapWithoutTag() throws IOException {
        return this.buffer != null ? DefaultUnserializer.readMap(this, this.buffer) : DefaultUnserializer.readMap(this, this.stream);
    }

    public final Object readObjectWithoutTag(Class<?> type) throws IOException {
        return this.buffer != null ? ObjectUnserializer.readObject(this, this.buffer, type) : ObjectUnserializer.readObject(this, this.stream, type);
    }

    public final Object unserialize() throws IOException {
        return this.buffer != null ? DefaultUnserializer.read(this, this.buffer) : DefaultUnserializer.read(this, this.stream);
    }

    public final boolean readBoolean() throws IOException {
        return this.buffer != null ? BooleanUnserializer.read(this, this.buffer) : BooleanUnserializer.read(this, this.stream);
    }

    public final Boolean readBooleanObject() throws IOException {
        return this.buffer != null ? BooleanObjectUnserializer.read(this, this.buffer) : BooleanObjectUnserializer.read(this, this.stream);
    }

    public final char readChar() throws IOException {
        return this.buffer != null ? CharUnserializer.read(this, this.buffer) : CharUnserializer.read(this, this.stream);
    }

    public final Character readCharObject() throws IOException {
        return this.buffer != null ? CharObjectUnserializer.read(this, this.buffer) : CharObjectUnserializer.read(this, this.stream);
    }

    public final byte readByte() throws IOException {
        return this.buffer != null ? ByteUnserializer.read(this, this.buffer) : ByteUnserializer.read(this, this.stream);
    }

    public final Byte readByteObject() throws IOException {
        return this.buffer != null ? ByteObjectUnserializer.read(this, this.buffer) : ByteObjectUnserializer.read(this, this.stream);
    }

    public final short readShort() throws IOException {
        return this.buffer != null ? ShortUnserializer.read(this, this.buffer) : ShortUnserializer.read(this, this.stream);
    }

    public final Short readShortObject() throws IOException {
        return this.buffer != null ? ShortObjectUnserializer.read(this, this.buffer) : ShortObjectUnserializer.read(this, this.stream);
    }

    public final int readInt() throws IOException {
        return this.buffer != null ? IntUnserializer.read(this, this.buffer) : IntUnserializer.read(this, this.stream);
    }

    public final Integer readIntObject() throws IOException {
        return this.buffer != null ? IntObjectUnserializer.read(this, this.buffer) : IntObjectUnserializer.read(this, this.stream);
    }

    public final long readLong() throws IOException {
        return this.buffer != null ? LongUnserializer.read(this, this.buffer) : LongUnserializer.read(this, this.stream);
    }

    public final Long readLongObject() throws IOException {
        return this.buffer != null ? LongObjectUnserializer.read(this, this.buffer) : LongObjectUnserializer.read(this, this.stream);
    }

    public final float readFloat() throws IOException {
        return this.buffer != null ? FloatUnserializer.read(this, this.buffer) : FloatUnserializer.read(this, this.stream);
    }

    public final Float readFloatObject() throws IOException {
        return this.buffer != null ? FloatObjectUnserializer.read(this, this.buffer) : FloatObjectUnserializer.read(this, this.stream);
    }

    public final double readDouble() throws IOException {
        return this.buffer != null ? DoubleUnserializer.read(this, this.buffer) : DoubleUnserializer.read(this, this.stream);
    }

    public final Double readDoubleObject() throws IOException {
        return this.buffer != null ? DoubleObjectUnserializer.read(this, this.buffer) : DoubleObjectUnserializer.read(this, this.stream);
    }

    public final <T> T readEnum(Class<T> type) throws HproseException {
        return this.buffer != null ? EnumUnserializer.read(this, this.buffer, type) : EnumUnserializer.read(this, this.stream, type);
    }

    public final String readString() throws IOException {
        return this.buffer != null ? StringUnserializer.read(this, this.buffer) : StringUnserializer.read(this, this.stream);
    }

    public final BigInteger readBigInteger() throws IOException {
        return this.buffer != null ? BigIntegerUnserializer.read(this, this.buffer) : BigIntegerUnserializer.read(this, this.stream);
    }

    public final java.sql.Date readDate() throws IOException {
        return this.buffer != null ? DateUnserializer.read(this, this.buffer) : DateUnserializer.read(this, this.stream);
    }

    public final Time readTime() throws IOException {
        return this.buffer != null ? TimeUnserializer.read(this, this.buffer) : TimeUnserializer.read(this, this.stream);
    }

    public final Date readDateTime() throws IOException {
        return this.buffer != null ? DateTimeUnserializer.read(this, this.buffer) : DateTimeUnserializer.read(this, this.stream);
    }

    public final Timestamp readTimestamp() throws IOException {
        return this.buffer != null ? TimestampUnserializer.read(this, this.buffer) : TimestampUnserializer.read(this, this.stream);
    }

    public final Calendar readCalendar() throws IOException {
        return this.buffer != null ? CalendarUnserializer.read(this, this.buffer) : CalendarUnserializer.read(this, this.stream);
    }

    public final BigDecimal readBigDecimal() throws IOException {
        return this.buffer != null ? BigDecimalUnserializer.read(this, this.buffer) : BigDecimalUnserializer.read(this, this.stream);
    }

    public final StringBuilder readStringBuilder() throws IOException {
        return this.buffer != null ? StringBuilderUnserializer.read(this, this.buffer) : StringBuilderUnserializer.read(this, this.stream);
    }

    public final StringBuffer readStringBuffer() throws IOException {
        return this.buffer != null ? StringBufferUnserializer.read(this, this.buffer) : StringBufferUnserializer.read(this, this.stream);
    }

    public final UUID readUUID() throws IOException {
        return this.buffer != null ? UUIDUnserializer.read(this, this.buffer) : UUIDUnserializer.read(this, this.stream);
    }

    public final void readArray(Type[] types, Object[] a, int count) throws IOException {
        if (this.buffer != null) {
            this.readArray(this.buffer, types, a, count);
        } else {
            this.readArray(this.stream, types, a, count);
        }
    }

    public final Object[] readArray(int count) throws IOException {
        return this.buffer != null ? ObjectArrayUnserializer.readArray(this, this.buffer, count) : ObjectArrayUnserializer.readArray(this, this.stream, count);
    }

    public final Object[] readObjectArray() throws IOException {
        return this.buffer != null ? ObjectArrayUnserializer.read(this, this.buffer) : ObjectArrayUnserializer.read(this, this.stream);
    }

    public final boolean[] readBooleanArray() throws IOException {
        return this.buffer != null ? BooleanArrayUnserializer.read(this, this.buffer) : BooleanArrayUnserializer.read(this, this.stream);
    }

    public final char[] readCharArray() throws IOException {
        return this.buffer != null ? CharArrayUnserializer.read(this, this.buffer) : CharArrayUnserializer.read(this, this.stream);
    }

    public final byte[] readByteArray() throws IOException {
        return this.buffer != null ? ByteArrayUnserializer.read(this, this.buffer) : ByteArrayUnserializer.read(this, this.stream);
    }

    public final short[] readShortArray() throws IOException {
        return this.buffer != null ? ShortArrayUnserializer.read(this, this.buffer) : ShortArrayUnserializer.read(this, this.stream);
    }

    public final int[] readIntArray() throws IOException {
        return this.buffer != null ? IntArrayUnserializer.read(this, this.buffer) : IntArrayUnserializer.read(this, this.stream);
    }

    public final long[] readLongArray() throws IOException {
        return this.buffer != null ? LongArrayUnserializer.read(this, this.buffer) : LongArrayUnserializer.read(this, this.stream);
    }

    public final float[] readFloatArray() throws IOException {
        return this.buffer != null ? FloatArrayUnserializer.read(this, this.buffer) : FloatArrayUnserializer.read(this, this.stream);
    }

    public final double[] readDoubleArray() throws IOException {
        return this.buffer != null ? DoubleArrayUnserializer.read(this, this.buffer) : DoubleArrayUnserializer.read(this, this.stream);
    }

    public final String[] readStringArray() throws IOException {
        return this.buffer != null ? StringArrayUnserializer.read(this, this.buffer) : StringArrayUnserializer.read(this, this.stream);
    }

    public final BigInteger[] readBigIntegerArray() throws IOException {
        return this.buffer != null ? BigIntegerArrayUnserializer.read(this, this.buffer) : BigIntegerArrayUnserializer.read(this, this.stream);
    }

    public final java.sql.Date[] readDateArray() throws IOException {
        return this.buffer != null ? DateArrayUnserializer.read(this, this.buffer) : DateArrayUnserializer.read(this, this.stream);
    }

    public final Time[] readTimeArray() throws IOException {
        return this.buffer != null ? TimeArrayUnserializer.read(this, this.buffer) : TimeArrayUnserializer.read(this, this.stream);
    }

    public final Timestamp[] readTimestampArray() throws IOException {
        return this.buffer != null ? TimestampArrayUnserializer.read(this, this.buffer) : TimestampArrayUnserializer.read(this, this.stream);
    }

    public final Date[] readDateTimeArray() throws IOException {
        return this.buffer != null ? DateTimeArrayUnserializer.read(this, this.buffer) : DateTimeArrayUnserializer.read(this, this.stream);
    }

    public final Calendar[] readCalendarArray() throws IOException {
        return this.buffer != null ? CalendarArrayUnserializer.read(this, this.buffer) : CalendarArrayUnserializer.read(this, this.stream);
    }

    public final BigDecimal[] readBigDecimalArray() throws IOException {
        return this.buffer != null ? BigDecimalArrayUnserializer.read(this, this.buffer) : BigDecimalArrayUnserializer.read(this, this.stream);
    }

    public final StringBuilder[] readStringBuilderArray() throws IOException {
        return this.buffer != null ? StringBuilderArrayUnserializer.read(this, this.buffer) : StringBuilderArrayUnserializer.read(this, this.stream);
    }

    public final StringBuffer[] readStringBufferArray() throws IOException {
        return this.buffer != null ? StringBufferArrayUnserializer.read(this, this.buffer) : StringBufferArrayUnserializer.read(this, this.stream);
    }

    public final UUID[] readUUIDArray() throws IOException {
        return this.buffer != null ? UUIDArrayUnserializer.read(this, this.buffer) : UUIDArrayUnserializer.read(this, this.stream);
    }

    public final char[][] readCharsArray() throws IOException {
        return this.buffer != null ? CharsArrayUnserializer.read(this, this.buffer) : CharsArrayUnserializer.read(this, this.stream);
    }

    public final byte[][] readBytesArray() throws IOException {
        return this.buffer != null ? BytesArrayUnserializer.read(this, this.buffer) : BytesArrayUnserializer.read(this, this.stream);
    }

    public final <T> T[] readOtherTypeArray(Class<T> componentClass, Type componentType) throws IOException {
        return this.buffer != null ? ArrayUnserializer.readArray(this, this.buffer, componentClass, componentType) : ArrayUnserializer.readArray(this, this.stream, componentClass, componentType);
    }

    public final AtomicReference<?> readAtomicReference(Type type) throws IOException {
        return new AtomicReference<Object>(this.unserialize(type));
    }

    public final <T> AtomicReferenceArray<T> readAtomicReferenceArray(Class<T> componentClass, Type componentType) throws IOException {
        return new AtomicReferenceArray<T>(this.readOtherTypeArray(componentClass, componentType));
    }

    public final Collection readCollection(Class<?> cls, Type type) throws IOException {
        return this.buffer != null ? CollectionUnserializer.readCollection(this, this.buffer, cls, type) : CollectionUnserializer.readCollection(this, this.stream, cls, type);
    }

    public final Map readMap(Class<?> cls, Type type) throws IOException {
        return this.buffer != null ? MapUnserializer.readMap(this, this.buffer, cls, type) : MapUnserializer.readMap(this, this.stream, cls, type);
    }

    public final <K, V> Map<K, V> readMap(Class<?> cls, Class<K> keyClass, Class<V> valueClass, Type keyType, Type valueType) throws IOException {
        return this.buffer != null ? MapUnserializer.read(this, this.buffer, cls, keyClass, valueClass, keyType, valueType) : MapUnserializer.read(this, this.stream, cls, keyClass, valueClass, keyType, valueType);
    }

    public final Object readObject(Class<?> type) throws IOException {
        return this.buffer != null ? ObjectUnserializer.read(this, this.buffer, type) : ObjectUnserializer.read(this, this.stream, type);
    }

    public final Object unserialize(Type type) throws IOException {
        return this.buffer != null ? this.unserialize(this.buffer, type) : this.unserialize(this.stream, type);
    }

    public final <T> T unserialize(Class<T> type) throws IOException {
        return this.buffer != null ? this.unserialize(this.buffer, type) : this.unserialize(this.stream, type);
    }

    final Object readRef(ByteBuffer buffer) throws IOException {
        return this.refer.read(ValueReader.readInt(buffer));
    }

    final Object readRef(InputStream stream) throws IOException {
        return this.refer.read(ValueReader.readInt(stream));
    }

    final <T> T readRef(ByteBuffer buffer, Class<T> type) throws IOException {
        Object obj = this.readRef(buffer);
        Class<?> objType = obj.getClass();
        if (objType.equals(type) || type.isAssignableFrom(objType)) {
            return (T)obj;
        }
        throw ValueReader.castError(objType.toString(), type);
    }

    final <T> T readRef(InputStream stream, Class<T> type) throws IOException {
        Object obj = this.readRef(stream);
        Class<?> objType = obj.getClass();
        if (objType.equals(type) || type.isAssignableFrom(objType)) {
            return (T)obj;
        }
        throw ValueReader.castError(objType.toString(), type);
    }

    final String tagToString(int tag) throws IOException {
        switch (tag) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 105: {
                return "Integer";
            }
            case 108: {
                return "BigInteger";
            }
            case 100: {
                return "Double";
            }
            case 110: {
                return "Null";
            }
            case 101: {
                return "Empty String";
            }
            case 116: {
                return "Boolean True";
            }
            case 102: {
                return "Boolean False";
            }
            case 78: {
                return "NaN";
            }
            case 73: {
                return "Infinity";
            }
            case 68: {
                return "DateTime";
            }
            case 84: {
                return "DateTime";
            }
            case 98: {
                return "Byte[]";
            }
            case 117: {
                return "Char";
            }
            case 115: {
                return "String";
            }
            case 103: {
                return "Guid";
            }
            case 97: {
                return "IList";
            }
            case 109: {
                return "IDictionary";
            }
            case 99: {
                return "Class";
            }
            case 111: {
                return "Object";
            }
            case 114: {
                return "Object Reference";
            }
            case 69: {
                throw new HproseException(this.readString());
            }
        }
        throw this.unexpectedTag(tag);
    }

    private void readArray(ByteBuffer buffer, Type[] types, Object[] a, int count) throws IOException {
        this.refer.set(a);
        for (int i = 0; i < count; ++i) {
            a[i] = this.unserialize(buffer, types[i]);
        }
        buffer.get();
    }

    private void readArray(InputStream stream, Type[] types, Object[] a, int count) throws IOException {
        this.refer.set(a);
        for (int i = 0; i < count; ++i) {
            a[i] = this.unserialize(stream, types[i]);
        }
        stream.read();
    }

    final Object unserialize(ByteBuffer buffer, Type type) throws IOException {
        if (type == null) {
            return DefaultUnserializer.read(this, buffer);
        }
        Class<?> cls = ClassUtil.toClass(type);
        return this.unserialize(buffer, cls, type);
    }

    final Object unserialize(InputStream stream, Type type) throws IOException {
        if (type == null) {
            return DefaultUnserializer.read(this, stream);
        }
        Class<?> cls = ClassUtil.toClass(type);
        return this.unserialize(stream, cls, type);
    }

    private <T> T unserialize(ByteBuffer buffer, Class<T> type) throws IOException {
        return (T)this.unserialize(buffer, type, type);
    }

    private <T> T unserialize(InputStream stream, Class<T> type) throws IOException {
        return (T)this.unserialize(stream, type, type);
    }

    private Object unserialize(ByteBuffer buffer, Class<?> cls, Type type) throws IOException {
        return UnserializerFactory.get(cls).read(this, buffer, cls, type);
    }

    private Object unserialize(InputStream stream, Class<?> cls, Type type) throws IOException {
        return UnserializerFactory.get(cls).read(this, stream, cls, type);
    }

    public final ByteBufferStream readRaw() throws IOException {
        ByteBufferStream rawstream = new ByteBufferStream();
        this.readRaw(rawstream.getOutputStream());
        rawstream.flip();
        return rawstream;
    }

    public final void readRaw(OutputStream ostream) throws IOException {
        if (this.buffer != null) {
            RawReader.readRaw(this.buffer, ostream, (int)this.buffer.get());
        } else {
            RawReader.readRaw(this.stream, ostream, this.stream.read());
        }
    }

    public final void reset() {
        this.refer.reset();
        this.classref.clear();
        this.membersref.clear();
    }
}

