/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.io.unserialize.CharArrayUnserializer;
import hprose.io.unserialize.DefaultUnserializer;
import hprose.io.unserialize.Reader;
import hprose.io.unserialize.UUIDUnserializer;
import hprose.io.unserialize.Unserializer;
import hprose.io.unserialize.ValueReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class StringBufferUnserializer
implements Unserializer {
    public static final StringBufferUnserializer instance = new StringBufferUnserializer();

    StringBufferUnserializer() {
    }

    private static StringBuffer getStringBuffer(char[] chars) {
        return new StringBuffer(chars.length + 16).append(chars);
    }

    private static StringBuffer getStringBuffer(char c) {
        return new StringBuffer().append(c);
    }

    private static StringBuffer toStringBuffer(Object obj) {
        if (obj instanceof char[]) {
            return StringBufferUnserializer.getStringBuffer((char[])obj);
        }
        return new StringBuffer(obj.toString());
    }

    static final StringBuffer read(Reader reader, ByteBuffer buffer) throws IOException {
        byte tag = buffer.get();
        switch (tag) {
            case 101: {
                return new StringBuffer();
            }
            case 110: {
                return null;
            }
            case 115: {
                return StringBufferUnserializer.getStringBuffer(CharArrayUnserializer.readChars(reader, buffer));
            }
            case 117: {
                return StringBufferUnserializer.getStringBuffer(ValueReader.readChar(buffer));
            }
            case 105: {
                return new StringBuffer(ValueReader.readUntil(buffer, 59));
            }
            case 108: {
                return new StringBuffer(ValueReader.readUntil(buffer, 59));
            }
            case 100: {
                return new StringBuffer(ValueReader.readUntil(buffer, 59));
            }
            case 114: {
                return StringBufferUnserializer.toStringBuffer(reader.readRef(buffer));
            }
        }
        if (tag >= 48 && tag <= 57) {
            return StringBufferUnserializer.getStringBuffer((char)tag);
        }
        switch (tag) {
            case 116: {
                return new StringBuffer("true");
            }
            case 102: {
                return new StringBuffer("false");
            }
            case 78: {
                return new StringBuffer("NaN");
            }
            case 73: {
                return new StringBuffer(buffer.get() == 43 ? "Infinity" : "-Infinity");
            }
            case 68: {
                return DefaultUnserializer.readDateTime(reader, buffer).toStringBuffer();
            }
            case 84: {
                return DefaultUnserializer.readTime(reader, buffer).toStringBuffer();
            }
            case 103: {
                return new StringBuffer(UUIDUnserializer.readUUID(reader, buffer).toString());
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), StringBuffer.class);
    }

    static final StringBuffer read(Reader reader, InputStream stream) throws IOException {
        int tag = stream.read();
        switch (tag) {
            case 101: {
                return new StringBuffer();
            }
            case 110: {
                return null;
            }
            case 115: {
                return StringBufferUnserializer.getStringBuffer(CharArrayUnserializer.readChars(reader, stream));
            }
            case 117: {
                return StringBufferUnserializer.getStringBuffer(ValueReader.readChar(stream));
            }
            case 105: {
                return new StringBuffer(ValueReader.readUntil(stream, 59));
            }
            case 108: {
                return new StringBuffer(ValueReader.readUntil(stream, 59));
            }
            case 100: {
                return new StringBuffer(ValueReader.readUntil(stream, 59));
            }
            case 114: {
                return StringBufferUnserializer.toStringBuffer(reader.readRef(stream));
            }
        }
        if (tag >= 48 && tag <= 57) {
            return StringBufferUnserializer.getStringBuffer((char)tag);
        }
        switch (tag) {
            case 116: {
                return new StringBuffer("true");
            }
            case 102: {
                return new StringBuffer("false");
            }
            case 78: {
                return new StringBuffer("NaN");
            }
            case 73: {
                return new StringBuffer(stream.read() == 43 ? "Infinity" : "-Infinity");
            }
            case 68: {
                return DefaultUnserializer.readDateTime(reader, stream).toStringBuffer();
            }
            case 84: {
                return DefaultUnserializer.readTime(reader, stream).toStringBuffer();
            }
            case 103: {
                return new StringBuffer(UUIDUnserializer.readUUID(reader, stream).toString());
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), StringBuffer.class);
    }

    @Override
    public final Object read(Reader reader, ByteBuffer buffer, Class<?> cls, Type type) throws IOException {
        return StringBufferUnserializer.read(reader, buffer);
    }

    @Override
    public final Object read(Reader reader, InputStream stream, Class<?> cls, Type type) throws IOException {
        return StringBufferUnserializer.read(reader, stream);
    }
}

