/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.io.unserialize.CharArrayUnserializer;
import hprose.io.unserialize.DefaultUnserializer;
import hprose.io.unserialize.Reader;
import hprose.io.unserialize.UUIDUnserializer;
import hprose.io.unserialize.Unserializer;
import hprose.io.unserialize.ValueReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class StringBuilderUnserializer
implements Unserializer {
    public static final StringBuilderUnserializer instance = new StringBuilderUnserializer();

    StringBuilderUnserializer() {
    }

    private static StringBuilder getStringBuilder(char[] chars) {
        return new StringBuilder(chars.length + 16).append(chars);
    }

    private static StringBuilder getStringBuilder(char c) {
        return new StringBuilder().append(c);
    }

    private static StringBuilder toStringBuilder(Object obj) {
        if (obj instanceof char[]) {
            return StringBuilderUnserializer.getStringBuilder((char[])obj);
        }
        return new StringBuilder(obj.toString());
    }

    static final StringBuilder read(Reader reader, ByteBuffer buffer) throws IOException {
        byte tag = buffer.get();
        switch (tag) {
            case 101: {
                return new StringBuilder();
            }
            case 110: {
                return null;
            }
            case 115: {
                return StringBuilderUnserializer.getStringBuilder(CharArrayUnserializer.readChars(reader, buffer));
            }
            case 117: {
                return StringBuilderUnserializer.getStringBuilder(ValueReader.readChar(buffer));
            }
            case 105: {
                return ValueReader.readUntil(buffer, 59);
            }
            case 108: {
                return ValueReader.readUntil(buffer, 59);
            }
            case 100: {
                return ValueReader.readUntil(buffer, 59);
            }
            case 114: {
                return StringBuilderUnserializer.toStringBuilder(reader.readRef(buffer));
            }
        }
        if (tag >= 48 && tag <= 57) {
            return StringBuilderUnserializer.getStringBuilder((char)tag);
        }
        switch (tag) {
            case 116: {
                return new StringBuilder("true");
            }
            case 102: {
                return new StringBuilder("false");
            }
            case 78: {
                return new StringBuilder("NaN");
            }
            case 73: {
                return new StringBuilder(buffer.get() == 43 ? "Infinity" : "-Infinity");
            }
            case 68: {
                return DefaultUnserializer.readDateTime(reader, buffer).toStringBuilder();
            }
            case 84: {
                return DefaultUnserializer.readTime(reader, buffer).toStringBuilder();
            }
            case 103: {
                return new StringBuilder(UUIDUnserializer.readUUID(reader, buffer).toString());
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), StringBuilder.class);
    }

    static final StringBuilder read(Reader reader, InputStream stream) throws IOException {
        int tag = stream.read();
        switch (tag) {
            case 101: {
                return new StringBuilder();
            }
            case 110: {
                return null;
            }
            case 115: {
                return StringBuilderUnserializer.getStringBuilder(CharArrayUnserializer.readChars(reader, stream));
            }
            case 117: {
                return StringBuilderUnserializer.getStringBuilder(ValueReader.readChar(stream));
            }
            case 105: {
                return ValueReader.readUntil(stream, 59);
            }
            case 108: {
                return ValueReader.readUntil(stream, 59);
            }
            case 100: {
                return ValueReader.readUntil(stream, 59);
            }
            case 114: {
                return StringBuilderUnserializer.toStringBuilder(reader.readRef(stream));
            }
        }
        if (tag >= 48 && tag <= 57) {
            return StringBuilderUnserializer.getStringBuilder((char)tag);
        }
        switch (tag) {
            case 116: {
                return new StringBuilder("true");
            }
            case 102: {
                return new StringBuilder("false");
            }
            case 78: {
                return new StringBuilder("NaN");
            }
            case 73: {
                return new StringBuilder(stream.read() == 43 ? "Infinity" : "-Infinity");
            }
            case 68: {
                return DefaultUnserializer.readDateTime(reader, stream).toStringBuilder();
            }
            case 84: {
                return DefaultUnserializer.readTime(reader, stream).toStringBuilder();
            }
            case 103: {
                return new StringBuilder(UUIDUnserializer.readUUID(reader, stream).toString());
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), StringBuilder.class);
    }

    @Override
    public final Object read(Reader reader, ByteBuffer buffer, Class<?> cls, Type type) throws IOException {
        return StringBuilderUnserializer.read(reader, buffer);
    }

    @Override
    public final Object read(Reader reader, InputStream stream, Class<?> cls, Type type) throws IOException {
        return StringBuilderUnserializer.read(reader, stream);
    }
}

