/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.io.unserialize.DefaultUnserializer;
import hprose.io.unserialize.Reader;
import hprose.io.unserialize.UUIDUnserializer;
import hprose.io.unserialize.Unserializer;
import hprose.io.unserialize.ValueReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class StringUnserializer
implements Unserializer {
    public static final StringUnserializer instance = new StringUnserializer();

    StringUnserializer() {
    }

    static final String readString(Reader reader, ByteBuffer buffer) throws IOException {
        String str = ValueReader.readString(buffer);
        reader.refer.set(str);
        return str;
    }

    static final String readString(Reader reader, InputStream stream) throws IOException {
        String str = ValueReader.readString(stream);
        reader.refer.set(str);
        return str;
    }

    private static String toString(Object obj) {
        if (obj instanceof char[]) {
            return new String((char[])obj);
        }
        return obj.toString();
    }

    static final String read(Reader reader, ByteBuffer buffer) throws IOException {
        byte tag = buffer.get();
        switch (tag) {
            case 101: {
                return "";
            }
            case 110: {
                return null;
            }
            case 115: {
                return StringUnserializer.readString(reader, buffer);
            }
            case 117: {
                return ValueReader.readUTF8Char(buffer);
            }
            case 105: {
                return ValueReader.readUntil(buffer, 59).toString();
            }
            case 108: {
                return ValueReader.readUntil(buffer, 59).toString();
            }
            case 100: {
                return ValueReader.readUntil(buffer, 59).toString();
            }
            case 114: {
                return StringUnserializer.toString(reader.readRef(buffer));
            }
        }
        if (tag >= 48 && tag <= 57) {
            return String.valueOf((char)tag);
        }
        switch (tag) {
            case 116: {
                return "true";
            }
            case 102: {
                return "false";
            }
            case 78: {
                return "NaN";
            }
            case 73: {
                return buffer.get() == 43 ? "Infinity" : "-Infinity";
            }
            case 68: {
                return DefaultUnserializer.readDateTime(reader, buffer).toString();
            }
            case 84: {
                return DefaultUnserializer.readTime(reader, buffer).toString();
            }
            case 103: {
                return UUIDUnserializer.readUUID(reader, buffer).toString();
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), String.class);
    }

    static final String read(Reader reader, InputStream stream) throws IOException {
        int tag = stream.read();
        switch (tag) {
            case 101: {
                return "";
            }
            case 110: {
                return null;
            }
            case 115: {
                return StringUnserializer.readString(reader, stream);
            }
            case 117: {
                return ValueReader.readUTF8Char(stream);
            }
            case 105: {
                return ValueReader.readUntil(stream, 59).toString();
            }
            case 108: {
                return ValueReader.readUntil(stream, 59).toString();
            }
            case 100: {
                return ValueReader.readUntil(stream, 59).toString();
            }
            case 114: {
                return StringUnserializer.toString(reader.readRef(stream));
            }
        }
        if (tag >= 48 && tag <= 57) {
            return String.valueOf((char)tag);
        }
        switch (tag) {
            case 116: {
                return "true";
            }
            case 102: {
                return "false";
            }
            case 78: {
                return "NaN";
            }
            case 73: {
                return stream.read() == 43 ? "Infinity" : "-Infinity";
            }
            case 68: {
                return DefaultUnserializer.readDateTime(reader, stream).toString();
            }
            case 84: {
                return DefaultUnserializer.readTime(reader, stream).toString();
            }
            case 103: {
                return UUIDUnserializer.readUUID(reader, stream).toString();
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), String.class);
    }

    @Override
    public final Object read(Reader reader, ByteBuffer buffer, Class<?> cls, Type type) throws IOException {
        return StringUnserializer.read(reader, buffer);
    }

    @Override
    public final Object read(Reader reader, InputStream stream, Class<?> cls, Type type) throws IOException {
        return StringUnserializer.read(reader, stream);
    }
}

