/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.io.unserialize.Reader;
import hprose.io.unserialize.TimeUnserializer;
import hprose.io.unserialize.Unserializer;
import hprose.io.unserialize.ValueReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.sql.Time;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TimeArrayUnserializer
implements Unserializer {
    public static final TimeArrayUnserializer instance = new TimeArrayUnserializer();

    TimeArrayUnserializer() {
    }

    static final Time[] read(Reader reader, ByteBuffer buffer) throws IOException {
        byte tag = buffer.get();
        switch (tag) {
            case 110: {
                return null;
            }
            case 97: {
                int count = ValueReader.readInt(buffer, 123);
                Time[] a = new Time[count];
                reader.refer.set(a);
                for (int i = 0; i < count; ++i) {
                    a[i] = TimeUnserializer.read(reader, buffer);
                }
                buffer.get();
                return a;
            }
            case 114: {
                return (Time[])reader.readRef(buffer);
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), Array.class);
    }

    static final Time[] read(Reader reader, InputStream stream) throws IOException {
        int tag = stream.read();
        switch (tag) {
            case 110: {
                return null;
            }
            case 97: {
                int count = ValueReader.readInt(stream, 123);
                Time[] a = new Time[count];
                reader.refer.set(a);
                for (int i = 0; i < count; ++i) {
                    a[i] = TimeUnserializer.read(reader, stream);
                }
                stream.read();
                return a;
            }
            case 114: {
                return (Time[])reader.readRef(stream);
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), Array.class);
    }

    @Override
    public final Object read(Reader reader, ByteBuffer buffer, Class<?> cls, Type type) throws IOException {
        return TimeArrayUnserializer.read(reader, buffer);
    }

    @Override
    public final Object read(Reader reader, InputStream stream, Class<?> cls, Type type) throws IOException {
        return TimeArrayUnserializer.read(reader, stream);
    }
}

