/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.common.HproseException;
import hprose.io.unserialize.DefaultUnserializer;
import hprose.io.unserialize.Reader;
import hprose.io.unserialize.StringUnserializer;
import hprose.io.unserialize.Unserializer;
import hprose.io.unserialize.ValueReader;
import hprose.util.DateTime;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.sql.Time;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TimeUnserializer
implements Unserializer {
    public static final TimeUnserializer instance = new TimeUnserializer();

    TimeUnserializer() {
    }

    private static Time toTime(Object obj) throws HproseException {
        if (obj instanceof DateTime) {
            return ((DateTime)obj).toTime();
        }
        if (obj instanceof char[]) {
            return Time.valueOf(new String((char[])obj));
        }
        return Time.valueOf(obj.toString());
    }

    static final Time read(Reader reader, ByteBuffer buffer) throws IOException {
        byte tag = buffer.get();
        switch (tag) {
            case 68: {
                return DefaultUnserializer.readDateTime(reader, buffer).toTime();
            }
            case 84: {
                return DefaultUnserializer.readTime(reader, buffer).toTime();
            }
            case 101: 
            case 110: {
                return null;
            }
            case 115: {
                return Time.valueOf(StringUnserializer.readString(reader, buffer));
            }
            case 114: {
                return TimeUnserializer.toTime(reader.readRef(buffer));
            }
        }
        if (tag >= 48 && tag <= 57) {
            return new Time(tag - 48);
        }
        switch (tag) {
            case 105: 
            case 108: {
                return new Time(ValueReader.readLong(buffer));
            }
            case 100: {
                return new Time(Double.valueOf(ValueReader.readDouble(buffer)).longValue());
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), Time.class);
    }

    static final Time read(Reader reader, InputStream stream) throws IOException {
        int tag = stream.read();
        switch (tag) {
            case 68: {
                return DefaultUnserializer.readDateTime(reader, stream).toTime();
            }
            case 84: {
                return DefaultUnserializer.readTime(reader, stream).toTime();
            }
            case 101: 
            case 110: {
                return null;
            }
            case 115: {
                return Time.valueOf(StringUnserializer.readString(reader, stream));
            }
            case 114: {
                return TimeUnserializer.toTime(reader.readRef(stream));
            }
        }
        if (tag >= 48 && tag <= 57) {
            return new Time(tag - 48);
        }
        switch (tag) {
            case 105: 
            case 108: {
                return new Time(ValueReader.readLong(stream));
            }
            case 100: {
                return new Time(Double.valueOf(ValueReader.readDouble(stream)).longValue());
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), Time.class);
    }

    @Override
    public final Object read(Reader reader, ByteBuffer buffer, Class<?> cls, Type type) throws IOException {
        return TimeUnserializer.read(reader, buffer);
    }

    @Override
    public final Object read(Reader reader, InputStream stream, Class<?> cls, Type type) throws IOException {
        return TimeUnserializer.read(reader, stream);
    }
}

