/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.io.unserialize.Reader;
import hprose.io.unserialize.Unserializer;
import hprose.io.unserialize.ValueReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TimeZoneUnserializer
implements Unserializer {
    public static final TimeZoneUnserializer instance = new TimeZoneUnserializer();

    TimeZoneUnserializer() {
    }

    static final TimeZone readTimeZone(Reader reader, ByteBuffer buffer) throws IOException {
        TimeZone tz = TimeZone.getTimeZone(ValueReader.readString(buffer));
        reader.refer.set(tz);
        return tz;
    }

    static final TimeZone readTimeZone(Reader reader, InputStream stream) throws IOException {
        TimeZone tz = TimeZone.getTimeZone(ValueReader.readString(stream));
        reader.refer.set(tz);
        return tz;
    }

    private static TimeZone toTimeZone(Object obj) throws IOException {
        if (obj instanceof TimeZone) {
            return (TimeZone)obj;
        }
        if (obj instanceof char[]) {
            return TimeZone.getTimeZone(new String((char[])obj));
        }
        return TimeZone.getTimeZone(obj.toString());
    }

    static final TimeZone read(Reader reader, ByteBuffer buffer) throws IOException {
        byte tag = buffer.get();
        switch (tag) {
            case 101: 
            case 110: {
                return null;
            }
            case 115: {
                return TimeZoneUnserializer.readTimeZone(reader, buffer);
            }
            case 114: {
                return TimeZoneUnserializer.toTimeZone(reader.readRef(buffer));
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), TimeZone.class);
    }

    static final TimeZone read(Reader reader, InputStream stream) throws IOException {
        int tag = stream.read();
        switch (tag) {
            case 101: 
            case 110: {
                return null;
            }
            case 115: {
                return TimeZoneUnserializer.readTimeZone(reader, stream);
            }
            case 114: {
                return TimeZoneUnserializer.toTimeZone(reader.readRef(stream));
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), TimeZone.class);
    }

    @Override
    public final Object read(Reader reader, ByteBuffer buffer, Class<?> cls, Type type) throws IOException {
        return TimeZoneUnserializer.read(reader, buffer);
    }

    @Override
    public final Object read(Reader reader, InputStream stream, Class<?> cls, Type type) throws IOException {
        return TimeZoneUnserializer.read(reader, stream);
    }
}

