/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.io.unserialize.DefaultUnserializer;
import hprose.io.unserialize.Reader;
import hprose.io.unserialize.StringUnserializer;
import hprose.io.unserialize.Unserializer;
import hprose.io.unserialize.ValueReader;
import hprose.util.DateTime;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.sql.Timestamp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TimestampUnserializer
implements Unserializer {
    public static final TimestampUnserializer instance = new TimestampUnserializer();

    TimestampUnserializer() {
    }

    private static Timestamp toTimestamp(Object obj) {
        if (obj instanceof DateTime) {
            return ((DateTime)obj).toTimestamp();
        }
        if (obj instanceof char[]) {
            return Timestamp.valueOf(new String((char[])obj));
        }
        return Timestamp.valueOf(obj.toString());
    }

    static final Timestamp read(Reader reader, ByteBuffer buffer) throws IOException {
        byte tag = buffer.get();
        switch (tag) {
            case 68: {
                return DefaultUnserializer.readDateTime(reader, buffer).toTimestamp();
            }
            case 84: {
                return DefaultUnserializer.readTime(reader, buffer).toTimestamp();
            }
            case 101: 
            case 110: {
                return null;
            }
            case 115: {
                return Timestamp.valueOf(StringUnserializer.readString(reader, buffer));
            }
            case 114: {
                return TimestampUnserializer.toTimestamp(reader.readRef(buffer));
            }
        }
        if (tag >= 48 && tag <= 57) {
            return new Timestamp(tag - 48);
        }
        switch (tag) {
            case 105: 
            case 108: {
                return new Timestamp(ValueReader.readLong(buffer));
            }
            case 100: {
                return new Timestamp(Double.valueOf(ValueReader.readDouble(buffer)).longValue());
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), Timestamp.class);
    }

    static final Timestamp read(Reader reader, InputStream stream) throws IOException {
        int tag = stream.read();
        switch (tag) {
            case 68: {
                return DefaultUnserializer.readDateTime(reader, stream).toTimestamp();
            }
            case 84: {
                return DefaultUnserializer.readTime(reader, stream).toTimestamp();
            }
            case 101: 
            case 110: {
                return null;
            }
            case 115: {
                return Timestamp.valueOf(StringUnserializer.readString(reader, stream));
            }
            case 114: {
                return TimestampUnserializer.toTimestamp(reader.readRef(stream));
            }
        }
        if (tag >= 48 && tag <= 57) {
            return new Timestamp(tag - 48);
        }
        switch (tag) {
            case 105: 
            case 108: {
                return new Timestamp(ValueReader.readLong(stream));
            }
            case 100: {
                return new Timestamp(Double.valueOf(ValueReader.readDouble(stream)).longValue());
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), Timestamp.class);
    }

    @Override
    public final Object read(Reader reader, ByteBuffer buffer, Class<?> cls, Type type) throws IOException {
        return TimestampUnserializer.read(reader, buffer);
    }

    @Override
    public final Object read(Reader reader, InputStream stream, Class<?> cls, Type type) throws IOException {
        return TimestampUnserializer.read(reader, stream);
    }
}

