/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.io.unserialize.Reader;
import hprose.io.unserialize.Unserializer;
import hprose.io.unserialize.ValueReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class URIUnserializer
implements Unserializer {
    public static final URIUnserializer instance = new URIUnserializer();

    URIUnserializer() {
    }

    private static URI toURI(String s) throws IOException {
        try {
            return new URI(s);
        }
        catch (URISyntaxException e) {
            throw ValueReader.castError("String: '" + s + "'", URI.class);
        }
    }

    static final URI readURI(Reader reader, ByteBuffer buffer) throws IOException {
        URI u = URIUnserializer.toURI(ValueReader.readString(buffer));
        reader.refer.set(u);
        return u;
    }

    static final URI readURI(Reader reader, InputStream stream) throws IOException {
        URI u = URIUnserializer.toURI(ValueReader.readString(stream));
        reader.refer.set(u);
        return u;
    }

    private static URI toURI(Object obj) throws IOException {
        if (obj instanceof URI) {
            return (URI)obj;
        }
        if (obj instanceof char[]) {
            return URIUnserializer.toURI(new String((char[])obj));
        }
        return URIUnserializer.toURI(obj.toString());
    }

    static final URI read(Reader reader, ByteBuffer buffer) throws IOException {
        byte tag = buffer.get();
        switch (tag) {
            case 101: 
            case 110: {
                return null;
            }
            case 115: {
                return URIUnserializer.readURI(reader, buffer);
            }
            case 114: {
                return URIUnserializer.toURI(reader.readRef(buffer));
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), URI.class);
    }

    static final URI read(Reader reader, InputStream stream) throws IOException {
        int tag = stream.read();
        switch (tag) {
            case 101: 
            case 110: {
                return null;
            }
            case 115: {
                return URIUnserializer.readURI(reader, stream);
            }
            case 114: {
                return URIUnserializer.toURI(reader.readRef(stream));
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), URI.class);
    }

    @Override
    public final Object read(Reader reader, ByteBuffer buffer, Class<?> cls, Type type) throws IOException {
        return URIUnserializer.read(reader, buffer);
    }

    @Override
    public final Object read(Reader reader, InputStream stream, Class<?> cls, Type type) throws IOException {
        return URIUnserializer.read(reader, stream);
    }
}

