/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.io.unserialize.Reader;
import hprose.io.unserialize.Unserializer;
import hprose.io.unserialize.ValueReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class URLUnserializer
implements Unserializer {
    public static final URLUnserializer instance = new URLUnserializer();

    URLUnserializer() {
    }

    private static URL toURL(String s) throws IOException {
        try {
            return new URL(s);
        }
        catch (MalformedURLException e) {
            throw ValueReader.castError("String: '" + s + "'", URL.class);
        }
    }

    static final URL readURL(Reader reader, ByteBuffer buffer) throws IOException {
        URL u = URLUnserializer.toURL(ValueReader.readString(buffer));
        reader.refer.set(u);
        return u;
    }

    static final URL readURL(Reader reader, InputStream stream) throws IOException {
        URL u = URLUnserializer.toURL(ValueReader.readString(stream));
        reader.refer.set(u);
        return u;
    }

    private static URL toURL(Object obj) throws IOException {
        if (obj instanceof URL) {
            return (URL)obj;
        }
        if (obj instanceof char[]) {
            return URLUnserializer.toURL(new String((char[])obj));
        }
        return URLUnserializer.toURL(obj.toString());
    }

    static final URL read(Reader reader, ByteBuffer buffer) throws IOException {
        byte tag = buffer.get();
        switch (tag) {
            case 101: 
            case 110: {
                return null;
            }
            case 115: {
                return URLUnserializer.readURL(reader, buffer);
            }
            case 114: {
                return URLUnserializer.toURL(reader.readRef(buffer));
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), URL.class);
    }

    static final URL read(Reader reader, InputStream stream) throws IOException {
        int tag = stream.read();
        switch (tag) {
            case 101: 
            case 110: {
                return null;
            }
            case 115: {
                return URLUnserializer.readURL(reader, stream);
            }
            case 114: {
                return URLUnserializer.toURL(reader.readRef(stream));
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), URL.class);
    }

    @Override
    public final Object read(Reader reader, ByteBuffer buffer, Class<?> cls, Type type) throws IOException {
        return URLUnserializer.read(reader, buffer);
    }

    @Override
    public final Object read(Reader reader, InputStream stream, Class<?> cls, Type type) throws IOException {
        return URLUnserializer.read(reader, stream);
    }
}

