/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.common.HproseException;
import hprose.io.unserialize.ByteArrayUnserializer;
import hprose.io.unserialize.Reader;
import hprose.io.unserialize.StringUnserializer;
import hprose.io.unserialize.Unserializer;
import hprose.io.unserialize.ValueReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class UUIDUnserializer
implements Unserializer {
    public static final UUIDUnserializer instance = new UUIDUnserializer();

    UUIDUnserializer() {
    }

    static final UUID readUUID(Reader reader, ByteBuffer buffer) throws IOException {
        UUID uuid = ValueReader.readUUID(buffer);
        reader.refer.set(uuid);
        return uuid;
    }

    static final UUID readUUID(Reader reader, InputStream stream) throws IOException {
        UUID uuid = ValueReader.readUUID(stream);
        reader.refer.set(uuid);
        return uuid;
    }

    private static UUID toUUID(Object obj) throws HproseException {
        if (obj instanceof UUID) {
            return (UUID)obj;
        }
        if (obj instanceof byte[]) {
            return UUID.nameUUIDFromBytes((byte[])obj);
        }
        if (obj instanceof String) {
            return UUID.fromString((String)obj);
        }
        if (obj instanceof char[]) {
            return UUID.fromString(new String((char[])obj));
        }
        throw ValueReader.castError(obj, UUID.class);
    }

    static final UUID read(Reader reader, ByteBuffer buffer) throws IOException {
        byte tag = buffer.get();
        switch (tag) {
            case 101: 
            case 110: {
                return null;
            }
            case 103: {
                return UUIDUnserializer.readUUID(reader, buffer);
            }
            case 98: {
                return UUID.nameUUIDFromBytes(ByteArrayUnserializer.readBytes(reader, buffer));
            }
            case 115: {
                return UUID.fromString(StringUnserializer.readString(reader, buffer));
            }
            case 114: {
                return UUIDUnserializer.toUUID(reader.readRef(buffer));
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), UUID.class);
    }

    static final UUID read(Reader reader, InputStream stream) throws IOException {
        int tag = stream.read();
        switch (tag) {
            case 101: 
            case 110: {
                return null;
            }
            case 103: {
                return UUIDUnserializer.readUUID(reader, stream);
            }
            case 98: {
                return UUID.nameUUIDFromBytes(ByteArrayUnserializer.readBytes(reader, stream));
            }
            case 115: {
                return UUID.fromString(StringUnserializer.readString(reader, stream));
            }
            case 114: {
                return UUIDUnserializer.toUUID(reader.readRef(stream));
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), UUID.class);
    }

    @Override
    public final Object read(Reader reader, ByteBuffer buffer, Class<?> cls, Type type) throws IOException {
        return UUIDUnserializer.read(reader, buffer);
    }

    @Override
    public final Object read(Reader reader, InputStream stream, Class<?> cls, Type type) throws IOException {
        return UUIDUnserializer.read(reader, stream);
    }
}

