/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.common.HproseException;
import hprose.util.DateTime;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.UUID;

public final class ValueReader {
    static final HproseException badEncoding(int c) {
        return new HproseException("bad utf-8 encoding at " + (c < 0 ? "end of stream" : "0x" + Integer.toHexString(c & 0xFF)));
    }

    static final HproseException castError(String srctype, Type desttype) {
        return new HproseException(srctype + " can't change to " + desttype.toString());
    }

    static final HproseException castError(Object obj, Type type) {
        return new HproseException(obj.getClass().toString() + " can't change to " + type.toString());
    }

    static final int readInt(ByteBuffer buffer, int tag) throws IOException {
        int result = 0;
        byte i = buffer.get();
        if (i == tag) {
            return result;
        }
        boolean neg = false;
        switch (i) {
            case 45: {
                neg = true;
            }
            case 43: {
                i = buffer.get();
            }
        }
        if (neg) {
            while (i != tag) {
                result = result * 10 - (i - 48);
                i = buffer.get();
            }
        } else {
            while (i != tag) {
                result = result * 10 + (i - 48);
                i = buffer.get();
            }
        }
        return result;
    }

    static final int readInt(InputStream stream, int tag) throws IOException {
        int result = 0;
        int i = stream.read();
        if (i == tag) {
            return result;
        }
        boolean neg = false;
        switch (i) {
            case 45: {
                neg = true;
            }
            case 43: {
                i = stream.read();
            }
        }
        if (neg) {
            while (i != tag && i != -1) {
                result = result * 10 - (i - 48);
                i = stream.read();
            }
        } else {
            while (i != tag && i != -1) {
                result = result * 10 + (i - 48);
                i = stream.read();
            }
        }
        return result;
    }

    static final long readLong(ByteBuffer buffer, int tag) throws IOException {
        long result = 0L;
        byte i = buffer.get();
        if (i == tag) {
            return result;
        }
        boolean neg = false;
        switch (i) {
            case 45: {
                neg = true;
            }
            case 43: {
                i = buffer.get();
            }
        }
        if (neg) {
            while (i != tag) {
                result = result * 10L - (long)(i - 48);
                i = buffer.get();
            }
        } else {
            while (i != tag) {
                result = result * 10L + (long)(i - 48);
                i = buffer.get();
            }
        }
        return result;
    }

    static final long readLong(InputStream stream, int tag) throws IOException {
        long result = 0L;
        int i = stream.read();
        if (i == tag) {
            return result;
        }
        boolean neg = false;
        switch (i) {
            case 45: {
                neg = true;
            }
            case 43: {
                i = stream.read();
            }
        }
        if (neg) {
            while (i != tag && i != -1) {
                result = result * 10L - (long)(i - 48);
                i = stream.read();
            }
        } else {
            while (i != tag && i != -1) {
                result = result * 10L + (long)(i - 48);
                i = stream.read();
            }
        }
        return result;
    }

    static final float readLongAsFloat(ByteBuffer buffer) throws IOException {
        float result = 0.0f;
        byte i = buffer.get();
        if (i == 59) {
            return result;
        }
        boolean neg = false;
        switch (i) {
            case 45: {
                neg = true;
            }
            case 43: {
                i = buffer.get();
            }
        }
        if (neg) {
            while (i != 59) {
                result = result * 10.0f - (float)(i - 48);
                i = buffer.get();
            }
        } else {
            while (i != 59) {
                result = result * 10.0f + (float)(i - 48);
                i = buffer.get();
            }
        }
        return result;
    }

    static final float readLongAsFloat(InputStream stream) throws IOException {
        float result = 0.0f;
        int i = stream.read();
        if (i == 59) {
            return result;
        }
        boolean neg = false;
        switch (i) {
            case 45: {
                neg = true;
            }
            case 43: {
                i = stream.read();
            }
        }
        if (neg) {
            while (i != 59 && i != -1) {
                result = result * 10.0f - (float)(i - 48);
                i = stream.read();
            }
        } else {
            while (i != 59 && i != -1) {
                result = result * 10.0f + (float)(i - 48);
                i = stream.read();
            }
        }
        return result;
    }

    static final double readLongAsDouble(ByteBuffer buffer) throws IOException {
        double result = 0.0;
        byte i = buffer.get();
        if (i == 59) {
            return result;
        }
        boolean neg = false;
        switch (i) {
            case 45: {
                neg = true;
            }
            case 43: {
                i = buffer.get();
            }
        }
        if (neg) {
            while (i != 59) {
                result = result * 10.0 - (double)(i - 48);
                i = buffer.get();
            }
        } else {
            while (i != 59) {
                result = result * 10.0 + (double)(i - 48);
                i = buffer.get();
            }
        }
        return result;
    }

    static final double readLongAsDouble(InputStream stream) throws IOException {
        double result = 0.0;
        int i = stream.read();
        if (i == 59) {
            return result;
        }
        boolean neg = false;
        switch (i) {
            case 45: {
                neg = true;
            }
            case 43: {
                i = stream.read();
            }
        }
        if (neg) {
            while (i != 59 && i != -1) {
                result = result * 10.0 - (double)(i - 48);
                i = stream.read();
            }
        } else {
            while (i != 59 && i != -1) {
                result = result * 10.0 + (double)(i - 48);
                i = stream.read();
            }
        }
        return result;
    }

    static final float parseFloat(String value) {
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            return Float.NaN;
        }
    }

    static final double parseDouble(String value) {
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    static final float parseFloat(StringBuilder value) {
        try {
            return Float.parseFloat(value.toString());
        }
        catch (NumberFormatException e) {
            return Float.NaN;
        }
    }

    static final double parseDouble(StringBuilder value) {
        try {
            return Double.parseDouble(value.toString());
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    static final StringBuilder readUntil(ByteBuffer buffer, int tag) throws IOException {
        StringBuilder sb = new StringBuilder();
        byte i = buffer.get();
        while (i != tag) {
            sb.append((char)i);
            i = buffer.get();
        }
        return sb;
    }

    static final StringBuilder readUntil(InputStream stream, int tag) throws IOException {
        StringBuilder sb = new StringBuilder();
        int i = stream.read();
        while (i != tag && i != -1) {
            sb.append((char)i);
            i = stream.read();
        }
        return sb;
    }

    static final char[] readChars(ByteBuffer buffer) throws IOException {
        int count = ValueReader.readInt(buffer, 34);
        char[] buf = new char[count];
        block6: for (int i = 0; i < count; ++i) {
            byte b1 = buffer.get();
            switch ((b1 & 0xFF) >>> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    buf[i] = (char)b1;
                    continue block6;
                }
                case 12: 
                case 13: {
                    byte b2 = buffer.get();
                    buf[i] = (char)(b1 << 6 ^ b2 ^ 0xF80);
                    continue block6;
                }
                case 14: {
                    byte b2 = buffer.get();
                    byte b3 = buffer.get();
                    buf[i] = (char)(b1 << 12 ^ b2 << 6 ^ b3 ^ 0x1F80);
                    continue block6;
                }
                case 15: {
                    byte b4;
                    int s;
                    byte b3;
                    byte b2;
                    if ((b1 & 0xF) <= 4 && 0 <= (s = (b1 & 7) << 18 | ((b2 = buffer.get()) & 0x3F) << 12 | ((b3 = buffer.get()) & 0x3F) << 6 | ((b4 = buffer.get()) & 0x3F) - 65536) && s <= 1048575) {
                        buf[i] = (char)(s >> 10 & 0x3FF | 0xD800);
                        buf[++i] = (char)(s & 0x3FF | 0xDC00);
                        continue block6;
                    }
                }
                default: {
                    throw ValueReader.badEncoding(b1);
                }
            }
        }
        buffer.get();
        return buf;
    }

    static final char[] readChars(InputStream stream) throws IOException {
        int count = ValueReader.readInt(stream, 34);
        char[] buf = new char[count];
        block6: for (int i = 0; i < count; ++i) {
            int b1 = stream.read();
            switch (b1 >>> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    buf[i] = (char)b1;
                    continue block6;
                }
                case 12: 
                case 13: {
                    int b2 = stream.read();
                    buf[i] = (char)((b1 & 0x1F) << 6 | b2 & 0x3F);
                    continue block6;
                }
                case 14: {
                    int b2 = stream.read();
                    int b3 = stream.read();
                    buf[i] = (char)((b1 & 0xF) << 12 | (b2 & 0x3F) << 6 | b3 & 0x3F);
                    continue block6;
                }
                case 15: {
                    int b4;
                    int s;
                    int b3;
                    int b2;
                    if ((b1 & 0xF) <= 4 && 0 <= (s = (b1 & 7) << 18 | ((b2 = stream.read()) & 0x3F) << 12 | ((b3 = stream.read()) & 0x3F) << 6 | ((b4 = stream.read()) & 0x3F) - 65536) && s <= 1048575) {
                        buf[i] = (char)(s >> 10 & 0x3FF | 0xD800);
                        buf[++i] = (char)(s & 0x3FF | 0xDC00);
                        continue block6;
                    }
                }
                default: {
                    throw ValueReader.badEncoding(b1);
                }
            }
        }
        stream.read();
        return buf;
    }

    static final char readChar(ByteBuffer buffer) throws IOException {
        char u;
        byte b1 = buffer.get();
        switch ((b1 & 0xFF) >>> 4) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                u = (char)b1;
                break;
            }
            case 12: 
            case 13: {
                byte b2 = buffer.get();
                u = (char)(b1 << 6 ^ b2 ^ 0xF80);
                break;
            }
            case 14: {
                byte b2 = buffer.get();
                byte b3 = buffer.get();
                u = (char)(b1 << 12 ^ b2 << 6 ^ b3 ^ 0x1F80);
                break;
            }
            default: {
                throw ValueReader.badEncoding(b1);
            }
        }
        return u;
    }

    static final char readChar(InputStream stream) throws IOException {
        char u;
        int b1 = stream.read();
        switch (b1 >>> 4) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                u = (char)b1;
                break;
            }
            case 12: 
            case 13: {
                int b2 = stream.read();
                u = (char)((b1 & 0x1F) << 6 | b2 & 0x3F);
                break;
            }
            case 14: {
                int b2 = stream.read();
                int b3 = stream.read();
                u = (char)((b1 & 0xF) << 12 | (b2 & 0x3F) << 6 | b3 & 0x3F);
                break;
            }
            default: {
                throw ValueReader.badEncoding(b1);
            }
        }
        return u;
    }

    static final int readInt(ByteBuffer buffer) throws IOException {
        return ValueReader.readInt(buffer, 59);
    }

    static final int readInt(InputStream stream) throws IOException {
        return ValueReader.readInt(stream, 59);
    }

    static final long readLong(ByteBuffer buffer) throws IOException {
        return ValueReader.readLong(buffer, 59);
    }

    static final long readLong(InputStream stream) throws IOException {
        return ValueReader.readLong(stream, 59);
    }

    static final BigInteger readBigInteger(ByteBuffer buffer) throws IOException {
        return new BigInteger(ValueReader.readUntil(buffer, 59).toString(), 10);
    }

    static final BigInteger readBigInteger(InputStream stream) throws IOException {
        return new BigInteger(ValueReader.readUntil(stream, 59).toString(), 10);
    }

    static final float readFloat(ByteBuffer buffer) throws IOException {
        return ValueReader.parseFloat(ValueReader.readUntil(buffer, 59));
    }

    static final float readFloat(InputStream stream) throws IOException {
        return ValueReader.parseFloat(ValueReader.readUntil(stream, 59));
    }

    static final double readDouble(ByteBuffer buffer) throws IOException {
        return ValueReader.parseDouble(ValueReader.readUntil(buffer, 59));
    }

    static final double readDouble(InputStream stream) throws IOException {
        return ValueReader.parseDouble(ValueReader.readUntil(stream, 59));
    }

    static final double readInfinity(ByteBuffer buffer) throws IOException {
        return buffer.get() == 45 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
    }

    static final double readInfinity(InputStream stream) throws IOException {
        return stream.read() == 45 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
    }

    static final String readString(ByteBuffer buffer) throws IOException {
        return new String(ValueReader.readChars(buffer));
    }

    static final String readString(InputStream stream) throws IOException {
        return new String(ValueReader.readChars(stream));
    }

    static final String readUTF8Char(ByteBuffer buffer) throws IOException {
        return new String(new char[]{ValueReader.readChar(buffer)});
    }

    static final String readUTF8Char(InputStream stream) throws IOException {
        return new String(new char[]{ValueReader.readChar(stream)});
    }

    static final byte[] readBytes(ByteBuffer buffer) throws IOException {
        int len = ValueReader.readInt(buffer, 34);
        byte[] b = new byte[len];
        buffer.get(b, 0, len);
        buffer.get();
        return b;
    }

    static final byte[] readBytes(InputStream stream) throws IOException {
        int size;
        int len;
        int off = 0;
        byte[] b = new byte[len];
        for (len = ValueReader.readInt(stream, 34); len > 0; len -= size) {
            size = stream.read(b, off, len);
            off += size;
        }
        stream.read();
        return b;
    }

    private static int read4Digit(ByteBuffer buffer) throws IOException {
        int n = buffer.get() - 48;
        n = n * 10 + buffer.get() - 48;
        n = n * 10 + buffer.get() - 48;
        return n * 10 + buffer.get() - 48;
    }

    private static int read2Digit(ByteBuffer buffer) throws IOException {
        int n = buffer.get() - 48;
        return n * 10 + buffer.get() - 48;
    }

    private static int read4Digit(InputStream stream) throws IOException {
        int n = stream.read() - 48;
        n = n * 10 + stream.read() - 48;
        n = n * 10 + stream.read() - 48;
        return n * 10 + stream.read() - 48;
    }

    private static int read2Digit(InputStream stream) throws IOException {
        int n = stream.read() - 48;
        return n * 10 + stream.read() - 48;
    }

    static final int readTime(ByteBuffer buffer, DateTime dt) throws IOException {
        dt.hour = ValueReader.read2Digit(buffer);
        dt.minute = ValueReader.read2Digit(buffer);
        dt.second = ValueReader.read2Digit(buffer);
        byte tag = buffer.get();
        if (tag == 46) {
            dt.nanosecond = buffer.get() - 48;
            dt.nanosecond = dt.nanosecond * 10 + (buffer.get() - 48);
            dt.nanosecond = dt.nanosecond * 10 + (buffer.get() - 48);
            dt.nanosecond *= 1000000;
            tag = buffer.get();
            if (tag >= 48 && tag <= 57) {
                dt.nanosecond += (tag - 48) * 100000;
                dt.nanosecond += (buffer.get() - 48) * 10000;
                dt.nanosecond += (buffer.get() - 48) * 1000;
                tag = buffer.get();
                if (tag >= 48 && tag <= 57) {
                    dt.nanosecond += (tag - 48) * 100;
                    dt.nanosecond += (buffer.get() - 48) * 10;
                    dt.nanosecond += buffer.get() - 48;
                    tag = buffer.get();
                }
            }
        }
        return tag;
    }

    static final int readTime(InputStream stream, DateTime dt) throws IOException {
        dt.hour = ValueReader.read2Digit(stream);
        dt.minute = ValueReader.read2Digit(stream);
        dt.second = ValueReader.read2Digit(stream);
        int tag = stream.read();
        if (tag == 46) {
            dt.nanosecond = stream.read() - 48;
            dt.nanosecond = dt.nanosecond * 10 + (stream.read() - 48);
            dt.nanosecond = dt.nanosecond * 10 + (stream.read() - 48);
            dt.nanosecond *= 1000000;
            tag = stream.read();
            if (tag >= 48 && tag <= 57) {
                dt.nanosecond += (tag - 48) * 100000;
                dt.nanosecond += (stream.read() - 48) * 10000;
                dt.nanosecond += (stream.read() - 48) * 1000;
                tag = stream.read();
                if (tag >= 48 && tag <= 57) {
                    dt.nanosecond += (tag - 48) * 100;
                    dt.nanosecond += (stream.read() - 48) * 10;
                    dt.nanosecond += stream.read() - 48;
                    tag = stream.read();
                }
            }
        }
        return tag;
    }

    static final DateTime readDateTime(ByteBuffer buffer) throws IOException {
        DateTime dt = new DateTime();
        dt.year = ValueReader.read4Digit(buffer);
        dt.month = ValueReader.read2Digit(buffer);
        dt.day = ValueReader.read2Digit(buffer);
        int tag = buffer.get();
        if (tag == 84) {
            tag = ValueReader.readTime(buffer, dt);
        }
        dt.utc = tag == 90;
        return dt;
    }

    static final DateTime readDateTime(InputStream stream) throws IOException {
        DateTime dt = new DateTime();
        dt.year = ValueReader.read4Digit(stream);
        dt.month = ValueReader.read2Digit(stream);
        dt.day = ValueReader.read2Digit(stream);
        int tag = stream.read();
        if (tag == 84) {
            tag = ValueReader.readTime(stream, dt);
        }
        dt.utc = tag == 90;
        return dt;
    }

    static final DateTime readTime(ByteBuffer buffer) throws IOException {
        DateTime dt = new DateTime();
        boolean bl = ValueReader.readTime(buffer, dt) == 90;
        dt.utc = bl;
        return dt;
    }

    static final DateTime readTime(InputStream stream) throws IOException {
        DateTime dt = new DateTime();
        boolean bl = ValueReader.readTime(stream, dt) == 90;
        dt.utc = bl;
        return dt;
    }

    static UUID readUUID(ByteBuffer buffer) {
        buffer.get();
        char[] buf = new char[36];
        for (int i = 0; i < 36; ++i) {
            buf[i] = (char)buffer.get();
        }
        buffer.get();
        UUID uuid = UUID.fromString(new String(buf));
        return uuid;
    }

    static UUID readUUID(InputStream stream) throws IOException {
        stream.read();
        char[] buf = new char[36];
        for (int i = 0; i < 36; ++i) {
            buf[i] = (char)stream.read();
        }
        stream.read();
        UUID uuid = UUID.fromString(new String(buf));
        return uuid;
    }
}

