/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.io.unserialize.DefaultUnserializer;
import hprose.io.unserialize.Reader;
import hprose.io.unserialize.StringUnserializer;
import hprose.io.unserialize.Unserializer;
import hprose.io.unserialize.ValueReader;
import hprose.util.DateTime;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.time.YearMonth;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class YearMonthUnserializer
implements Unserializer {
    public static final YearMonthUnserializer instance = new YearMonthUnserializer();

    YearMonthUnserializer() {
    }

    private static YearMonth toYearMonth(DateTime dt) {
        return YearMonth.of(dt.year, dt.month);
    }

    private static YearMonth toYearMonth(Object obj) {
        if (obj instanceof DateTime) {
            return YearMonthUnserializer.toYearMonth((DateTime)obj);
        }
        if (obj instanceof char[]) {
            return YearMonth.parse(new String((char[])obj));
        }
        return YearMonth.parse(obj.toString());
    }

    static final YearMonth read(Reader reader, ByteBuffer buffer) throws IOException {
        byte tag = buffer.get();
        switch (tag) {
            case 115: {
                return YearMonth.parse(StringUnserializer.readString(reader, buffer));
            }
            case 68: {
                return YearMonthUnserializer.toYearMonth(DefaultUnserializer.readDateTime(reader, buffer));
            }
            case 84: {
                return YearMonthUnserializer.toYearMonth(DefaultUnserializer.readTime(reader, buffer));
            }
            case 101: 
            case 110: {
                return null;
            }
            case 114: {
                return YearMonthUnserializer.toYearMonth(reader.readRef(buffer));
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), YearMonth.class);
    }

    static final YearMonth read(Reader reader, InputStream stream) throws IOException {
        int tag = stream.read();
        switch (tag) {
            case 115: {
                return YearMonth.parse(StringUnserializer.readString(reader, stream));
            }
            case 68: {
                return YearMonthUnserializer.toYearMonth(DefaultUnserializer.readDateTime(reader, stream));
            }
            case 84: {
                return YearMonthUnserializer.toYearMonth(DefaultUnserializer.readTime(reader, stream));
            }
            case 101: 
            case 110: {
                return null;
            }
            case 114: {
                return YearMonthUnserializer.toYearMonth(reader.readRef(stream));
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), YearMonth.class);
    }

    @Override
    public final Object read(Reader reader, ByteBuffer buffer, Class<?> cls, Type type) throws IOException {
        return YearMonthUnserializer.read(reader, buffer);
    }

    @Override
    public final Object read(Reader reader, InputStream stream, Class<?> cls, Type type) throws IOException {
        return YearMonthUnserializer.read(reader, stream);
    }
}

