/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.io.unserialize.DefaultUnserializer;
import hprose.io.unserialize.Reader;
import hprose.io.unserialize.StringUnserializer;
import hprose.io.unserialize.Unserializer;
import hprose.io.unserialize.ValueReader;
import hprose.util.DateTime;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.time.Year;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class YearUnserializer
implements Unserializer {
    public static final YearUnserializer instance = new YearUnserializer();

    YearUnserializer() {
    }

    private static Year toYear(DateTime dt) {
        return Year.of(dt.year);
    }

    private static Year toYear(Object obj) {
        if (obj instanceof DateTime) {
            return YearUnserializer.toYear((DateTime)obj);
        }
        if (obj instanceof char[]) {
            return Year.parse(new String((char[])obj));
        }
        return Year.parse(obj.toString());
    }

    static final Year read(Reader reader, ByteBuffer buffer) throws IOException {
        byte tag = buffer.get();
        switch (tag) {
            case 115: {
                return Year.parse(StringUnserializer.readString(reader, buffer));
            }
            case 68: {
                return YearUnserializer.toYear(DefaultUnserializer.readDateTime(reader, buffer));
            }
            case 84: {
                return YearUnserializer.toYear(DefaultUnserializer.readTime(reader, buffer));
            }
            case 101: 
            case 110: {
                return null;
            }
            case 114: {
                return YearUnserializer.toYear(reader.readRef(buffer));
            }
        }
        if (tag >= 48 && tag <= 57) {
            return Year.of(tag - 48);
        }
        switch (tag) {
            case 105: 
            case 108: {
                return Year.of(ValueReader.readInt(buffer));
            }
            case 100: {
                return Year.of(Double.valueOf(ValueReader.readDouble(buffer)).intValue());
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), Year.class);
    }

    static final Year read(Reader reader, InputStream stream) throws IOException {
        int tag = stream.read();
        switch (tag) {
            case 115: {
                return Year.parse(StringUnserializer.readString(reader, stream));
            }
            case 68: {
                return YearUnserializer.toYear(DefaultUnserializer.readDateTime(reader, stream));
            }
            case 84: {
                return YearUnserializer.toYear(DefaultUnserializer.readTime(reader, stream));
            }
            case 101: 
            case 110: {
                return null;
            }
            case 114: {
                return YearUnserializer.toYear(reader.readRef(stream));
            }
        }
        if (tag >= 48 && tag <= 57) {
            return Year.of(tag - 48);
        }
        switch (tag) {
            case 105: 
            case 108: {
                return Year.of(ValueReader.readInt(stream));
            }
            case 100: {
                return Year.of(Double.valueOf(ValueReader.readDouble(stream)).intValue());
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), Year.class);
    }

    @Override
    public final Object read(Reader reader, ByteBuffer buffer, Class<?> cls, Type type) throws IOException {
        return YearUnserializer.read(reader, buffer);
    }

    @Override
    public final Object read(Reader reader, InputStream stream, Class<?> cls, Type type) throws IOException {
        return YearUnserializer.read(reader, stream);
    }
}

