/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.io.unserialize.Reader;
import hprose.io.unserialize.Unserializer;
import hprose.io.unserialize.ValueReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.time.ZoneId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ZoneIdUnserializer
implements Unserializer {
    public static final ZoneIdUnserializer instance = new ZoneIdUnserializer();

    ZoneIdUnserializer() {
    }

    static final ZoneId readZoneId(Reader reader, ByteBuffer buffer) throws IOException {
        ZoneId tz = ZoneId.of(ValueReader.readString(buffer));
        reader.refer.set(tz);
        return tz;
    }

    static final ZoneId readZoneId(Reader reader, InputStream stream) throws IOException {
        ZoneId tz = ZoneId.of(ValueReader.readString(stream));
        reader.refer.set(tz);
        return tz;
    }

    private static ZoneId toZoneId(Object obj) throws IOException {
        if (obj instanceof ZoneId) {
            return (ZoneId)obj;
        }
        if (obj instanceof char[]) {
            return ZoneId.of(new String((char[])obj));
        }
        return ZoneId.of(obj.toString());
    }

    static final ZoneId read(Reader reader, ByteBuffer buffer) throws IOException {
        byte tag = buffer.get();
        switch (tag) {
            case 101: 
            case 110: {
                return null;
            }
            case 115: {
                return ZoneIdUnserializer.readZoneId(reader, buffer);
            }
            case 114: {
                return ZoneIdUnserializer.toZoneId(reader.readRef(buffer));
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), ZoneId.class);
    }

    static final ZoneId read(Reader reader, InputStream stream) throws IOException {
        int tag = stream.read();
        switch (tag) {
            case 101: 
            case 110: {
                return null;
            }
            case 115: {
                return ZoneIdUnserializer.readZoneId(reader, stream);
            }
            case 114: {
                return ZoneIdUnserializer.toZoneId(reader.readRef(stream));
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), ZoneId.class);
    }

    @Override
    public final Object read(Reader reader, ByteBuffer buffer, Class<?> cls, Type type) throws IOException {
        return ZoneIdUnserializer.read(reader, buffer);
    }

    @Override
    public final Object read(Reader reader, InputStream stream, Class<?> cls, Type type) throws IOException {
        return ZoneIdUnserializer.read(reader, stream);
    }
}

