/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.io.unserialize.Reader;
import hprose.io.unserialize.Unserializer;
import hprose.io.unserialize.ValueReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.time.ZoneOffset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ZoneOffsetUnserializer
implements Unserializer {
    public static final ZoneOffsetUnserializer instance = new ZoneOffsetUnserializer();

    ZoneOffsetUnserializer() {
    }

    static final ZoneOffset readZoneOffset(Reader reader, ByteBuffer buffer) throws IOException {
        ZoneOffset tz = ZoneOffset.of(ValueReader.readString(buffer));
        reader.refer.set(tz);
        return tz;
    }

    static final ZoneOffset readZoneOffset(Reader reader, InputStream stream) throws IOException {
        ZoneOffset tz = ZoneOffset.of(ValueReader.readString(stream));
        reader.refer.set(tz);
        return tz;
    }

    private static ZoneOffset toZoneOffset(Object obj) throws IOException {
        if (obj instanceof ZoneOffset) {
            return (ZoneOffset)obj;
        }
        if (obj instanceof char[]) {
            return ZoneOffset.of(new String((char[])obj));
        }
        return ZoneOffset.of(obj.toString());
    }

    static final ZoneOffset read(Reader reader, ByteBuffer buffer) throws IOException {
        byte tag = buffer.get();
        switch (tag) {
            case 101: 
            case 110: {
                return null;
            }
            case 115: {
                return ZoneOffsetUnserializer.readZoneOffset(reader, buffer);
            }
            case 114: {
                return ZoneOffsetUnserializer.toZoneOffset(reader.readRef(buffer));
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), ZoneOffset.class);
    }

    static final ZoneOffset read(Reader reader, InputStream stream) throws IOException {
        int tag = stream.read();
        switch (tag) {
            case 101: 
            case 110: {
                return null;
            }
            case 115: {
                return ZoneOffsetUnserializer.readZoneOffset(reader, stream);
            }
            case 114: {
                return ZoneOffsetUnserializer.toZoneOffset(reader.readRef(stream));
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), ZoneOffset.class);
    }

    @Override
    public final Object read(Reader reader, ByteBuffer buffer, Class<?> cls, Type type) throws IOException {
        return ZoneOffsetUnserializer.read(reader, buffer);
    }

    @Override
    public final Object read(Reader reader, InputStream stream, Class<?> cls, Type type) throws IOException {
        return ZoneOffsetUnserializer.read(reader, stream);
    }
}

