/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.io.unserialize.DefaultUnserializer;
import hprose.io.unserialize.Reader;
import hprose.io.unserialize.StringUnserializer;
import hprose.io.unserialize.Unserializer;
import hprose.io.unserialize.ValueReader;
import hprose.util.DateTime;
import hprose.util.TimeZoneUtil;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ZonedDateTimeUnserializer
implements Unserializer {
    public static final ZonedDateTimeUnserializer instance = new ZonedDateTimeUnserializer();

    ZonedDateTimeUnserializer() {
    }

    private static ZonedDateTime toZonedDateTime(DateTime dt) {
        return ZonedDateTime.of(dt.year, dt.month, dt.day, dt.hour, dt.minute, dt.second, dt.nanosecond, dt.utc ? ZoneOffset.UTC : ZoneOffset.of(TimeZoneUtil.DefaultTZ.getID()));
    }

    private static ZonedDateTime toZonedDateTime(Object obj) {
        if (obj instanceof DateTime) {
            return ZonedDateTimeUnserializer.toZonedDateTime((DateTime)obj);
        }
        if (obj instanceof char[]) {
            return ZonedDateTime.parse(new String((char[])obj));
        }
        return ZonedDateTime.parse(obj.toString());
    }

    static final ZonedDateTime read(Reader reader, ByteBuffer buffer) throws IOException {
        byte tag = buffer.get();
        switch (tag) {
            case 68: {
                return ZonedDateTimeUnserializer.toZonedDateTime(DefaultUnserializer.readDateTime(reader, buffer));
            }
            case 84: {
                return ZonedDateTimeUnserializer.toZonedDateTime(DefaultUnserializer.readTime(reader, buffer));
            }
            case 101: 
            case 110: {
                return null;
            }
            case 114: {
                return ZonedDateTimeUnserializer.toZonedDateTime(reader.readRef(buffer));
            }
            case 115: {
                return ZonedDateTime.parse(StringUnserializer.readString(reader, buffer));
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), ZonedDateTime.class);
    }

    static final ZonedDateTime read(Reader reader, InputStream stream) throws IOException {
        int tag = stream.read();
        switch (tag) {
            case 68: {
                return ZonedDateTimeUnserializer.toZonedDateTime(DefaultUnserializer.readDateTime(reader, stream));
            }
            case 84: {
                return ZonedDateTimeUnserializer.toZonedDateTime(DefaultUnserializer.readTime(reader, stream));
            }
            case 101: 
            case 110: {
                return null;
            }
            case 114: {
                return ZonedDateTimeUnserializer.toZonedDateTime(reader.readRef(stream));
            }
            case 115: {
                return ZonedDateTime.parse(StringUnserializer.readString(reader, stream));
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), ZonedDateTime.class);
    }

    @Override
    public final Object read(Reader reader, ByteBuffer buffer, Class<?> cls, Type type) throws IOException {
        return ZonedDateTimeUnserializer.read(reader, buffer);
    }

    @Override
    public final Object read(Reader reader, InputStream stream, Class<?> cls, Type type) throws IOException {
        return ZonedDateTimeUnserializer.read(reader, stream);
    }
}

