/*
 * Decompiled with CFR 0.152.
 */
package hprose.net;

import hprose.net.Connection;
import hprose.net.ConnectionHandler;
import hprose.net.ReactorGroup;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

public final class Connector
extends Thread {
    protected final AtomicInteger size = new AtomicInteger(0);
    private final Selector selector;
    private final ReactorGroup reactor;
    private final Queue<Connection> queue = new ConcurrentLinkedQueue<Connection>();

    public Connector(int reactorThreads) throws IOException {
        this.selector = Selector.open();
        this.reactor = new ReactorGroup(reactorThreads);
    }

    public final void run() {
        this.reactor.start();
        while (!this.isInterrupted()) {
            try {
                this.process();
                this.dispatch();
            }
            catch (IOException e) {
            }
            catch (ClosedSelectorException e) {
                // empty catch block
                break;
            }
        }
        this.reactor.close();
    }

    public final void close() {
        try {
            this.selector.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void process() {
        Connection conn;
        while ((conn = this.queue.poll()) != null) {
            try {
                conn.connect(this.selector);
            }
            catch (ClosedChannelException closedChannelException) {}
        }
    }

    private void dispatch() throws IOException {
        int n = this.selector.select();
        if (n == 0) {
            return;
        }
        Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
        while (it.hasNext()) {
            SelectionKey key = it.next();
            it.remove();
            if (!key.isConnectable()) continue;
            this.connect(key);
        }
    }

    private void connect(SelectionKey key) throws IOException {
        SocketChannel channel = (SocketChannel)key.channel();
        if (channel.isConnectionPending()) {
            channel.finishConnect();
        }
        this.reactor.register((Connection)key.attachment());
    }

    private void register(Connection conn) {
        this.queue.offer(conn);
        this.selector.wakeup();
    }

    public final void create(String uri, ConnectionHandler handler, boolean keepAlive, boolean noDelay) throws IOException {
        try {
            URI u = new URI(uri);
            SocketChannel channel = SocketChannel.open();
            Connection conn = new Connection(channel, handler);
            channel.configureBlocking(false);
            channel.socket().setReuseAddress(true);
            channel.socket().setKeepAlive(keepAlive);
            channel.socket().setTcpNoDelay(noDelay);
            channel.connect(new InetSocketAddress(u.getHost(), u.getPort()));
            this.register(conn);
        }
        catch (URISyntaxException e) {
            throw new IOException(e.getMessage());
        }
    }
}

