/*
 * Decompiled with CFR 0.152.
 */
package hprose.net;

import hprose.net.Connection;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;

public final class Reactor
extends Thread {
    private final Selector selector;
    private final Queue<Connection> queue = new ConcurrentLinkedQueue<Connection>();

    public Reactor() throws IOException {
        this.selector = Selector.open();
    }

    public void run() {
        while (!this.isInterrupted()) {
            try {
                this.process();
                this.dispatch();
            }
            catch (IOException e) {
            }
            catch (ClosedSelectorException e) {
                break;
            }
        }
    }

    public void close() {
        try {
            Set<SelectionKey> keys = this.selector.keys();
            for (SelectionKey key : keys.toArray(new SelectionKey[0])) {
                Connection conn = (Connection)key.attachment();
                conn.close();
            }
            this.selector.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void process() {
        Connection conn;
        while ((conn = this.queue.poll()) != null) {
            try {
                conn.connected(this.selector);
            }
            catch (ClosedChannelException closedChannelException) {}
        }
    }

    private void dispatch() throws IOException {
        int n = this.selector.select();
        if (n == 0) {
            return;
        }
        Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
        while (it.hasNext()) {
            SelectionKey key = it.next();
            Connection conn = (Connection)key.attachment();
            it.remove();
            try {
                int readyOps = key.readyOps();
                if (((readyOps & 1) != 0 || readyOps == 0) && !conn.receive() || (readyOps & 4) == 0) continue;
                conn.send();
            }
            catch (CancelledKeyException e) {
                conn.close();
            }
        }
    }

    public void register(Connection conn) {
        this.queue.offer(conn);
        this.selector.wakeup();
    }
}

