/*
 * Decompiled with CFR 0.152.
 */
package hprose.server;

import hprose.common.HproseContext;
import hprose.common.HproseMethods;
import hprose.io.ByteBufferStream;
import hprose.server.HproseHttpMethods;
import hprose.server.HproseHttpServiceEvent;
import hprose.server.HproseService;
import hprose.server.HttpContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.HashMap;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class HproseHttpService
extends HproseService {
    private boolean crossDomainEnabled = false;
    private boolean p3pEnabled = false;
    private boolean getEnabled = true;
    private long timeout = 30000L;
    private final HashMap<String, Boolean> origins = new HashMap();
    private static final ThreadLocal<HttpContext> currentContext = new ThreadLocal();

    public static HttpContext getCurrentContext() {
        return currentContext.get();
    }

    public HproseMethods getGlobalMethods() {
        if (this.globalMethods == null) {
            this.globalMethods = new HproseHttpMethods();
        }
        return this.globalMethods;
    }

    public void setGlobalMethods(HproseMethods methods) {
        if (!(methods instanceof HproseHttpMethods)) {
            throw new ClassCastException("methods must be a HproseHttpMethods instance");
        }
        this.globalMethods = methods;
    }

    public boolean isCrossDomainEnabled() {
        return this.crossDomainEnabled;
    }

    public void setCrossDomainEnabled(boolean enabled) {
        this.crossDomainEnabled = enabled;
    }

    public boolean isP3pEnabled() {
        return this.p3pEnabled;
    }

    public void setP3pEnabled(boolean enabled) {
        this.p3pEnabled = enabled;
    }

    public boolean isGetEnabled() {
        return this.getEnabled;
    }

    public void setGetEnabled(boolean enabled) {
        this.getEnabled = enabled;
    }

    public void addAccessControlAllowOrigin(String origin) {
        this.origins.put(origin, true);
    }

    public void removeAccessControlAllowOrigin(String origin) {
        this.origins.remove(origin);
    }

    public void setTimeout(long value) {
        this.timeout = value;
    }

    public long getTimeout() {
        return this.timeout;
    }

    protected Object[] fixArguments(Type[] argumentTypes, Object[] arguments, HproseContext context) {
        int count = arguments.length;
        HttpContext httpContext = (HttpContext)context;
        if (argumentTypes.length != count) {
            Object[] args = new Object[argumentTypes.length];
            System.arraycopy(arguments, 0, args, 0, count);
            Class argType = (Class)argumentTypes[count];
            if (argType.equals(HproseContext.class)) {
                args[count] = context;
            } else if (argType.equals(HttpContext.class)) {
                args[count] = httpContext;
            } else if (argType.equals(HttpServletRequest.class)) {
                args[count] = httpContext.getRequest();
            } else if (argType.equals(HttpServletResponse.class)) {
                args[count] = httpContext.getResponse();
            } else if (argType.equals(HttpSession.class)) {
                args[count] = httpContext.getSession();
            } else if (argType.equals(ServletContext.class)) {
                args[count] = httpContext.getApplication();
            } else if (argType.equals(ServletConfig.class)) {
                args[count] = httpContext.getConfig();
            }
            return args;
        }
        return arguments;
    }

    protected void sendHeader(HttpContext httpContext) throws IOException {
        if (this.event != null && HproseHttpServiceEvent.class.isInstance(this.event)) {
            ((HproseHttpServiceEvent)this.event).onSendHeader(httpContext);
        }
        HttpServletRequest request = httpContext.getRequest();
        HttpServletResponse response = httpContext.getResponse();
        response.setContentType("text/plain");
        if (this.p3pEnabled) {
            response.setHeader("P3P", "CP=\"CAO DSP COR CUR ADM DEV TAI PSA PSD IVAi IVDi CONi TELo OTPi OUR DELi SAMi OTRi UNRi PUBi IND PHY ONL UNI PUR FIN COM NAV INT DEM CNT STA POL HEA PRE GOV\"");
        }
        if (this.crossDomainEnabled) {
            String origin = request.getHeader("Origin");
            if (origin != null && !origin.equals("null")) {
                if (this.origins.isEmpty() || this.origins.containsKey(origin)) {
                    response.setHeader("Access-Control-Allow-Origin", origin);
                    response.setHeader("Access-Control-Allow-Credentials", "true");
                }
            } else {
                response.setHeader("Access-Control-Allow-Origin", "*");
            }
        }
    }

    public void handle(HttpContext httpContext) throws IOException {
        this.handle(httpContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(HttpContext httpContext, HproseHttpMethods methods) throws IOException {
        this.sendHeader(httpContext);
        String method = httpContext.getRequest().getMethod();
        if (method.equals("GET")) {
            if (this.getEnabled) {
                ByteBufferStream ostream = null;
                try {
                    ostream = this.doFunctionList(methods, httpContext);
                    httpContext.getResponse().setContentLength(ostream.available());
                    ostream.writeTo((OutputStream)httpContext.getResponse().getOutputStream());
                }
                catch (IOException ex) {
                    this.fireErrorEvent(ex, httpContext);
                }
                finally {
                    if (ostream != null) {
                        ostream.close();
                    }
                }
            } else {
                httpContext.getResponse().sendError(403);
            }
        } else if (method.equals("POST")) {
            if (httpContext.getRequest().isAsyncSupported()) {
                this.asyncHandle(httpContext, methods);
            } else {
                this.syncHandle(httpContext, methods);
            }
        }
    }

    private void asyncHandle(final HttpContext httpContext, final HproseHttpMethods methods) {
        final AsyncContext async = httpContext.getRequest().startAsync();
        async.setTimeout(this.timeout);
        async.addListener(new AsyncListener(){

            public void onComplete(AsyncEvent ae) throws IOException {
            }

            public void onTimeout(AsyncEvent ae) throws IOException {
                ByteBufferStream ostream = HproseHttpService.this.sendError(ae.getThrowable(), httpContext);
                ae.getSuppliedResponse().setContentLength(ostream.available());
                ostream.writeTo((OutputStream)ae.getSuppliedResponse().getOutputStream());
            }

            public void onError(AsyncEvent ae) throws IOException {
            }

            public void onStartAsync(AsyncEvent ae) throws IOException {
            }
        });
        async.start(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ByteBufferStream istream = null;
                ByteBufferStream ostream = null;
                try {
                    currentContext.set(httpContext);
                    istream = new ByteBufferStream();
                    istream.readFrom((InputStream)async.getRequest().getInputStream());
                    ostream = HproseHttpService.this.handle(istream, methods, httpContext);
                    async.getResponse().setContentLength(ostream.available());
                    ostream.writeTo((OutputStream)async.getResponse().getOutputStream());
                }
                catch (IOException ex) {
                    HproseHttpService.this.fireErrorEvent(ex, httpContext);
                }
                finally {
                    currentContext.remove();
                    if (istream != null) {
                        istream.close();
                    }
                    if (ostream != null) {
                        ostream.close();
                    }
                    async.complete();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncHandle(HttpContext httpContext, HproseHttpMethods methods) throws IOException {
        ByteBufferStream istream = null;
        ByteBufferStream ostream = null;
        try {
            currentContext.set(httpContext);
            istream = new ByteBufferStream();
            istream.readFrom((InputStream)httpContext.getRequest().getInputStream());
            ostream = this.handle(istream, methods, httpContext);
            httpContext.getResponse().setContentLength(ostream.available());
            ostream.writeTo((OutputStream)httpContext.getResponse().getOutputStream());
        }
        catch (IOException ex) {
            this.fireErrorEvent(ex, httpContext);
        }
        finally {
            currentContext.remove();
            if (istream != null) {
                istream.close();
            }
            if (ostream != null) {
                ostream.close();
            }
        }
    }
}

