/*
 * Decompiled with CFR 0.152.
 */
package hprose.server;

import hprose.common.HproseContext;
import hprose.common.HproseException;
import hprose.common.HproseFilter;
import hprose.common.HproseMethod;
import hprose.common.HproseMethods;
import hprose.common.HproseResultMode;
import hprose.io.ByteBufferStream;
import hprose.io.HproseMode;
import hprose.io.serialize.Writer;
import hprose.io.unserialize.Reader;
import hprose.server.HproseServiceEvent;
import hprose.util.StrUtil;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HproseService {
    private final ArrayList<HproseFilter> filters = new ArrayList();
    private HproseMode mode = HproseMode.MemberMode;
    private boolean debugEnabled = false;
    protected HproseServiceEvent event = null;
    protected HproseMethods globalMethods = null;
    private static final ThreadLocal<HproseContext> currentContext = new ThreadLocal();

    public static HproseContext getCurrentContext() {
        return currentContext.get();
    }

    public HproseMethods getGlobalMethods() {
        if (this.globalMethods == null) {
            this.globalMethods = new HproseMethods();
        }
        return this.globalMethods;
    }

    public void setGlobalMethods(HproseMethods methods) {
        this.globalMethods = methods;
    }

    public HproseMode getMode() {
        return this.mode;
    }

    public void setMode(HproseMode mode) {
        this.mode = mode;
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public void setDebugEnabled(boolean enabled) {
        this.debugEnabled = enabled;
    }

    public HproseServiceEvent getEvent() {
        return this.event;
    }

    public void setEvent(HproseServiceEvent event) {
        this.event = event;
    }

    public HproseFilter getFilter() {
        if (this.filters.isEmpty()) {
            return null;
        }
        return this.filters.get(0);
    }

    public void setFilter(HproseFilter filter) {
        if (!this.filters.isEmpty()) {
            this.filters.clear();
        }
        if (filter != null) {
            this.filters.add(filter);
        }
    }

    public void addFilter(HproseFilter filter) {
        this.filters.add(filter);
    }

    public boolean removeFilter(HproseFilter filter) {
        return this.filters.remove(filter);
    }

    public void add(Method method, Object obj, String aliasName) {
        this.getGlobalMethods().addMethod(method, obj, aliasName);
    }

    public void add(Method method, Object obj, String aliasName, HproseResultMode mode) {
        this.getGlobalMethods().addMethod(method, obj, aliasName, mode);
    }

    public void add(Method method, Object obj, String aliasName, boolean simple) {
        this.getGlobalMethods().addMethod(method, obj, aliasName, simple);
    }

    public void add(Method method, Object obj, String aliasName, HproseResultMode mode, boolean simple) {
        this.getGlobalMethods().addMethod(method, obj, aliasName, mode, simple);
    }

    public void add(String methodName, Object obj, Class<?>[] paramTypes, String aliasName) throws NoSuchMethodException {
        this.getGlobalMethods().addMethod(methodName, obj, paramTypes, aliasName);
    }

    public void add(String methodName, Object obj, Class<?>[] paramTypes, String aliasName, HproseResultMode mode) throws NoSuchMethodException {
        this.getGlobalMethods().addMethod(methodName, obj, paramTypes, aliasName, mode);
    }

    public void add(String methodName, Object obj, Class<?>[] paramTypes, String aliasName, boolean simple) throws NoSuchMethodException {
        this.getGlobalMethods().addMethod(methodName, obj, paramTypes, aliasName, simple);
    }

    public void add(String methodName, Object obj, Class<?>[] paramTypes, String aliasName, HproseResultMode mode, boolean simple) throws NoSuchMethodException {
        this.getGlobalMethods().addMethod(methodName, obj, paramTypes, aliasName, mode, simple);
    }

    public void add(String methodName, Class<?> type, Class<?>[] paramTypes, String aliasName) throws NoSuchMethodException {
        this.getGlobalMethods().addMethod(methodName, type, paramTypes, aliasName);
    }

    public void add(String methodName, Class<?> type, Class<?>[] paramTypes, String aliasName, HproseResultMode mode) throws NoSuchMethodException {
        this.getGlobalMethods().addMethod(methodName, type, paramTypes, aliasName, mode);
    }

    public void add(String methodName, Class<?> type, Class<?>[] paramTypes, String aliasName, boolean simple) throws NoSuchMethodException {
        this.getGlobalMethods().addMethod(methodName, type, paramTypes, aliasName, simple);
    }

    public void add(String methodName, Class<?> type, Class<?>[] paramTypes, String aliasName, HproseResultMode mode, boolean simple) throws NoSuchMethodException {
        this.getGlobalMethods().addMethod(methodName, type, paramTypes, aliasName, mode, simple);
    }

    public void add(String methodName, Object obj, Class<?>[] paramTypes) throws NoSuchMethodException {
        this.getGlobalMethods().addMethod(methodName, obj, paramTypes);
    }

    public void add(String methodName, Object obj, Class<?>[] paramTypes, HproseResultMode mode) throws NoSuchMethodException {
        this.getGlobalMethods().addMethod(methodName, obj, paramTypes, mode);
    }

    public void add(String methodName, Object obj, Class<?>[] paramTypes, boolean simple) throws NoSuchMethodException {
        this.getGlobalMethods().addMethod(methodName, obj, paramTypes, simple);
    }

    public void add(String methodName, Object obj, Class<?>[] paramTypes, HproseResultMode mode, boolean simple) throws NoSuchMethodException {
        this.getGlobalMethods().addMethod(methodName, obj, paramTypes, mode, simple);
    }

    public void add(String methodName, Class<?> type, Class<?>[] paramTypes) throws NoSuchMethodException {
        this.getGlobalMethods().addMethod(methodName, type, paramTypes);
    }

    public void add(String methodName, Class<?> type, Class<?>[] paramTypes, HproseResultMode mode) throws NoSuchMethodException {
        this.getGlobalMethods().addMethod(methodName, type, paramTypes, mode);
    }

    public void add(String methodName, Class<?> type, Class<?>[] paramTypes, boolean simple) throws NoSuchMethodException {
        this.getGlobalMethods().addMethod(methodName, type, paramTypes, simple);
    }

    public void add(String methodName, Class<?> type, Class<?>[] paramTypes, HproseResultMode mode, boolean simple) throws NoSuchMethodException {
        this.getGlobalMethods().addMethod(methodName, type, paramTypes, mode, simple);
    }

    public void add(String methodName, Object obj, String aliasName) {
        this.getGlobalMethods().addMethod(methodName, obj, aliasName);
    }

    public void add(String methodName, Object obj, String aliasName, HproseResultMode mode) {
        this.getGlobalMethods().addMethod(methodName, obj, aliasName, mode);
    }

    public void add(String methodName, Object obj, String aliasName, boolean simple) {
        this.getGlobalMethods().addMethod(methodName, obj, aliasName, simple);
    }

    public void add(String methodName, Object obj, String aliasName, HproseResultMode mode, boolean simple) {
        this.getGlobalMethods().addMethod(methodName, obj, aliasName, mode, simple);
    }

    public void add(String methodName, Class<?> type, String aliasName) {
        this.getGlobalMethods().addMethod(methodName, type, aliasName);
    }

    public void add(String methodName, Class<?> type, String aliasName, HproseResultMode mode) {
        this.getGlobalMethods().addMethod(methodName, type, aliasName, mode);
    }

    public void add(String methodName, Class<?> type, String aliasName, boolean simple) {
        this.getGlobalMethods().addMethod(methodName, type, aliasName, simple);
    }

    public void add(String methodName, Class<?> type, String aliasName, HproseResultMode mode, boolean simple) {
        this.getGlobalMethods().addMethod(methodName, type, aliasName, mode, simple);
    }

    public void add(String methodName, Object obj) {
        this.getGlobalMethods().addMethod(methodName, obj);
    }

    public void add(String methodName, Object obj, HproseResultMode mode) {
        this.getGlobalMethods().addMethod(methodName, obj, mode);
    }

    public void add(String methodName, Object obj, boolean simple) {
        this.getGlobalMethods().addMethod(methodName, obj, simple);
    }

    public void add(String methodName, Object obj, HproseResultMode mode, boolean simple) {
        this.getGlobalMethods().addMethod(methodName, obj, mode, simple);
    }

    public void add(String methodName, Class<?> type) {
        this.getGlobalMethods().addMethod(methodName, type);
    }

    public void add(String methodName, Class<?> type, HproseResultMode mode) {
        this.getGlobalMethods().addMethod(methodName, type, mode);
    }

    public void add(String methodName, Class<?> type, boolean simple) {
        this.getGlobalMethods().addMethod(methodName, type, simple);
    }

    public void add(String methodName, Class<?> type, HproseResultMode mode, boolean simple) {
        this.getGlobalMethods().addMethod(methodName, type, mode, simple);
    }

    public void add(String[] methodNames, Object obj, String[] aliasNames) {
        this.getGlobalMethods().addMethods(methodNames, obj, aliasNames);
    }

    public void add(String[] methodNames, Object obj, String[] aliasNames, HproseResultMode mode) {
        this.getGlobalMethods().addMethods(methodNames, obj, aliasNames, mode);
    }

    public void add(String[] methodNames, Object obj, String[] aliasNames, boolean simple) {
        this.getGlobalMethods().addMethods(methodNames, obj, aliasNames, simple);
    }

    public void add(String[] methodNames, Object obj, String[] aliasNames, HproseResultMode mode, boolean simple) {
        this.getGlobalMethods().addMethods(methodNames, obj, aliasNames, mode, simple);
    }

    public void add(String[] methodNames, Object obj, String aliasPrefix) {
        this.getGlobalMethods().addMethods(methodNames, obj, aliasPrefix);
    }

    public void add(String[] methodNames, Object obj, String aliasPrefix, HproseResultMode mode) {
        this.getGlobalMethods().addMethods(methodNames, obj, aliasPrefix, mode);
    }

    public void add(String[] methodNames, Object obj, String aliasPrefix, boolean simple) {
        this.getGlobalMethods().addMethods(methodNames, obj, aliasPrefix, simple);
    }

    public void add(String[] methodNames, Object obj, String aliasPrefix, HproseResultMode mode, boolean simple) {
        this.getGlobalMethods().addMethods(methodNames, obj, aliasPrefix, mode, simple);
    }

    public void add(String[] methodNames, Object obj) {
        this.getGlobalMethods().addMethods(methodNames, obj);
    }

    public void add(String[] methodNames, Object obj, HproseResultMode mode) {
        this.getGlobalMethods().addMethods(methodNames, obj, mode);
    }

    public void add(String[] methodNames, Object obj, boolean simple) {
        this.getGlobalMethods().addMethods(methodNames, obj, simple);
    }

    public void add(String[] methodNames, Object obj, HproseResultMode mode, boolean simple) {
        this.getGlobalMethods().addMethods(methodNames, obj, mode, simple);
    }

    public void add(String[] methodNames, Class<?> type, String[] aliasNames) {
        this.getGlobalMethods().addMethods(methodNames, type, aliasNames);
    }

    public void add(String[] methodNames, Class<?> type, String[] aliasNames, HproseResultMode mode) {
        this.getGlobalMethods().addMethods(methodNames, type, aliasNames, mode);
    }

    public void add(String[] methodNames, Class<?> type, String[] aliasNames, boolean simple) {
        this.getGlobalMethods().addMethods(methodNames, type, aliasNames, simple);
    }

    public void add(String[] methodNames, Class<?> type, String[] aliasNames, HproseResultMode mode, boolean simple) {
        this.getGlobalMethods().addMethods(methodNames, type, aliasNames, mode, simple);
    }

    public void add(String[] methodNames, Class<?> type, String aliasPrefix) {
        this.getGlobalMethods().addMethods(methodNames, type, aliasPrefix);
    }

    public void add(String[] methodNames, Class<?> type, String aliasPrefix, HproseResultMode mode) {
        this.getGlobalMethods().addMethods(methodNames, type, aliasPrefix, mode);
    }

    public void add(String[] methodNames, Class<?> type, String aliasPrefix, boolean simple) {
        this.getGlobalMethods().addMethods(methodNames, type, aliasPrefix, simple);
    }

    public void add(String[] methodNames, Class<?> type, String aliasPrefix, HproseResultMode mode, boolean simple) {
        this.getGlobalMethods().addMethods(methodNames, type, aliasPrefix, mode, simple);
    }

    public void add(String[] methodNames, Class<?> type) {
        this.getGlobalMethods().addMethods(methodNames, type);
    }

    public void add(String[] methodNames, Class<?> type, HproseResultMode mode) {
        this.getGlobalMethods().addMethods(methodNames, type, mode);
    }

    public void add(String[] methodNames, Class<?> type, boolean simple) {
        this.getGlobalMethods().addMethods(methodNames, type, simple);
    }

    public void add(String[] methodNames, Class<?> type, HproseResultMode mode, boolean simple) {
        this.getGlobalMethods().addMethods(methodNames, type, mode, simple);
    }

    public void add(Object obj, Class<?> type, String aliasPrefix) {
        this.getGlobalMethods().addInstanceMethods(obj, type, aliasPrefix);
    }

    public void add(Object obj, Class<?> type, String aliasPrefix, HproseResultMode mode) {
        this.getGlobalMethods().addInstanceMethods(obj, type, aliasPrefix, mode);
    }

    public void add(Object obj, Class<?> type, String aliasPrefix, boolean simple) {
        this.getGlobalMethods().addInstanceMethods(obj, type, aliasPrefix, simple);
    }

    public void add(Object obj, Class<?> type, String aliasPrefix, HproseResultMode mode, boolean simple) {
        this.getGlobalMethods().addInstanceMethods(obj, type, aliasPrefix, mode, simple);
    }

    public void add(Object obj, Class<?> type) {
        this.getGlobalMethods().addInstanceMethods(obj, type);
    }

    public void add(Object obj, Class<?> type, HproseResultMode mode) {
        this.getGlobalMethods().addInstanceMethods(obj, type, mode);
    }

    public void add(Object obj, Class<?> type, boolean simple) {
        this.getGlobalMethods().addInstanceMethods(obj, type, simple);
    }

    public void add(Object obj, Class<?> type, HproseResultMode mode, boolean simple) {
        this.getGlobalMethods().addInstanceMethods(obj, type, mode, simple);
    }

    public void add(Object obj, String aliasPrefix) {
        this.getGlobalMethods().addInstanceMethods(obj, aliasPrefix);
    }

    public void add(Object obj, String aliasPrefix, HproseResultMode mode) {
        this.getGlobalMethods().addInstanceMethods(obj, aliasPrefix, mode);
    }

    public void add(Object obj, String aliasPrefix, boolean simple) {
        this.getGlobalMethods().addInstanceMethods(obj, aliasPrefix, simple);
    }

    public void add(Object obj, String aliasPrefix, HproseResultMode mode, boolean simple) {
        this.getGlobalMethods().addInstanceMethods(obj, aliasPrefix, mode, simple);
    }

    public void add(Object obj) {
        this.getGlobalMethods().addInstanceMethods(obj);
    }

    public void add(Object obj, HproseResultMode mode) {
        this.getGlobalMethods().addInstanceMethods(obj, mode);
    }

    public void add(Object obj, boolean simple) {
        this.getGlobalMethods().addInstanceMethods(obj, simple);
    }

    public void add(Object obj, HproseResultMode mode, boolean simple) {
        this.getGlobalMethods().addInstanceMethods(obj, mode, simple);
    }

    public void add(Class<?> type, String aliasPrefix) {
        this.getGlobalMethods().addStaticMethods(type, aliasPrefix);
    }

    public void add(Class<?> type, String aliasPrefix, HproseResultMode mode) {
        this.getGlobalMethods().addStaticMethods(type, aliasPrefix, mode);
    }

    public void add(Class<?> type, String aliasPrefix, boolean simple) {
        this.getGlobalMethods().addStaticMethods(type, aliasPrefix, simple);
    }

    public void add(Class<?> type, String aliasPrefix, HproseResultMode mode, boolean simple) {
        this.getGlobalMethods().addStaticMethods(type, aliasPrefix, mode, simple);
    }

    public void add(Class<?> type) {
        this.getGlobalMethods().addStaticMethods(type);
    }

    public void add(Class<?> type, HproseResultMode mode) {
        this.getGlobalMethods().addStaticMethods(type, mode);
    }

    public void add(Class<?> type, boolean simple) {
        this.getGlobalMethods().addStaticMethods(type, simple);
    }

    public void add(Class<?> type, HproseResultMode mode, boolean simple) {
        this.getGlobalMethods().addStaticMethods(type, mode, simple);
    }

    public void addMissingMethod(String methodName, Object obj) throws NoSuchMethodException {
        this.getGlobalMethods().addMissingMethod(methodName, obj);
    }

    public void addMissingMethod(String methodName, Object obj, HproseResultMode mode) throws NoSuchMethodException {
        this.getGlobalMethods().addMissingMethod(methodName, obj, mode);
    }

    public void addMissingMethod(String methodName, Object obj, boolean simple) throws NoSuchMethodException {
        this.getGlobalMethods().addMissingMethod(methodName, obj, simple);
    }

    public void addMissingMethod(String methodName, Object obj, HproseResultMode mode, boolean simple) throws NoSuchMethodException {
        this.getGlobalMethods().addMissingMethod(methodName, obj, mode, simple);
    }

    public void addMissingMethod(String methodName, Class<?> type) throws NoSuchMethodException {
        this.getGlobalMethods().addMissingMethod(methodName, type);
    }

    public void addMissingMethod(String methodName, Class<?> type, HproseResultMode mode) throws NoSuchMethodException {
        this.getGlobalMethods().addMissingMethod(methodName, type, mode);
    }

    public void addMissingMethod(String methodName, Class<?> type, boolean simple) throws NoSuchMethodException {
        this.getGlobalMethods().addMissingMethod(methodName, type, simple);
    }

    public void addMissingMethod(String methodName, Class<?> type, HproseResultMode mode, boolean simple) throws NoSuchMethodException {
        this.getGlobalMethods().addMissingMethod(methodName, type, mode, simple);
    }

    private ByteBufferStream responseEnd(ByteBufferStream data, HproseContext context) {
        data.flip();
        int n = this.filters.size();
        for (int i = 0; i < n; ++i) {
            data.buffer = this.filters.get(i).outputFilter(data.buffer, context);
            data.flip();
        }
        return data;
    }

    protected Object[] fixArguments(Type[] argumentTypes, Object[] arguments, HproseContext context) {
        int count = arguments.length;
        if (argumentTypes.length != count) {
            Object[] args = new Object[argumentTypes.length];
            System.arraycopy(arguments, 0, args, 0, count);
            Class argType = (Class)argumentTypes[count];
            if (argType.equals(HproseContext.class)) {
                args[count] = context;
            }
            return args;
        }
        return arguments;
    }

    private String getErrorMessage(Throwable e) {
        if (this.debugEnabled) {
            StackTraceElement[] st = e.getStackTrace();
            StringBuffer es = new StringBuffer(e.toString()).append("\r\n");
            int n = st.length;
            for (int i = 0; i < n; ++i) {
                es.append(st[i].toString()).append("\r\n");
            }
            return es.toString();
        }
        return e.toString();
    }

    protected ByteBufferStream sendError(Throwable e, HproseContext context) throws IOException {
        if (this.event != null) {
            this.event.onSendError(e, context);
        }
        ByteBufferStream data = new ByteBufferStream();
        Writer writer = new Writer(data.getOutputStream(), this.mode, true);
        data.write(69);
        writer.writeString(this.getErrorMessage(e));
        data.write(122);
        return this.responseEnd(data, context);
    }

    protected ByteBufferStream doInvoke(ByteBufferStream stream, HproseMethods methods, HproseContext context) throws Throwable {
        int tag;
        Reader reader = new Reader(stream.getInputStream(), this.mode);
        ByteBufferStream data = new ByteBufferStream();
        do {
            Throwable e;
            Object result;
            Object[] arguments;
            reader.reset();
            String name = reader.readString();
            String aliasname = name.toLowerCase();
            HproseMethod remoteMethod = null;
            boolean byRef = false;
            tag = reader.checkTags("azC");
            if (tag == 97) {
                reader.reset();
                int count = reader.readInt(123);
                if (methods != null) {
                    remoteMethod = methods.get(aliasname, count);
                }
                if (remoteMethod == null) {
                    remoteMethod = this.getGlobalMethods().get(aliasname, count);
                }
                if (remoteMethod == null) {
                    arguments = reader.readArray(count);
                } else {
                    arguments = new Object[count];
                    reader.readArray(remoteMethod.paramTypes, arguments, count);
                }
                tag = reader.checkTags("tzC");
                if (tag == 116) {
                    byRef = true;
                    tag = reader.checkTags("zC");
                }
            } else {
                if (methods != null) {
                    remoteMethod = methods.get(aliasname, 0);
                }
                if (remoteMethod == null) {
                    remoteMethod = this.getGlobalMethods().get(aliasname, 0);
                }
                arguments = new Object[]{};
            }
            if (this.event != null) {
                this.event.onBeforeInvoke(name, arguments, byRef, context);
            }
            Object[] args = remoteMethod == null ? arguments : this.fixArguments(remoteMethod.paramTypes, arguments, context);
            try {
                if (remoteMethod == null) {
                    if (methods != null) {
                        remoteMethod = methods.get("*", 2);
                    }
                    if (remoteMethod == null) {
                        remoteMethod = this.getGlobalMethods().get("*", 2);
                    }
                    if (remoteMethod == null) {
                        throw new NoSuchMethodError("Can't find this method " + name);
                    }
                    result = remoteMethod.method.invoke(remoteMethod.obj, name, args);
                } else {
                    result = remoteMethod.method.invoke(remoteMethod.obj, args);
                }
                if (result instanceof Future) {
                    result = ((Future)result).get();
                }
            }
            catch (ExceptionInInitializerError ex1) {
                e = ex1.getCause();
                if (e != null) {
                    throw e;
                }
                throw ex1;
            }
            catch (InvocationTargetException ex2) {
                e = ex2.getCause();
                if (e != null) {
                    throw e;
                }
                throw ex2;
            }
            if (byRef) {
                System.arraycopy(args, 0, arguments, 0, arguments.length);
            }
            if (this.event != null) {
                this.event.onAfterInvoke(name, arguments, byRef, result, context);
            }
            if (remoteMethod.mode == HproseResultMode.RawWithEndTag) {
                data.write((byte[])result);
                return this.responseEnd(data, context);
            }
            if (remoteMethod.mode == HproseResultMode.Raw) {
                data.write((byte[])result);
                continue;
            }
            data.write(82);
            boolean simple = remoteMethod.simple;
            Writer writer = new Writer(data.getOutputStream(), this.mode, simple);
            if (remoteMethod.mode == HproseResultMode.Serialized) {
                data.write((byte[])result);
            } else {
                writer.serialize(result);
            }
            if (!byRef) continue;
            data.write(65);
            writer.reset();
            writer.writeArray(arguments);
        } while (tag == 67);
        data.write(122);
        return this.responseEnd(data, context);
    }

    protected ByteBufferStream doFunctionList(HproseMethods methods, HproseContext context) throws IOException {
        ArrayList<String> names = new ArrayList<String>();
        names.addAll(this.getGlobalMethods().getAllNames());
        if (methods != null) {
            names.addAll(methods.getAllNames());
        }
        ByteBufferStream data = new ByteBufferStream();
        Writer writer = new Writer(data.getOutputStream(), this.mode, true);
        data.write(70);
        writer.writeList(names);
        data.write(122);
        return this.responseEnd(data, context);
    }

    protected void fireErrorEvent(Throwable e, HproseContext context) {
        if (this.event != null) {
            this.event.onSendError(e, context);
        }
    }

    protected ByteBufferStream handle(ByteBufferStream stream, HproseContext context) throws IOException {
        return this.handle(stream, null, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ByteBufferStream handle(ByteBufferStream stream, HproseMethods methods, HproseContext context) throws IOException {
        try {
            currentContext.set(context);
            stream.flip();
            for (int i = this.filters.size() - 1; i >= 0; --i) {
                stream.buffer = this.filters.get(i).inputFilter(stream.buffer, context);
                stream.flip();
            }
            int tag = stream.read();
            switch (tag) {
                case 67: {
                    ByteBufferStream byteBufferStream = this.doInvoke(stream, methods, context);
                    return byteBufferStream;
                }
                case 122: {
                    ByteBufferStream byteBufferStream = this.doFunctionList(methods, context);
                    return byteBufferStream;
                }
            }
            ByteBufferStream byteBufferStream = this.sendError(new HproseException("Wrong Request: \r\n" + StrUtil.toString(stream)), context);
            return byteBufferStream;
        }
        catch (Throwable e) {
            ByteBufferStream byteBufferStream = this.sendError(e, context);
            return byteBufferStream;
        }
        finally {
            currentContext.remove();
        }
    }
}

