/*
 * Decompiled with CFR 0.152.
 */
package hprose.server;

import hprose.common.HproseFilter;
import hprose.common.HproseMethods;
import hprose.io.HproseClassManager;
import hprose.io.HproseMode;
import hprose.server.HproseHttpService;
import hprose.server.HproseServiceEvent;
import hprose.server.HttpContext;
import hprose.util.StrUtil;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HproseServlet
extends HttpServlet {
    private static final long serialVersionUID = 1716958719284073368L;
    private final HproseHttpService service = new HproseHttpService();

    public void init(ServletConfig config) throws ServletException {
        Class<?> type;
        String[] name;
        int i;
        int n;
        String[] classNames;
        Class<?> type2;
        super.init(config);
        String param = config.getInitParameter("mode");
        if (param != null) {
            if ((param = param.toLowerCase()).equals("propertymode")) {
                this.service.setMode(HproseMode.PropertyMode);
            } else if (param.equals("fieldmode")) {
                this.service.setMode(HproseMode.FieldMode);
            } else if (param.equals("membermode")) {
                this.service.setMode(HproseMode.MemberMode);
            }
        }
        if ((param = config.getInitParameter("debug")) != null && (param = param.toLowerCase()).equals("true")) {
            this.service.setDebugEnabled(true);
        }
        if ((param = config.getInitParameter("crossDomain")) != null && (param = param.toLowerCase()).equals("true")) {
            this.service.setCrossDomainEnabled(true);
        }
        if ((param = config.getInitParameter("p3p")) != null && (param = param.toLowerCase()).equals("true")) {
            this.service.setP3pEnabled(true);
        }
        if ((param = config.getInitParameter("get")) != null && (param = param.toLowerCase()).equals("false")) {
            this.service.setGetEnabled(false);
        }
        if ((param = config.getInitParameter("event")) != null) {
            try {
                type2 = Class.forName(param);
                if (HproseServiceEvent.class.isAssignableFrom(type2)) {
                    this.service.setEvent((HproseServiceEvent)type2.newInstance());
                }
            }
            catch (Exception ex) {
                throw new ServletException((Throwable)ex);
            }
        }
        if ((param = config.getInitParameter("filter")) != null) {
            try {
                type2 = Class.forName(param);
                if (HproseFilter.class.isAssignableFrom(type2)) {
                    this.service.setFilter((HproseFilter)type2.newInstance());
                }
            }
            catch (Exception ex) {
                throw new ServletException((Throwable)ex);
            }
        }
        HproseMethods methods = this.service.getGlobalMethods();
        param = config.getInitParameter("class");
        if (param != null) {
            try {
                classNames = StrUtil.split(param, ',', 0);
                n = classNames.length;
                for (i = 0; i < n; ++i) {
                    Class<?> ancestorType;
                    name = StrUtil.split(classNames[i], '|', 3);
                    type = Class.forName(name[0]);
                    Object obj = type.newInstance();
                    if (name.length == 1) {
                        methods.addInstanceMethods(obj, type);
                        continue;
                    }
                    if (name.length == 2) {
                        ancestorType = Class.forName(name[1]);
                        while (ancestorType.isAssignableFrom(type)) {
                            methods.addInstanceMethods(obj, type);
                            type = type.getSuperclass();
                        }
                        continue;
                    }
                    if (name.length != 3) continue;
                    if (name[1].equals("")) {
                        methods.addInstanceMethods(obj, type, name[2]);
                        continue;
                    }
                    ancestorType = Class.forName(name[1]);
                    while (ancestorType.isAssignableFrom(type)) {
                        methods.addInstanceMethods(obj, type, name[2]);
                        type = type.getSuperclass();
                    }
                }
            }
            catch (Exception ex) {
                throw new ServletException((Throwable)ex);
            }
        }
        if ((param = config.getInitParameter("staticClass")) != null) {
            try {
                classNames = StrUtil.split(param, ',', 0);
                n = classNames.length;
                for (i = 0; i < n; ++i) {
                    name = StrUtil.split(classNames[i], '|', 2);
                    type = Class.forName(name[0]);
                    if (name.length == 1) {
                        methods.addStaticMethods(type);
                        continue;
                    }
                    methods.addStaticMethods(type, name[1]);
                }
            }
            catch (ClassNotFoundException ex) {
                throw new ServletException((Throwable)ex);
            }
        }
        if ((param = config.getInitParameter("type")) != null) {
            try {
                classNames = StrUtil.split(param, ',', 0);
                n = classNames.length;
                for (i = 0; i < n; ++i) {
                    name = StrUtil.split(classNames[i], '|', 2);
                    HproseClassManager.register(Class.forName(name[0]), name[1]);
                }
            }
            catch (ClassNotFoundException ex) {
                throw new ServletException((Throwable)ex);
            }
        }
        this.setGlobalMethods(methods);
    }

    protected void setGlobalMethods(HproseMethods methods) {
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.service.handle(new HttpContext(request, response, this.getServletConfig(), this.getServletContext()));
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doOptions(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Hprose Servlet 1.4";
    }
}

