/*
 * Decompiled with CFR 0.152.
 */
package hprose.server;

import hprose.common.HproseContext;
import hprose.common.HproseMethods;
import hprose.io.ByteBufferStream;
import hprose.net.Acceptor;
import hprose.net.Connection;
import hprose.net.ConnectionHandler;
import hprose.net.TimeoutType;
import hprose.server.HproseService;
import hprose.server.HproseTcpMethods;
import hprose.server.HproseTcpServiceEvent;
import hprose.server.TcpContext;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;

public class HproseTcpServer
extends HproseService {
    private static final ThreadLocal<TcpContext> currentContext = new ThreadLocal();
    private volatile ExecutorService threadPool = null;
    private volatile long readTimeout = 30000L;
    private volatile long writeTimeout = 30000L;
    private boolean enabledThreadPool = false;
    private int reactorThreads = Runtime.getRuntime().availableProcessors() + 1 >> 1;
    private Acceptor acceptor = null;
    private String host = null;
    private int port = 0;

    public HproseTcpServer(String uri) throws URISyntaxException {
        URI u = new URI(uri);
        this.host = u.getHost();
        this.port = u.getPort();
    }

    public HproseTcpServer(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String value) {
        this.host = value;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int value) {
        this.port = value;
    }

    public int getReactorThreads() {
        return this.reactorThreads;
    }

    public void setReactorThreads(int reactorThreads) {
        this.reactorThreads = reactorThreads;
    }

    public boolean isStarted() {
        return this.acceptor != null;
    }

    public void start() throws IOException {
        if (!this.isStarted()) {
            this.acceptor = new Acceptor(this.host, this.port, new ServerConnectionHandler(), this.reactorThreads);
            this.acceptor.start();
        }
    }

    public void stop() {
        if (this.isStarted()) {
            this.acceptor.close();
            if (this.threadPool != null && !this.threadPool.isShutdown()) {
                try {
                    this.threadPool.shutdown();
                }
                catch (SecurityException e) {
                    this.fireErrorEvent(e, null);
                }
            }
            this.acceptor = null;
        }
    }

    public HproseMethods getGlobalMethods() {
        if (this.globalMethods == null) {
            this.globalMethods = new HproseTcpMethods();
        }
        return this.globalMethods;
    }

    public void setGlobalMethods(HproseMethods methods) {
        if (!(methods instanceof HproseTcpMethods)) {
            throw new ClassCastException("methods must be a HproseTcpMethods instance");
        }
        this.globalMethods = methods;
    }

    protected Object[] fixArguments(Type[] argumentTypes, Object[] arguments, HproseContext context) {
        int count = arguments.length;
        TcpContext tcpContext = (TcpContext)context;
        if (argumentTypes.length != count) {
            Object[] args = new Object[argumentTypes.length];
            System.arraycopy(arguments, 0, args, 0, count);
            Class argType = (Class)argumentTypes[count];
            if (argType.equals(HproseContext.class)) {
                args[count] = context;
            } else if (argType.equals(TcpContext.class)) {
                args[count] = tcpContext;
            } else if (argType.equals(SocketChannel.class)) {
                args[count] = tcpContext.getSocketChannel();
            } else if (argType.equals(Socket.class)) {
                args[count] = tcpContext.getSocket();
            }
            return args;
        }
        return arguments;
    }

    public static TcpContext getCurrentContext() {
        return currentContext.get();
    }

    public boolean isEnabledThreadPool() {
        return this.enabledThreadPool;
    }

    public void setEnabledThreadPool(boolean value) {
        if (value && this.threadPool == null) {
            this.threadPool = Executors.newCachedThreadPool();
        }
        this.enabledThreadPool = value;
    }

    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(ExecutorService value) {
        this.threadPool = value;
        this.enabledThreadPool = value != null;
    }

    protected void fireAcceptEvent(SocketChannel channel) {
        if (this.event != null && HproseTcpServiceEvent.class.isInstance(this.event)) {
            ((HproseTcpServiceEvent)this.event).onAccept(new TcpContext(channel));
        }
    }

    protected void fireCloseEvent(SocketChannel channel) {
        if (this.event != null && HproseTcpServiceEvent.class.isInstance(this.event)) {
            ((HproseTcpServiceEvent)this.event).onClose(new TcpContext(channel));
        }
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(long readTimeout) {
        this.readTimeout = readTimeout;
    }

    public long getWriteTimeout() {
        return this.writeTimeout;
    }

    public void setWriteTimeout(long writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    private final class ServerConnectionHandler
    implements ConnectionHandler {
        private ServerConnectionHandler() {
        }

        public void onConnected(Connection conn) {
            HproseTcpServer.this.fireAcceptEvent(conn.socketChannel());
        }

        public final void onReceived(Connection conn, ByteBuffer data, Integer id) {
            ServerHandler handler = new ServerHandler(conn, data, id);
            if (HproseTcpServer.this.threadPool != null) {
                try {
                    HproseTcpServer.this.threadPool.execute(handler);
                }
                catch (RejectedExecutionException e) {
                    conn.close();
                }
            } else {
                handler.run();
            }
        }

        public final void onSended(Connection conn, Integer id) {
        }

        public final void onClose(Connection conn) {
            HproseTcpServer.this.fireCloseEvent(conn.socketChannel());
        }

        public void onError(Connection conn, Exception e) {
            if (conn == null) {
                HproseTcpServer.this.fireErrorEvent(e, null);
            }
        }

        public void onTimeout(Connection conn, TimeoutType type) {
        }

        public long getReadTimeout() {
            return HproseTcpServer.this.readTimeout;
        }

        public long getWriteTimeout() {
            return HproseTcpServer.this.writeTimeout;
        }

        public long getConnectTimeout() {
            throw new UnsupportedOperationException();
        }
    }

    private final class ServerHandler
    implements Runnable {
        private final Connection conn;
        private final ByteBuffer data;
        private final Integer id;

        public ServerHandler(Connection conn, ByteBuffer data, Integer id) {
            this.conn = conn;
            this.data = data;
            this.id = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run() {
            TcpContext context = new TcpContext(this.conn.socketChannel());
            ByteBufferStream istream = new ByteBufferStream(this.data);
            try {
                currentContext.set(context);
                this.conn.send(HproseTcpServer.this.handle((ByteBufferStream)istream, (HproseContext)context).buffer, this.id);
            }
            catch (Exception e) {
                this.conn.close();
            }
            finally {
                currentContext.remove();
                istream.close();
            }
        }
    }
}

