/*
 * Decompiled with CFR 0.152.
 */
package hprose.util.concurrent;

import hprose.util.JdkVersion;
import hprose.util.concurrent.Action;
import hprose.util.concurrent.Callback;
import hprose.util.concurrent.Executor;
import hprose.util.concurrent.Func;
import hprose.util.concurrent.Handler;
import hprose.util.concurrent.Reducer;
import hprose.util.concurrent.Rejector;
import hprose.util.concurrent.Resolver;
import hprose.util.concurrent.State;
import hprose.util.concurrent.Subscriber;
import hprose.util.concurrent.Thenable;
import hprose.util.concurrent.Threads;
import hprose.util.concurrent.TypeException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Promise<V>
implements Resolver,
Rejector,
Thenable<V> {
    private static final ScheduledExecutorService timer = Executors.newSingleThreadScheduledExecutor();
    private final ConcurrentLinkedQueue<Subscriber<V>> subscribers = new ConcurrentLinkedQueue();
    private volatile State state = State.PENDING;
    private volatile Object value;
    private volatile Throwable reason;

    public Promise() {
    }

    public Promise(final Callable<V> computation) {
        timer.execute(new Runnable(){

            public void run() {
                try {
                    Promise.this.resolve(computation.call());
                }
                catch (Throwable e) {
                    Promise.this.reject(e);
                }
            }
        });
    }

    public Promise(Executor executor) {
        executor.exec(this, this);
    }

    public static final Promise<?> value(Object value) {
        Promise promise = new Promise();
        promise.resolve(value);
        return promise;
    }

    public static final Promise<?> error(Throwable reason) {
        Promise promise = new Promise();
        promise.reject(reason);
        return promise;
    }

    public static final Promise<?> delayed(long duration, TimeUnit timeunit, final Object value) {
        final Promise promise = new Promise();
        timer.schedule(new Runnable(){

            public void run() {
                try {
                    if (value instanceof Callable) {
                        promise.resolve(((Callable)value).call());
                    } else {
                        promise.resolve(value);
                    }
                }
                catch (Throwable e) {
                    promise.reject(e);
                }
            }
        }, duration, timeunit);
        return promise;
    }

    public static final Promise<?> delayed(long duration, Object value) {
        return Promise.delayed(duration, TimeUnit.MILLISECONDS, value);
    }

    public static final Promise<?> sync(Callable<?> computation) {
        try {
            return Promise.value(computation.call());
        }
        catch (Throwable e) {
            return Promise.error(e);
        }
    }

    public static final boolean isThenable(Object value) {
        return value instanceof Thenable;
    }

    public static final boolean isPromise(Object value) {
        return value instanceof Promise;
    }

    public static final Promise<?> toPromise(Object value) {
        return Promise.isPromise(value) ? (Promise<?>)value : Promise.value(value);
    }

    private static void allHandler(final Promise<Object[]> promise, final AtomicInteger count, final Object[] result, Object element, final int i) {
        Promise.toPromise(element).then(new Action<Object>(){

            @Override
            public void call(Object value) throws Throwable {
                result[i] = value;
                if (count.decrementAndGet() == 0) {
                    promise.resolve(result);
                }
            }
        }, new Action<Throwable>(){

            @Override
            public void call(Throwable e) throws Throwable {
                promise.reject(e);
            }
        });
    }

    public static final Promise<Object[]> all(Object[] array) {
        int n = array.length;
        Object[] result = new Object[n];
        if (n == 0) {
            return Promise.value(result);
        }
        AtomicInteger count = new AtomicInteger(n);
        Promise<Object[]> promise = new Promise<Object[]>();
        for (int i = 0; i < n; ++i) {
            Promise.allHandler(promise, count, result, array[i], i);
        }
        return promise;
    }

    public static final Promise<Object[]> all(Promise<Object[]> promise) {
        return promise.then((Callback<Object[]>)new Func<Promise<Object[]>, Object[]>(){

            @Override
            public Promise<Object[]> call(Object[] array) throws Throwable {
                return Promise.all(array);
            }
        });
    }

    public final Promise<Object[]> all() {
        return Promise.all(this);
    }

    public static final Promise<Object[]> join(Object ... args) {
        return Promise.all(args);
    }

    public static final Promise<?> race(Object[] array) {
        Promise promise = new Promise();
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            Promise.toPromise(array[i]).fill(promise);
        }
        return promise;
    }

    public static final Promise<?> race(Promise<Object[]> promise) {
        return promise.then(new Func<Promise<?>, Object[]>(){

            @Override
            public Promise<?> call(Object[] array) throws Throwable {
                return Promise.race(array);
            }
        });
    }

    public final Promise<?> race() {
        return Promise.race(this);
    }

    public static final Promise<?> any(Object[] array) {
        int n = array.length;
        if (n == 0) {
            return Promise.error(new IllegalArgumentException("any(): array must not be empty"));
        }
        final RuntimeException reason = new RuntimeException("any(): all promises failed");
        final Promise promise = new Promise();
        final AtomicInteger count = new AtomicInteger(n);
        for (int i = 0; i < n; ++i) {
            Promise.toPromise(array[i]).then(new Action<Object>(){

                @Override
                public void call(Object value) throws Throwable {
                    promise.resolve(value);
                }
            }, new Action<Throwable>(){

                @Override
                public void call(Throwable e) throws Throwable {
                    if (JdkVersion.majorJavaVersion >= 7) {
                        reason.addSuppressed(e);
                    }
                    if (count.decrementAndGet() == 0) {
                        promise.reject(reason);
                    }
                }
            });
        }
        return promise;
    }

    public static final Promise<?> any(Promise<Object[]> promise) {
        return promise.then(new Func<Promise<?>, Object[]>(){

            @Override
            public Promise<?> call(Object[] array) throws Throwable {
                return Promise.any(array);
            }
        });
    }

    public final Promise<?> any() {
        return Promise.any(this);
    }

    public static final Promise<?> run(Callback<Object[]> handler, Object ... args) {
        return Promise.all(args).then(handler);
    }

    public static final <V> Promise<?> forEach(final Action<V> callback, Object ... args) {
        return Promise.all(args).then((Callback<Object[]>)new Action<Object[]>(){

            @Override
            public void call(Object[] array) throws Throwable {
                int n = array.length;
                for (int i = 0; i < n; ++i) {
                    callback.call(array[i]);
                }
            }
        });
    }

    private static <V> Action<Object[]> getForEachHandler(final Handler<?, V> callback) {
        return new Action<Object[]>(){

            @Override
            public void call(Object[] array) throws Throwable {
                int n = array.length;
                for (int i = 0; i < n; ++i) {
                    callback.call(array[i], i);
                }
            }
        };
    }

    public static final <V> Promise<?> forEach(Object[] array, Handler<?, V> callback) {
        return Promise.all(array).then(Promise.getForEachHandler(callback));
    }

    public static final <V> Promise<?> forEach(Promise<Object[]> array, Handler<?, V> callback) {
        return Promise.all(array).then(Promise.getForEachHandler(callback));
    }

    public final Promise<?> forEach(Handler<?, V> callback) {
        return this.all().then(Promise.getForEachHandler(callback));
    }

    public static final <V> Promise<Boolean> every(final Func<Boolean, V> callback, Object ... args) {
        return Promise.all(args).then((Callback<Object[]>)new Func<Boolean, Object[]>(){

            @Override
            public Boolean call(Object[] array) throws Throwable {
                int n = array.length;
                for (int i = 0; i < n; ++i) {
                    if (((Boolean)callback.call(array[i])).booleanValue()) continue;
                    return false;
                }
                return true;
            }
        });
    }

    private static <V> Func<Boolean, Object[]> getEveryHandler(final Handler<Boolean, V> callback) {
        return new Func<Boolean, Object[]>(){

            @Override
            public Boolean call(Object[] array) throws Throwable {
                int n = array.length;
                for (int i = 0; i < n; ++i) {
                    if (((Boolean)callback.call(array[i], i)).booleanValue()) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static final <V> Promise<Boolean> every(Object[] array, Handler<Boolean, V> callback) {
        return Promise.all(array).then(Promise.getEveryHandler(callback));
    }

    public static final <V> Promise<Boolean> every(Promise<Object[]> array, Handler<Boolean, V> callback) {
        return Promise.all(array).then(Promise.getEveryHandler(callback));
    }

    public final <V> Promise<Boolean> every(Handler<Boolean, V> callback) {
        return this.all().then(Promise.getEveryHandler(callback));
    }

    public static final <V> Promise<Boolean> some(final Func<Boolean, V> callback, Object ... args) {
        return Promise.all(args).then((Callback<Object[]>)new Func<Boolean, Object[]>(){

            @Override
            public Boolean call(Object[] array) throws Throwable {
                int n = array.length;
                for (int i = 0; i < n; ++i) {
                    if (!((Boolean)callback.call(array[i])).booleanValue()) continue;
                    return true;
                }
                return false;
            }
        });
    }

    private static <V> Func<Boolean, Object[]> getSomeHandler(final Handler<Boolean, V> callback) {
        return new Func<Boolean, Object[]>(){

            @Override
            public Boolean call(Object[] array) throws Throwable {
                int n = array.length;
                for (int i = 0; i < n; ++i) {
                    if (!((Boolean)callback.call(array[i], i)).booleanValue()) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static final <V> Promise<Boolean> some(Object[] array, Handler<Boolean, V> callback) {
        return Promise.all(array).then(Promise.getSomeHandler(callback));
    }

    public static final <V> Promise<Boolean> some(Promise<Object[]> array, Handler<Boolean, V> callback) {
        return Promise.all(array).then(Promise.getSomeHandler(callback));
    }

    public final <V> Promise<Boolean> some(Handler<Boolean, V> callback) {
        return this.all().then(Promise.getSomeHandler(callback));
    }

    public static final <V> Promise<Object[]> filter(final Func<Boolean, V> callback, Object ... args) {
        return Promise.all(args).then((Callback<Object[]>)new Func<Object[], Object[]>(){

            @Override
            public Object[] call(Object[] array) throws Throwable {
                int n = array.length;
                ArrayList<Object> result = new ArrayList<Object>(n);
                for (int i = 0; i < n; ++i) {
                    if (!((Boolean)callback.call(array[i])).booleanValue()) continue;
                    result.add(array[i]);
                }
                return result.toArray();
            }
        });
    }

    private static <V> Func<Object[], Object[]> getFilterHandler(final Handler<Boolean, V> callback) {
        return new Func<Object[], Object[]>(){

            @Override
            public Object[] call(Object[] array) throws Throwable {
                int n = array.length;
                ArrayList<Object> result = new ArrayList<Object>(n);
                for (int i = 0; i < n; ++i) {
                    if (!((Boolean)callback.call(array[i], i)).booleanValue()) continue;
                    result.add(array[i]);
                }
                return result.toArray();
            }
        };
    }

    public static final <V> Promise<Object[]> filter(Object[] array, Handler<Boolean, V> callback) {
        return Promise.all(array).then(Promise.getFilterHandler(callback));
    }

    public static final <V> Promise<Object[]> filter(Promise<Object[]> array, Handler<Boolean, V> callback) {
        return Promise.all(array).then(Promise.getFilterHandler(callback));
    }

    public final <V> Promise<Object[]> filter(Handler<Boolean, V> callback) {
        return this.all().then(Promise.getFilterHandler(callback));
    }

    public static final <V> Promise<Object[]> map(final Func<?, V> callback, Object ... args) {
        return Promise.all(args).then((Callback<Object[]>)new Func<Object[], Object[]>(){

            @Override
            public Object[] call(Object[] array) throws Throwable {
                int n = array.length;
                Object[] result = new Object[n];
                for (int i = 0; i < n; ++i) {
                    result[i] = callback.call(array[i]);
                }
                return result;
            }
        });
    }

    private static <V> Func<Object[], Object[]> getMapHandler(final Handler<?, V> callback) {
        return new Func<Object[], Object[]>(){

            @Override
            public Object[] call(Object[] array) throws Throwable {
                int n = array.length;
                Object[] result = new Object[n];
                for (int i = 0; i < n; ++i) {
                    result[i] = callback.call(array[i], i);
                }
                return result;
            }
        };
    }

    public static final <V> Promise<Object[]> map(Object[] array, Handler<?, V> callback) {
        return Promise.all(array).then(Promise.getMapHandler(callback));
    }

    public static final <V> Promise<Object[]> map(Promise<Object[]> array, Handler<?, V> callback) {
        return Promise.all(array).then(Promise.getMapHandler(callback));
    }

    public final <V> Promise<Object[]> map(Handler<?, V> callback) {
        return this.all().then(Promise.getMapHandler(callback));
    }

    private static <V> Func<V, Object[]> getReduceHandler(final Reducer<V, V> callback) {
        return new Func<V, Object[]>(){

            @Override
            public V call(Object[] array) throws Throwable {
                int n = array.length;
                if (n == 0) {
                    return null;
                }
                Object result = array[0];
                for (int i = 1; i < n; ++i) {
                    result = callback.call(result, array[i], i);
                }
                return result;
            }
        };
    }

    public static final <V> Promise<V> reduce(Object[] array, Reducer<V, V> callback) {
        return Promise.all(array).then(Promise.getReduceHandler(callback));
    }

    public static final <V> Promise<V> reduce(Promise<Object[]> array, Reducer<V, V> callback) {
        return Promise.all(array).then(Promise.getReduceHandler(callback));
    }

    public final <V> Promise<V> reduce(Reducer<V, V> callback) {
        return this.all().then(Promise.getReduceHandler(callback));
    }

    private static <R, V> Func<R, Object[]> getReduceHandler(final Reducer<R, V> callback, final R initialValue) {
        return new Func<R, Object[]>(){

            @Override
            public R call(Object[] array) throws Throwable {
                int n = array.length;
                if (n == 0) {
                    return initialValue;
                }
                Object result = initialValue;
                for (int i = 0; i < n; ++i) {
                    result = callback.call(result, array[i], i);
                }
                return result;
            }
        };
    }

    public static final <R, V> Promise<V> reduce(Object[] array, Reducer<R, V> callback, R initialValue) {
        return Promise.all(array).then(Promise.getReduceHandler(callback, initialValue));
    }

    public static final <R, V> Promise<V> reduce(Promise<Object[]> array, Reducer<R, V> callback, R initialValue) {
        return Promise.all(array).then(Promise.getReduceHandler(callback, initialValue));
    }

    public final <R, V> Promise<V> reduce(Reducer<R, V> callback, R initialValue) {
        return this.all().then(Promise.getReduceHandler(callback, initialValue));
    }

    private static <V> Func<V, Object[]> getReduceRightHandler(final Reducer<V, V> callback) {
        return new Func<V, Object[]>(){

            @Override
            public V call(Object[] array) throws Throwable {
                int n = array.length;
                if (n == 0) {
                    return null;
                }
                Object result = array[n - 1];
                for (int i = n - 2; i >= 0; --i) {
                    result = callback.call(result, array[i], i);
                }
                return result;
            }
        };
    }

    public static final <V> Promise<V> reduceRight(Object[] array, Reducer<V, V> callback) {
        return Promise.all(array).then(Promise.getReduceRightHandler(callback));
    }

    public static final <V> Promise<V> reduceRight(Promise<Object[]> array, Reducer<V, V> callback) {
        return Promise.all(array).then(Promise.getReduceRightHandler(callback));
    }

    public final <V> Promise<V> reduceRight(Reducer<V, V> callback) {
        return this.all().then(Promise.getReduceRightHandler(callback));
    }

    private static <R, V> Func<R, Object[]> getReduceRightHandler(final Reducer<R, V> callback, final R initialValue) {
        return new Func<R, Object[]>(){

            @Override
            public R call(Object[] array) throws Throwable {
                int n = array.length;
                if (n == 0) {
                    return initialValue;
                }
                Object result = initialValue;
                for (int i = n - 1; i >= 0; --i) {
                    result = callback.call(result, array[i], i);
                }
                return result;
            }
        };
    }

    public static final <R, V> Promise<V> reduceRight(Object[] array, Reducer<R, V> callback, R initialValue) {
        return Promise.all(array).then(Promise.getReduceRightHandler(callback, initialValue));
    }

    public static final <R, V> Promise<V> reduceRight(Promise<Object[]> array, Reducer<R, V> callback, R initialValue) {
        return Promise.all(array).then(Promise.getReduceRightHandler(callback, initialValue));
    }

    public final <R, V> Promise<V> reduceRight(Reducer<R, V> callback, R initialValue) {
        return this.all().then(Promise.getReduceRightHandler(callback, initialValue));
    }

    private <V> void call(final Callback<V> callback, final Promise<?> next, final V x) {
        timer.execute(new Runnable(){

            public void run() {
                try {
                    if (callback instanceof Action) {
                        ((Action)callback).call(x);
                        next.resolve(null);
                    } else {
                        Object value = ((Func)callback).call(x);
                        next.resolve(value);
                    }
                }
                catch (Throwable e) {
                    next.reject(e);
                }
            }
        });
    }

    private void reject(Callback<Throwable> onreject, Promise<?> next, Throwable e) {
        if (onreject != null) {
            this.call(onreject, next, e);
        } else {
            next.reject(e);
        }
    }

    private void resolve(final Callback<V> onfulfill, final Callback<Throwable> onreject, final Promise<?> next, Object x) {
        if (x instanceof Promise) {
            if (x == this) {
                this.reject(onreject, next, new TypeException("Self resolution"));
                return;
            }
            Action<Object> resolveFunction = new Action<Object>(){

                @Override
                public void call(Object y) throws Throwable {
                    Promise.this.resolve(onfulfill, onreject, next, y);
                }
            };
            Action<Throwable> rejectFunction = new Action<Throwable>(){

                @Override
                public void call(Throwable e) throws Throwable {
                    Promise.this.reject(onreject, next, e);
                }
            };
            ((Promise)x).then((Callback)resolveFunction, rejectFunction);
        } else if (x instanceof Thenable) {
            final AtomicBoolean notrun = new AtomicBoolean(true);
            Action<Object> resolveFunction = new Action<Object>(){

                @Override
                public void call(Object y) throws Throwable {
                    if (notrun.compareAndSet(true, false)) {
                        Promise.this.resolve(onfulfill, onreject, next, y);
                    }
                }
            };
            Action<Throwable> rejectFunction = new Action<Throwable>(){

                @Override
                public void call(Throwable e) throws Throwable {
                    if (notrun.compareAndSet(true, false)) {
                        Promise.this.reject(onreject, next, e);
                    }
                }
            };
            try {
                ((Thenable)x).then(resolveFunction, (Callback<Throwable>)rejectFunction);
            }
            catch (Throwable e) {
                if (notrun.compareAndSet(true, false)) {
                    this.reject(onreject, next, e);
                }
            }
        } else if (onfulfill != null) {
            this.call(onfulfill, next, x);
        } else {
            next.resolve(x);
        }
    }

    @Override
    public final void resolve(Object value) {
        if (this.state == State.PENDING) {
            this.state = State.FULFILLED;
            this.value = value;
            while (!this.subscribers.isEmpty()) {
                Subscriber<V> subscriber = this.subscribers.poll();
                this.resolve(subscriber.onfulfill, subscriber.onreject, subscriber.next, value);
            }
        }
    }

    @Override
    public final void reject(Throwable e) {
        if (this.state == State.PENDING) {
            this.state = State.REJECTED;
            this.reason = e;
            while (!this.subscribers.isEmpty()) {
                Subscriber<V> subscriber = this.subscribers.poll();
                if (subscriber.onreject != null) {
                    this.call(subscriber.onreject, subscriber.next, e);
                    continue;
                }
                subscriber.next.reject(e);
            }
        }
    }

    public final Promise<?> then(Callback<V> onfulfill) {
        return this.then((Callback)onfulfill, (Callback)null);
    }

    @Override
    public final Promise<?> then(Callback<V> onfulfill, Callback<Throwable> onreject) {
        if (onfulfill != null || onreject != null) {
            Promise<V> next = new Promise<V>();
            if (this.state == State.FULFILLED) {
                this.resolve(onfulfill, onreject, next, this.value);
            } else if (this.state == State.REJECTED) {
                if (onreject != null) {
                    this.call(onreject, next, this.reason);
                } else {
                    next.reject(this.reason);
                }
            } else {
                this.subscribers.offer(new Subscriber<V>(onfulfill, onreject, next));
            }
            return next;
        }
        return this;
    }

    public final void done(Callback<V> onfulfill) {
        this.done(onfulfill, null);
    }

    public final void done(Callback<V> onfulfill, Callback<Throwable> onreject) {
        ((Promise)this.then((Callback)onfulfill, (Callback)onreject)).then((Callback)null, new Action<Throwable>(){

            @Override
            public void call(final Throwable e) {
                timer.execute(new Runnable(){

                    public void run() {
                        throw new RuntimeException(e);
                    }
                });
            }
        });
    }

    public final State getState() {
        return this.state;
    }

    public final Object getValue() {
        return this.value;
    }

    public final Throwable getReason() {
        return this.reason;
    }

    public final Promise<?> catchError(final Callback<Throwable> onreject, final Func<Boolean, Throwable> test) {
        if (test != null) {
            return this.then((Callback)null, (Callback)new Func<Promise<?>, Throwable>(){

                @Override
                public Promise<?> call(Throwable e) throws Throwable {
                    if (((Boolean)test.call(e)).booleanValue()) {
                        return Promise.this.then((Callback)null, onreject);
                    }
                    throw e;
                }
            });
        }
        return this.then((Callback)null, (Callback)onreject);
    }

    public final Promise<?> catchError(Callback<Throwable> onreject) {
        return this.then((Callback)null, (Callback)onreject);
    }

    public final void fail(Callback<Throwable> onreject) {
        this.done(null, onreject);
    }

    public final Promise<V> whenComplete(final Callable<?> action) {
        return this.then((Callback)new Func<Object, V>(){

            @Override
            public Object call(final V value) throws Throwable {
                Object f = action.call();
                if (f == null || !Promise.isThenable(f)) {
                    return value;
                }
                return Promise.toPromise(f).then(new Func<V, Object>(){

                    @Override
                    public V call(Object __) throws Throwable {
                        return value;
                    }
                });
            }
        }, new Func<Object, Throwable>(){

            @Override
            public Object call(final Throwable e) throws Throwable {
                Object f = action.call();
                if (f == null || !Promise.isThenable(f)) {
                    throw e;
                }
                return Promise.toPromise(f).then(new Func<V, Object>(){

                    @Override
                    public V call(Object __) throws Throwable {
                        throw e;
                    }
                });
            }
        });
    }

    public final Promise<V> whenComplete(final Runnable action) {
        return this.then((Callback)new Func<Object, V>(){

            @Override
            public Object call(V value) throws Throwable {
                action.run();
                return value;
            }
        }, new Func<Object, Throwable>(){

            @Override
            public Object call(Throwable e) throws Throwable {
                action.run();
                throw e;
            }
        });
    }

    public final Promise<?> complete(Callback<?> oncomplete) {
        return this.then((Callback)oncomplete, oncomplete);
    }

    public final void always(Callback<?> oncomplete) {
        this.done(oncomplete, oncomplete);
    }

    public final void fill(final Promise<V> promise) {
        this.then((Callback)new Action<V>(){

            @Override
            public void call(V value) throws Throwable {
                promise.resolve(value);
            }
        }, new Action<Throwable>(){

            @Override
            public void call(Throwable e) throws Throwable {
                promise.reject(e);
            }
        });
    }

    public final Promise<V> timeout(long duration, TimeUnit timeunit, final Throwable reason) {
        final Promise<V> promise = new Promise<V>();
        final ScheduledFuture<?> timeoutID = timer.schedule(new Runnable(){

            public void run() {
                if (reason == null) {
                    promise.reject(new TimeoutException("timeout"));
                } else {
                    promise.reject(reason);
                }
            }
        }, duration, timeunit);
        this.whenComplete(new Runnable(){

            public void run() {
                timeoutID.cancel(true);
            }
        }).fill(promise);
        return promise;
    }

    public final Promise<V> timeout(long duration, Throwable reason) {
        return this.timeout(duration, TimeUnit.MILLISECONDS, reason);
    }

    public final Promise<V> timeout(long duration) {
        return this.timeout(duration, TimeUnit.MILLISECONDS, null);
    }

    public final Promise<V> delay(final long duration, final TimeUnit timeunit) {
        final Promise<V> promise = new Promise<V>();
        this.then((Callback)new Action<V>(){

            @Override
            public void call(final V value) throws Throwable {
                timer.schedule(new Runnable(){

                    public void run() {
                        promise.resolve(value);
                    }
                }, duration, timeunit);
            }
        }, new Action<Throwable>(){

            @Override
            public void call(Throwable e) throws Throwable {
                promise.reject(e);
            }
        });
        return promise;
    }

    public final Promise<V> delay(long duration) {
        return this.delay(duration, TimeUnit.MILLISECONDS);
    }

    public final Promise<V> tap(final Action<V> onfulfilledSideEffect) {
        return this.then(new Func<V, V>(){

            @Override
            public V call(V value) throws Throwable {
                onfulfilledSideEffect.call(value);
                return value;
            }
        });
    }

    static {
        Threads.registerShutdownHandler(new Runnable(){

            public void run() {
                timer.shutdown();
            }
        });
    }
}

