/*
 * Decompiled with CFR 0.152.
 */
package hprose.util.concurrent;

public final class Threads {
    private static final ThreadGroup rootThreadGroup;
    private static final Thread mainThread;
    private static volatile boolean enableShutdownHandler;
    private static volatile Runnable defaultHandler;

    public static Thread[] findAllThreads() {
        int estimatedSize = rootThreadGroup.activeCount() * 2;
        Thread[] slackList = new Thread[estimatedSize];
        int actualSize = rootThreadGroup.enumerate(slackList);
        Thread[] list = new Thread[actualSize];
        System.arraycopy(slackList, 0, list, 0, actualSize);
        return list;
    }

    public static Thread getMainThread() {
        return mainThread;
    }

    public static ThreadGroup getRootThreadGroup() {
        return rootThreadGroup;
    }

    public static synchronized void registerShutdownHandler(final Runnable handler) {
        if (enableShutdownHandler) {
            if (defaultHandler == null) {
                defaultHandler = handler;
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    public void run() {
                        defaultHandler.run();
                    }
                });
                new Thread(){
                    private final Object o = new Object();

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        while (true) {
                            if (!mainThread.isAlive()) {
                                System.exit(0);
                                break;
                            }
                            Object object = this.o;
                            synchronized (object) {
                                try {
                                    this.o.wait(100L);
                                }
                                catch (InterruptedException e) {
                                    break;
                                }
                            }
                        }
                    }
                }.start();
            } else {
                final Runnable oldHandler = defaultHandler;
                defaultHandler = new Runnable(){

                    public void run() {
                        oldHandler.run();
                        handler.run();
                    }
                };
            }
        }
    }

    public static void run() {
        defaultHandler.run();
    }

    public static void disabledShutdownHandler() {
        enableShutdownHandler = false;
    }

    static {
        Thread[] threads;
        ThreadGroup parentThreadGroup;
        enableShutdownHandler = true;
        defaultHandler = null;
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while ((parentThreadGroup = threadGroup.getParent()) != null) {
            threadGroup = parentThreadGroup;
        }
        rootThreadGroup = threadGroup;
        Thread thread = Thread.currentThread();
        for (Thread t : threads = Threads.findAllThreads()) {
            if (t.getId() != 1L) continue;
            thread = t;
        }
        mainThread = thread;
    }
}

