/*
 * Decompiled with CFR 0.152.
 */
package hprose.util.concurrent;

import hprose.util.concurrent.Threads;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class Timer {
    private static final ScheduledExecutorService timer1 = Executors.newSingleThreadScheduledExecutor();
    private static final ScheduledExecutorService timer2 = Executors.newSingleThreadScheduledExecutor();
    private final Runnable timeoutCallback;
    private Future<?> timeoutID = null;

    public Timer(Runnable callback) {
        this.timeoutCallback = callback;
    }

    public void clear() {
        if (this.timeoutID != null) {
            this.timeoutID.cancel(false);
            this.timeoutID = null;
        }
    }

    public void setTimeout(long timeout) {
        this.setTimeout(timeout, false);
    }

    public void setInterval(long timeout) {
        this.setInterval(timeout, false);
    }

    public void setTimeout(long timeout, boolean waitOnShutdown) {
        this.clear();
        this.timeoutID = (waitOnShutdown ? timer1 : timer2).schedule(this.timeoutCallback, timeout, TimeUnit.MILLISECONDS);
    }

    public void setInterval(long timeout, boolean waitOnShutdown) {
        this.clear();
        if (timeout > 0L) {
            this.timeoutID = (waitOnShutdown ? timer1 : timer2).scheduleAtFixedRate(this.timeoutCallback, timeout, timeout, TimeUnit.MILLISECONDS);
        }
    }

    static {
        Threads.registerShutdownHandler(new Runnable(){

            public void run() {
                timer1.shutdown();
                List<Runnable> tasks = timer2.shutdownNow();
                for (Runnable task : tasks) {
                    task.run();
                }
            }
        });
    }
}

