/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.executor;

import java.io.ByteArrayInputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.hswebframework.ezorm.core.ObjectWrapper;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.ezorm.rdb.executor.BindSQL;
import org.hswebframework.ezorm.rdb.executor.EmptySQL;
import org.hswebframework.ezorm.rdb.executor.SQL;
import org.hswebframework.ezorm.rdb.executor.SqlExecutor;
import org.hswebframework.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJdbcSqlExecutor
implements SqlExecutor {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final Pattern APPEND_PATTERN = Pattern.compile("(?<=\\$\\{)(.+?)(?=\\})");
    public static final Pattern PREPARED_PATTERN = Pattern.compile("(?<=#\\{)(.+?)(?=\\})");
    protected PropertyUtilsBean propertyUtils = BeanUtilsBean.getInstance().getPropertyUtils();

    public abstract Connection getConnection();

    protected Object getSqlParamValue(Object param, String paramName) {
        try {
            Object obj = this.propertyUtils.getProperty(param, paramName);
            if (obj instanceof Term) {
                obj = ((Term)obj).getValue();
            }
            return obj;
        }
        catch (Exception e) {
            this.logger.warn("\u83b7\u53d6sql\u53c2\u6570\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public SQLInfo compileSql(SQL sql) {
        String sqlTemplate = sql.getSql();
        try {
            Object obj;
            String group;
            SQLInfo sqlInfo = new SQLInfo();
            Object param = sql.getParams();
            Matcher prepared_matcher = PREPARED_PATTERN.matcher(sqlTemplate);
            Matcher append_matcher = APPEND_PATTERN.matcher(sqlTemplate);
            LinkedList<Object> params = new LinkedList<Object>();
            while (append_matcher.find()) {
                group = append_matcher.group();
                obj = this.getSqlParamValue(param, group);
                sqlTemplate = sqlTemplate.replaceFirst(StringUtils.concat((Object[])new Object[]{"\\$\\{", AbstractJdbcSqlExecutor.escapeExprSpecialWord(group), "\\}"}), String.valueOf(obj));
            }
            while (prepared_matcher.find()) {
                group = prepared_matcher.group();
                sqlTemplate = sqlTemplate.replaceFirst(StringUtils.concat((Object[])new Object[]{"#\\{", AbstractJdbcSqlExecutor.escapeExprSpecialWord(group), "\\}"}), "?");
                obj = this.getSqlParamValue(param, group);
                params.add(obj);
            }
            sqlInfo.setSql(sqlTemplate);
            sqlInfo.setParam(params.toArray());
            return sqlInfo;
        }
        catch (Exception e) {
            this.logger.error("compile sql  {}  error", (Object)sqlTemplate, (Object)e);
            throw e;
        }
    }

    protected List<SQLInfo> compileAllSql(SQL sql) {
        ArrayList<SQLInfo> allSql = new ArrayList<SQLInfo>(4);
        allSql.add(this.compileSql(sql));
        if (sql.getBinds() != null) {
            sql.getBinds().forEach(bind -> allSql.add(this.compileSql(bind.getSql())));
        }
        return allSql;
    }

    public abstract void releaseConnection(Connection var1) throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<T> list(SQL sql, ObjectWrapper<T> wrapper) throws SQLException {
        if (sql instanceof EmptySQL) {
            return new ArrayList();
        }
        SQLInfo info = this.compileSql(sql);
        this.printSql(info);
        Connection connection = this.getConnection();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        ArrayList<Object> datas = new ArrayList<Object>();
        try {
            statement = connection.prepareStatement(info.getSql());
            this.preparedParam(statement, info);
            resultSet = statement.executeQuery();
            ResultSetMetaData metaData = resultSet.getMetaData();
            int count = metaData.getColumnCount();
            ArrayList<String> headers = new ArrayList<String>();
            for (int i = 1; i <= count; ++i) {
                headers.add(metaData.getColumnLabel(i));
            }
            wrapper.setUp(headers);
            int index = 0;
            while (resultSet.next()) {
                Object data = wrapper.newInstance();
                for (int i = 0; i < headers.size(); ++i) {
                    Object value = resultSet.getObject(i + 1);
                    wrapper.wrapper(data, index, (String)headers.get(i), value);
                }
                ++index;
                if (!wrapper.done(data)) continue;
                datas.add(data);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("<==      total: {}", (Object)index);
            }
            this.closeResultSet(resultSet);
            this.closeStatement(statement);
        }
        catch (Throwable throwable) {
            this.closeResultSet(resultSet);
            this.closeStatement(statement);
            this.releaseConnection(connection);
            throw throwable;
        }
        this.releaseConnection(connection);
        return datas;
    }

    protected void closeResultSet(ResultSet resultSet) {
        try {
            if (null != resultSet) {
                resultSet.close();
            }
        }
        catch (SQLException e) {
            this.logger.error("close ResultSet error", (Throwable)e);
        }
    }

    protected void closeStatement(Statement statement) {
        try {
            if (null != statement) {
                statement.close();
            }
        }
        catch (SQLException e) {
            this.logger.error("close ResultSet error", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T single(SQL sql, ObjectWrapper<T> wrapper) throws SQLException {
        if (sql instanceof EmptySQL) {
            return null;
        }
        SQLInfo info = this.compileSql(sql);
        this.printSql(info);
        Connection connection = this.getConnection();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        Object data = null;
        try {
            statement = connection.prepareStatement(info.getSql());
            this.preparedParam(statement, info);
            resultSet = statement.executeQuery();
            ResultSetMetaData metaData = resultSet.getMetaData();
            int count = metaData.getColumnCount();
            ArrayList<String> headers = new ArrayList<String>();
            for (int i = 1; i <= count; ++i) {
                headers.add(metaData.getColumnLabel(i));
            }
            wrapper.setUp(headers);
            int index = 0;
            if (resultSet.next()) {
                data = wrapper.newInstance();
                for (int i = 0; i < headers.size(); ++i) {
                    Object value = resultSet.getObject(i + 1);
                    wrapper.wrapper(data, index, (String)headers.get(i), value);
                }
                ++index;
                wrapper.done(data);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("<==      total: {}", (Object)index);
            }
            this.closeResultSet(resultSet);
            this.closeStatement(statement);
        }
        catch (Throwable throwable) {
            this.closeResultSet(resultSet);
            this.closeStatement(statement);
            this.releaseConnection(connection);
            throw throwable;
        }
        this.releaseConnection(connection);
        return (T)data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exec(SQL sql) throws SQLException {
        if (sql instanceof EmptySQL) {
            return;
        }
        SQLInfo info = this.compileSql(sql);
        this.printSql(info);
        Connection connection = this.getConnection();
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(info.getSql());
            this.preparedParam(statement, info);
            statement.execute();
            if (sql.getBinds() != null) {
                for (BindSQL bindSQL : sql.getBinds()) {
                    this.exec(bindSQL.getSql());
                }
            }
        }
        finally {
            this.closeStatement(statement);
            this.releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update(SQL sql) throws SQLException {
        if (sql instanceof EmptySQL) {
            return 0;
        }
        SQLInfo info = this.compileSql(sql);
        this.printSql(info);
        Connection connection = this.getConnection();
        int i = 0;
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(info.getSql());
            this.preparedParam(statement, info);
            i = statement.executeUpdate();
            if (sql.getBinds() != null) {
                for (BindSQL bindSQL : sql.getBinds()) {
                    i += this.update(bindSQL.getSql());
                }
            }
            int n = i;
            return n;
        }
        finally {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("<==    updated: {} rows", (Object)i);
            }
            this.closeStatement(statement);
            this.releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delete(SQL sql) throws SQLException {
        int i;
        if (sql instanceof EmptySQL) {
            return 0;
        }
        SQLInfo info = this.compileSql(sql);
        this.printSql(info);
        Connection connection = this.getConnection();
        try {
            PreparedStatement statement = connection.prepareStatement(info.getSql());
            this.preparedParam(statement, info);
            i = statement.executeUpdate();
            if (sql.getBinds() != null) {
                for (BindSQL bindSQL : sql.getBinds()) {
                    i += this.delete(bindSQL.getSql());
                }
                int n = i;
                return n;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("<==     delete: {} rows", (Object)i);
            }
            this.closeStatement(statement);
        }
        finally {
            this.releaseConnection(connection);
        }
        return i;
    }

    @Override
    public int insert(SQL sql) throws SQLException {
        return this.update(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tableExists(String tname) throws SQLException {
        Connection connection = this.getConnection();
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            ResultSet resultSet = metaData.getTables(connection.getCatalog(), null, tname.toUpperCase(), null);
            if (resultSet.next()) {
                boolean bl = true;
                return bl;
            }
            resultSet = metaData.getTables(connection.getCatalog(), null, tname.toLowerCase(), null);
            if (resultSet.next()) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.releaseConnection(connection);
        }
        return false;
    }

    protected void preparedParam(PreparedStatement statement, SQLInfo info) throws SQLException {
        int index = 1;
        for (Object object : info.getParam()) {
            if (object == null) {
                statement.setNull(index++, 0);
                continue;
            }
            if (object instanceof Date) {
                statement.setTimestamp(index++, new Timestamp(((Date)object).getTime()));
                continue;
            }
            if (object instanceof byte[]) {
                statement.setBlob(index++, new ByteArrayInputStream((byte[])object));
                continue;
            }
            statement.setObject(index++, object);
        }
    }

    protected void printSql(SQLInfo info) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("==>  Preparing: {}", (Object)info.getSql());
            if (info.getParam() != null && info.getParam().length > 0) {
                this.logger.debug("==> Parameters: {}", (Object)info.paramsString());
                Object[] param = info.getParam();
                if (param.length > 200) {
                    return;
                }
                String sim = info.getSql();
                for (int i = 0; i < param.length; ++i) {
                    Object obj = param[i];
                    try {
                        sim = sim.replaceFirst("\\?", obj instanceof Number ? String.valueOf(obj) : "'".concat(AbstractJdbcSqlExecutor.escapeExprSpecialWord(String.valueOf(obj))).concat("'"));
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.logger.debug("==>  Simulated: {}", (Object)sim);
            }
        }
    }

    public static String escapeExprSpecialWord(String keyword) {
        if (!StringUtils.isNullOrEmpty((Object)keyword)) {
            String[] fbsArr;
            for (String key : fbsArr = new String[]{"\\", "$", "(", ")", "*", "+", ".", "[", "]", "?", "^", "{", "}", "|"}) {
                if (!keyword.contains(key)) continue;
                keyword = keyword.replace(key, "\\" + key);
            }
        }
        return keyword;
    }

    public static class SQLInfo {
        private String sql;
        private Object[] param;
        private String paramString;

        public String getSql() {
            return this.sql;
        }

        public void setSql(String sql) {
            this.sql = sql;
        }

        public Object[] getParam() {
            return this.param;
        }

        public void setParam(Object[] param) {
            this.param = param;
        }

        public String paramsString() {
            if (this.getParam() == null) {
                return "";
            }
            if (this.paramString == null) {
                StringBuilder builder = new StringBuilder();
                int i = 0;
                for (Object param : this.getParam()) {
                    if (i++ != 0) {
                        builder.append(",");
                    }
                    builder.append(String.valueOf(param));
                    builder.append("(");
                    builder.append(param == null ? "null" : param.getClass().getSimpleName());
                    builder.append(")");
                }
                this.paramString = builder.toString();
            }
            return this.paramString;
        }
    }
}

