/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.meta.builder.simple;

import java.sql.JDBCType;
import java.util.function.Consumer;
import org.hswebframework.ezorm.rdb.meta.RDBColumnMetaData;
import org.hswebframework.ezorm.rdb.meta.RDBTableMetaData;
import org.hswebframework.ezorm.rdb.meta.builder.ColumnBuilder;
import org.hswebframework.ezorm.rdb.meta.builder.TableBuilder;
import org.hswebframework.ezorm.rdb.meta.converter.BooleanValueConverter;
import org.hswebframework.ezorm.rdb.meta.converter.NumberValueConverter;
import org.hswebframework.utils.ClassUtils;

public class SimpleColumnBuilder
implements ColumnBuilder {
    RDBColumnMetaData columnMetaData;
    TableBuilder tableBuilder;
    RDBTableMetaData tableMetaData;

    public SimpleColumnBuilder(RDBColumnMetaData columnMetaData, TableBuilder tableBuilder, RDBTableMetaData tableMetaData) {
        this.columnMetaData = columnMetaData;
        this.tableBuilder = tableBuilder;
        this.tableMetaData = tableMetaData;
    }

    @Override
    public ColumnBuilder name(String name) {
        this.columnMetaData.setName(name);
        return this;
    }

    @Override
    public ColumnBuilder custom(Consumer<RDBColumnMetaData> consumer) {
        consumer.accept(this.columnMetaData);
        return this;
    }

    @Override
    public ColumnBuilder alias(String name) {
        this.columnMetaData.setAlias(name);
        return this;
    }

    @Override
    public ColumnBuilder dataType(String dataType) {
        this.columnMetaData.setDataType(dataType);
        return this;
    }

    @Override
    public ColumnBuilder jdbcType(JDBCType jdbcType) {
        this.columnMetaData.setJdbcType(jdbcType);
        return this;
    }

    @Override
    public ColumnBuilder javaType(Class javaType) {
        this.columnMetaData.setJavaType(javaType);
        return this;
    }

    @Override
    public ColumnBuilder comment(String comment) {
        this.columnMetaData.setComment(comment);
        return this;
    }

    @Override
    public ColumnBuilder notNull() {
        this.columnMetaData.setNotNull(true);
        return this;
    }

    @Override
    public ColumnBuilder primaryKey() {
        this.columnMetaData.setPrimaryKey(true);
        return this;
    }

    @Override
    public ColumnBuilder columnDef(String def) {
        this.columnMetaData.setColumnDefinition(def);
        return this;
    }

    @Override
    public ColumnBuilder length(int len) {
        this.columnMetaData.setLength(len);
        return this;
    }

    @Override
    public ColumnBuilder length(int precision, int scale) {
        this.columnMetaData.setLength(precision);
        this.columnMetaData.setScale(scale);
        this.columnMetaData.setPrecision(precision);
        return this;
    }

    @Override
    public ColumnBuilder property(String propertyName, Object value) {
        this.columnMetaData.setProperty(propertyName, value);
        return this;
    }

    @Override
    public TableBuilder commit() {
        if (this.columnMetaData.getDataType() == null) {
            String dataType = this.tableMetaData.getDatabaseMetaData().getDialect().buildDataType(this.columnMetaData);
            this.columnMetaData.setDataType(dataType);
        }
        if (this.columnMetaData.getJavaType() != null) {
            if (ClassUtils.instanceOf((Class)this.columnMetaData.getJavaType(), Number.class)) {
                this.columnMetaData.setValueConverter(new NumberValueConverter(this.columnMetaData.getJavaType()));
            }
            if (this.columnMetaData.getJavaType() == Boolean.class || this.columnMetaData.getJavaType() == Boolean.TYPE) {
                this.columnMetaData.setValueConverter(new BooleanValueConverter());
            }
        }
        this.tableMetaData.addColumn(this.columnMetaData);
        return this.tableBuilder;
    }
}

