/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.meta.converter;

import java.math.BigDecimal;
import java.util.Date;
import java.util.function.Function;
import org.hswebframework.ezorm.core.ValueConverter;
import org.hswebframework.utils.ClassUtils;
import org.hswebframework.utils.StringUtils;
import org.hswebframework.utils.time.DateFormatter;

public class NumberValueConverter
implements ValueConverter {
    private Function<Number, Object> converter;

    public NumberValueConverter(Function<Number, Object> converter) {
        this.converter = converter;
    }

    public NumberValueConverter(Class javaType) {
        this.converter = javaType == Integer.TYPE || javaType == Integer.class ? Number::intValue : (javaType == Double.TYPE || javaType == Double.class ? Number::doubleValue : (javaType == Long.TYPE || javaType == Long.class ? Number::longValue : (javaType == Byte.TYPE || javaType == Byte.class ? Number::byteValue : (javaType == Boolean.TYPE || javaType == Boolean.class ? num -> num.byteValue() != 0 : (javaType == Character.TYPE || javaType == Character.class ? num -> Character.valueOf((char)num.intValue()) : (ClassUtils.instanceOf((Class)javaType, Date.class) ? num -> {
            try {
                Date date = (Date)javaType.newInstance();
                date.setTime(num.longValue());
                return date;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } : num -> num))))));
    }

    public Object getData(Object value) {
        Date date;
        if (StringUtils.isNullOrEmpty((Object)value)) {
            return null;
        }
        if (value instanceof Number) {
            return value;
        }
        if (value instanceof Date) {
            value = ((Date)value).getTime();
        } else if (!StringUtils.isNumber((Object)value) && null != (date = DateFormatter.fromString((String)String.valueOf(value)))) {
            value = date.getTime();
        }
        if (StringUtils.isNumber((Object)value)) {
            return this.converter.apply(new BigDecimal(String.valueOf(value)));
        }
        if (Boolean.TRUE.equals(value)) {
            return 1;
        }
        if (Boolean.FALSE.equals(value)) {
            return 0;
        }
        throw new UnsupportedOperationException("\u503c" + value + "\u65e0\u6cd5\u8f6c\u6362\u4e3a\u6570\u5b57");
    }

    public Object getValue(Object data) {
        Date date;
        if (data instanceof String) {
            if (StringUtils.isNumber((Object)data)) {
                data = new BigDecimal((String)data);
            }
        } else if (!StringUtils.isNumber((Object)data) && null != (date = DateFormatter.fromString((String)String.valueOf(data)))) {
            data = date.getTime();
        }
        if (data instanceof Number) {
            return this.converter.apply((Number)data);
        }
        return data;
    }
}

