/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.meta.parser;

import java.sql.JDBCType;
import org.hswebframework.ezorm.rdb.executor.SqlExecutor;
import org.hswebframework.ezorm.rdb.meta.parser.AbstractTableMetaParser;
import org.hswebframework.ezorm.rdb.render.dialect.Dialect;
import org.hswebframework.ezorm.rdb.render.dialect.MSSQLDialect;

public class SqlServer2012TableMetaParser
extends AbstractTableMetaParser {
    static String TABLE_META_SQL = "SELECT \nc.name as name,\nt.name as data_type,\nc.length as data_length,\nc.xscale as data_scale,\nc.xprec as data_precision,\ncase when c.isnullable=1 then 0 else  1 end as [not-null],\ncast(p.value as varchar(500)) as comment\nFROM syscolumns c\ninner join  systypes t on c.xusertype = t.xusertype \nleft join sys.extended_properties p on c.id=p.major_id and c.colid=p.minor_id\nWHERE c.id = object_id(#{table})";

    public SqlServer2012TableMetaParser(SqlExecutor sqlExecutor) {
        super(sqlExecutor);
        this.jdbcTypeMap.put("bigint", JDBCType.BIGINT);
        this.jdbcTypeMap.put("binary", JDBCType.BINARY);
        this.jdbcTypeMap.put("bit", JDBCType.BIT);
        this.jdbcTypeMap.put("char", JDBCType.CHAR);
        this.jdbcTypeMap.put("datetime", JDBCType.TIMESTAMP);
        this.jdbcTypeMap.put("decimal", JDBCType.DECIMAL);
        this.jdbcTypeMap.put("float", JDBCType.FLOAT);
        this.jdbcTypeMap.put("image", JDBCType.LONGVARBINARY);
        this.jdbcTypeMap.put("int", JDBCType.INTEGER);
        this.jdbcTypeMap.put("money", JDBCType.DECIMAL);
        this.jdbcTypeMap.put("nchar", JDBCType.CHAR);
        this.jdbcTypeMap.put("ntext", JDBCType.LONGVARCHAR);
        this.jdbcTypeMap.put("numeric", JDBCType.NUMERIC);
        this.jdbcTypeMap.put("nvarchar", JDBCType.VARCHAR);
        this.jdbcTypeMap.put("real", JDBCType.REAL);
        this.jdbcTypeMap.put("smalldatetime", JDBCType.TIMESTAMP);
        this.jdbcTypeMap.put("smallint", JDBCType.SMALLINT);
        this.jdbcTypeMap.put("smallmoney", JDBCType.DECIMAL);
        this.jdbcTypeMap.put("sql_variant", JDBCType.VARCHAR);
        this.jdbcTypeMap.put("sysname", JDBCType.VARCHAR);
        this.jdbcTypeMap.put("text", JDBCType.LONGVARCHAR);
        this.jdbcTypeMap.put("timestamp", JDBCType.BINARY);
        this.jdbcTypeMap.put("tinyint", JDBCType.TINYINT);
        this.jdbcTypeMap.put("uniqueidentifier", JDBCType.CHAR);
        this.jdbcTypeMap.put("varbinary", JDBCType.VARBINARY);
        this.jdbcTypeMap.put("varchar", JDBCType.VARCHAR);
    }

    @Override
    Dialect getDialect() {
        return MSSQLDialect.MSSQL;
    }

    @Override
    String getTableMetaSql(String tname) {
        return TABLE_META_SQL;
    }

    @Override
    String getTableCommentSql(String tname) {
        return "select cast(p.value as varchar(500)) as comment from sys.extended_properties p  where p.major_id=object_id(#{table}) and p.minor_id=0";
    }

    @Override
    String getAllTableSql() {
        return "select name from sysobjects where xtype='U'";
    }

    @Override
    String getTableExistsSql() {
        return "select count(1) as total from sysobjects where xtype='U' and name = #{table}";
    }
}

