/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.render.dialect;

import java.sql.JDBCType;
import java.util.List;
import java.util.StringJoiner;
import org.hswebframework.ezorm.rdb.executor.SqlExecutor;
import org.hswebframework.ezorm.rdb.meta.parser.H2TableMetaParser;
import org.hswebframework.ezorm.rdb.meta.parser.TableMetaParser;
import org.hswebframework.ezorm.rdb.render.dialect.DefaultDialect;
import org.hswebframework.ezorm.rdb.render.dialect.term.BoostTermTypeMapper;
import org.hswebframework.utils.StringUtils;

public class H2Dialect
extends DefaultDialect {
    protected H2Dialect() {
        this.defaultDataTypeMapper = meta -> meta.getJdbcType().getName().toLowerCase();
        this.setDataTypeMapper(JDBCType.VARCHAR, meta -> StringUtils.concat((Object[])new Object[]{"varchar(", meta.getLength(), ")"}));
        this.setDataTypeMapper(JDBCType.TIMESTAMP, meta -> "timestamp");
        this.setDataTypeMapper(JDBCType.SMALLINT, meta -> "smallint");
        this.setDataTypeMapper(JDBCType.BIGINT, meta -> "bigint");
        this.setDataTypeMapper(JDBCType.TIME, meta -> "timestamp");
        this.setDataTypeMapper(JDBCType.DATE, meta -> "date");
        this.setDataTypeMapper(JDBCType.CLOB, meta -> "clob");
        this.setDataTypeMapper(JDBCType.BLOB, meta -> "blob");
        this.setDataTypeMapper(JDBCType.INTEGER, meta -> "int");
        this.setDataTypeMapper(JDBCType.NUMERIC, meta -> StringUtils.concat((Object[])new Object[]{"decimal(", meta.getPrecision(), ",", meta.getScale(), ")"}));
        this.setDataTypeMapper(JDBCType.TINYINT, meta -> "tinyint");
        this.setDataTypeMapper(JDBCType.DECIMAL, meta -> StringUtils.concat((Object[])new Object[]{"decimal(", meta.getPrecision(), ",", meta.getScale(), ")"}));
        this.setDataTypeMapper(JDBCType.OTHER, meta -> "other");
        this.installFunction("concat", param -> {
            List<Object> listParam = BoostTermTypeMapper.convertList(param.getParam());
            StringJoiner joiner = new StringJoiner("||");
            listParam.stream().map(String::valueOf).forEach(joiner::add);
            return joiner.toString();
        });
        this.installFunction("bitand", param -> {
            List<Object> listParam = BoostTermTypeMapper.convertList(param.getParam());
            if (listParam.size() != 2) {
                throw new IllegalArgumentException("[BITAND]\u53c2\u6570\u957f\u5ea6\u5fc5\u987b\u4e3a2");
            }
            StringJoiner joiner = new StringJoiner(",", "BITAND(", ")");
            listParam.stream().map(String::valueOf).forEach(joiner::add);
            return joiner.toString();
        });
    }

    @Override
    public String getQuoteStart() {
        return "\"";
    }

    @Override
    public String getQuoteEnd() {
        return "\"";
    }

    @Override
    public String doPaging(String sql, int pageIndex, int pageSize) {
        return sql + " limit " + pageSize * pageIndex + "," + pageSize;
    }

    @Override
    public boolean columnToUpperCase() {
        return true;
    }

    @Override
    public TableMetaParser getDefaultParser(SqlExecutor sqlExecutor) {
        return new H2TableMetaParser(sqlExecutor);
    }
}

