/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.render.support.mysql;

import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.hswebframework.ezorm.core.param.Param;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.ezorm.rdb.executor.SQL;
import org.hswebframework.ezorm.rdb.meta.RDBTableMetaData;
import org.hswebframework.ezorm.rdb.render.SqlAppender;
import org.hswebframework.ezorm.rdb.render.dialect.Dialect;
import org.hswebframework.ezorm.rdb.render.support.simple.CommonSqlRender;
import org.hswebframework.ezorm.rdb.render.support.simple.SimpleSQL;
import org.hswebframework.ezorm.rdb.render.support.simple.SimpleWhereSqlBuilder;

public class MysqlDeleteSqlRender
extends CommonSqlRender<Param> {
    private Dialect dialect;

    public MysqlDeleteSqlRender(Dialect dialect) {
        this.setDialect(dialect);
    }

    @Override
    public SQL render(RDBTableMetaData metaData, Param param) {
        return new SimpleDeleteSqlRenderProcess(metaData, param).process();
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    class SimpleDeleteSqlRenderProcess
    extends SimpleWhereSqlBuilder {
        private RDBTableMetaData metaData;
        private Param param;
        private SqlAppender whereSql = new SqlAppender();

        public SimpleDeleteSqlRenderProcess(RDBTableMetaData metaData, Param param) {
            this.metaData = metaData;
            this.param = param;
            List<Term> terms = param.getTerms();
            terms = terms.stream().filter(term -> term.getColumn() == null || !term.getColumn().contains(".")).collect(Collectors.toList());
            param.setTerms(terms);
            this.buildWhere(metaData, "", terms, this.whereSql, new HashSet<String>());
            if (!this.whereSql.isEmpty()) {
                this.whereSql.removeFirst();
            }
        }

        public SQL process() {
            SqlAppender appender = new SqlAppender();
            appender.add("DELETE ", this.metaData.getAlias(), " FROM ", this.metaData.getName(), " ", this.metaData.getAlias());
            if (this.whereSql.isEmpty()) {
                throw new UnsupportedOperationException("\u7981\u6b62\u6267\u884c\u672a\u8bbe\u7f6e\u4efb\u4f55\u6761\u4ef6\u7684\u5220\u9664\u64cd\u4f5c!");
            }
            appender.add(" WHERE", " ").addAll(this.whereSql);
            String sql = appender.toString();
            SimpleSQL simpleSQL = new SimpleSQL(sql, this.param);
            return simpleSQL;
        }

        @Override
        public Dialect getDialect() {
            return MysqlDeleteSqlRender.this.dialect;
        }
    }
}

