/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.simple;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.hswebframework.ezorm.core.NestConditional;
import org.hswebframework.ezorm.core.ObjectWrapper;
import org.hswebframework.ezorm.core.Query;
import org.hswebframework.ezorm.core.SimpleNestConditional;
import org.hswebframework.ezorm.core.TermTypeConditionalSupport;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.ezorm.core.param.SqlTerm;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.ezorm.rdb.RDBQuery;
import org.hswebframework.ezorm.rdb.executor.SQL;
import org.hswebframework.ezorm.rdb.executor.SqlExecutor;
import org.hswebframework.ezorm.rdb.meta.RDBTableMetaData;
import org.hswebframework.ezorm.rdb.render.SqlRender;
import org.hswebframework.ezorm.rdb.simple.SimpleTable;
import org.hswebframework.ezorm.rdb.simple.ValidatorAndTriggerSupport;
import org.hswebframework.ezorm.rdb.simple.wrapper.TriggerWrapper;
import org.hswebframework.utils.StringUtils;

class SimpleQuery<T>
extends ValidatorAndTriggerSupport<Query<T>>
implements RDBQuery<T> {
    private SimpleTable<T> table;
    private QueryParam queryParam;
    private SqlRender<QueryParam> render;
    private SqlExecutor sqlExecutor;
    private SqlRender<QueryParam> totalRender;
    private ObjectWrapper<T> objectWrapper;
    private TermTypeConditionalSupport.Accepter accepter = this::and;

    public SimpleQuery(SimpleTable<T> table, SqlExecutor sqlExecutor, ObjectWrapper<T> objectWrapper) {
        this.table = table;
        this.render = table.getMeta().getDatabaseMetaData().getRenderer(SqlRender.TYPE.SELECT);
        this.totalRender = table.getMeta().getDatabaseMetaData().getRenderer(SqlRender.TYPE.SELECT_TOTAL);
        this.objectWrapper = new TriggerWrapper<T>(table.getDatabase(), table, objectWrapper);
        this.sqlExecutor = sqlExecutor;
        this.queryParam = new QueryParam();
    }

    @Override
    public RDBQuery<T> setParam(QueryParam param) {
        this.queryParam = param;
        return this;
    }

    @Override
    public RDBQuery<T> select(String ... fields) {
        this.queryParam.includes(fields);
        return this;
    }

    @Override
    public RDBQuery<T> selectExcludes(String ... fields) {
        this.queryParam.excludes(fields);
        return this;
    }

    protected Query<T> addSqlTerm(SqlTerm term) {
        this.queryParam.addTerm((Term)term);
        return this;
    }

    public RDBQuery<T> and() {
        this.setAnd();
        this.accepter = this::and;
        return this;
    }

    public RDBQuery<T> or() {
        this.setOr();
        this.accepter = this::or;
        return this;
    }

    public TermTypeConditionalSupport.Accepter getAccepter() {
        return this.accepter;
    }

    public RDBQuery<T> and(String condition, String termType, Object value) {
        this.queryParam.and(condition, termType, value);
        return this;
    }

    public RDBQuery<T> or(String condition, String termType, Object value) {
        this.queryParam.or(condition, termType, value);
        return this;
    }

    public NestConditional<Query<T>> nest() {
        return new SimpleNestConditional((TermTypeConditionalSupport)this, this.queryParam.nest());
    }

    public NestConditional<Query<T>> nest(String column, Object value) {
        return new SimpleNestConditional((TermTypeConditionalSupport)this, this.queryParam.nest(column, value));
    }

    public NestConditional<Query<T>> orNest() {
        return new SimpleNestConditional((TermTypeConditionalSupport)this, this.queryParam.orNest());
    }

    public NestConditional<Query<T>> orNest(String column, Object value) {
        return new SimpleNestConditional((TermTypeConditionalSupport)this, this.queryParam.orNest(column, value));
    }

    @Override
    public RDBQuery<T> orderByAsc(String field) {
        this.queryParam.orderBy(field).asc();
        return this;
    }

    @Override
    public RDBQuery<T> orderByDesc(String field) {
        this.queryParam.orderBy(field).desc();
        return this;
    }

    @Override
    public RDBQuery<T> noPaging() {
        this.queryParam.setPaging(false);
        return this;
    }

    @Override
    public RDBQuery<T> forUpdate() {
        this.queryParam.setForUpdate(true);
        return this;
    }

    @Override
    public List<T> list() throws SQLException {
        boolean supportDone;
        QueryParam param = this.queryParam.clone();
        Map<String, Object> context = null;
        boolean supportBefore = !this.triggerSkip && this.getTableMeta().triggerIsSupport("select.before");
        boolean bl = supportDone = !this.triggerSkip && this.getTableMeta().triggerIsSupport("select.before");
        if (supportBefore || supportDone) {
            context = this.table.getDatabase().getTriggerContextRoot();
            context.put("table", this.table);
            context.put("database", this.table.getDatabase());
            context.put("param", param);
            context.put("type", "single");
        }
        if (supportBefore) {
            this.trigger("select.before", context);
        }
        param.setPaging(false);
        SQL sql = this.render.render(this.table.getMeta(), param);
        List<T> list = this.sqlExecutor.list(sql, this.objectWrapper);
        if (supportDone) {
            context.put("data", list);
            this.trigger("select.done", context);
        }
        return list;
    }

    @Override
    public T single() throws SQLException {
        boolean supportDone;
        QueryParam param = this.queryParam.clone();
        Map<String, Object> context = null;
        boolean supportBefore = !this.triggerSkip && this.getTableMeta().triggerIsSupport("select.before");
        boolean bl = supportDone = !this.triggerSkip && this.getTableMeta().triggerIsSupport("select.before");
        if (supportBefore || supportDone) {
            context = this.table.getDatabase().getTriggerContextRoot();
            context.put("table", this.table);
            context.put("database", this.table.getDatabase());
            context.put("param", param);
            context.put("type", "single");
        }
        if (supportBefore) {
            this.trigger("select.before", context);
        }
        if (!param.isForUpdate()) {
            param.doPaging(0, 1);
        }
        SQL sql = this.render.render(this.table.getMeta(), param);
        T data = this.sqlExecutor.single(sql, this.objectWrapper);
        if (supportDone) {
            context.put("data", data);
            this.trigger("select.done", context);
        }
        return data;
    }

    @Override
    public List<T> list(int pageIndex, int pageSize) throws SQLException {
        boolean supportDone;
        QueryParam param = this.queryParam.clone();
        Map<String, Object> context = null;
        boolean supportBefore = !this.triggerSkip && this.getTableMeta().triggerIsSupport("select.before");
        boolean bl = supportDone = !this.triggerSkip && this.getTableMeta().triggerIsSupport("select.before");
        if (supportBefore || supportDone) {
            context = this.table.getDatabase().getTriggerContextRoot();
            context.put("table", this.table);
            context.put("database", this.table.getDatabase());
            context.put("param", param);
            context.put("type", "listPage");
        }
        if (supportBefore) {
            this.trigger("select.before", context);
        }
        param.doPaging(pageIndex, pageSize);
        SQL sql = this.render.render(this.table.getMeta(), param.doPaging(pageIndex, pageSize));
        List<T> list = this.sqlExecutor.list(sql, this.objectWrapper);
        if (supportDone) {
            context.put("data", list);
            this.trigger("select.done", context);
        }
        return list;
    }

    @Override
    public int total() throws SQLException {
        boolean supportDone;
        QueryParam param = this.queryParam.clone();
        Map<String, Object> context = null;
        boolean supportBefore = !this.triggerSkip && this.getTableMeta().triggerIsSupport("select.before");
        boolean bl = supportDone = !this.triggerSkip && this.getTableMeta().triggerIsSupport("select.before");
        if (supportBefore || supportDone) {
            context = this.table.getDatabase().getTriggerContextRoot();
            context.put("table", this.table);
            context.put("database", this.table.getDatabase());
            context.put("param", param);
            context.put("type", "total");
        }
        if (supportBefore) {
            this.trigger("select.before", context);
        }
        SQL sql = this.totalRender.render(this.table.getMeta(), param);
        TotalWrapper totalWrapper = new TotalWrapper();
        this.sqlExecutor.single(sql, totalWrapper);
        if (supportDone) {
            context.put("total", totalWrapper.getTotal());
            this.trigger("select.done", context);
        }
        return totalWrapper.getTotal();
    }

    @Override
    RDBTableMetaData getTableMeta() {
        return this.table.getMeta();
    }

    public static class TotalWrapper
    implements ObjectWrapper {
        private int total;

        public Class<Object> getType() {
            return Object.class;
        }

        public int getTotal() {
            return this.total;
        }

        public Object newInstance() {
            return new Object();
        }

        public void wrapper(Object instance, int index, String attr, Object value) {
            if ("TOTAL".equals(attr.toUpperCase())) {
                this.total = StringUtils.toInt((Object)value);
            }
        }

        public boolean done(Object instance) {
            return false;
        }
    }
}

